/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.CustomPortletModeType;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.SupportedModesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedModesServiceImpl
implements SupportedModesService {
    private static final Logger LOG = LoggerFactory.getLogger(SupportedModesServiceImpl.class);
    private Set<PortletMode> supportedPortletModesByPortal = new HashSet<PortletMode>();
    private final PropertyConfigService propertyService;
    private final PortletContextService portletContextService;
    private final PortletRegistryService portletRegistry;

    public SupportedModesServiceImpl(PropertyConfigService propertyService, PortletContextService portletContextService, PortletRegistryService portletRegistry) {
        this.propertyService = propertyService;
        this.portletContextService = portletContextService;
        this.portletRegistry = portletRegistry;
        this.loadPortalModes();
    }

    public boolean isPortletModeSupported(String portletId, String mode) {
        return this.isPortletModeSupportedByPortal(mode) && this.isPortletModeSupportedByPortlet(portletId, mode) || this.isPortletManagedMode(portletId, mode);
    }

    public boolean isPortletModeSupportedByPortal(String mode) {
        return this.supportedPortletModesByPortal.contains(new PortletMode(mode));
    }

    public boolean isPortletModeSupportedByPortlet(String portletId, String mode) {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        try {
            if (this.portletRegistry == null) {
                LOG.error("Optional Portlet Registry Service not found.");
                throw new PortletContainerException("Optional Portlet Registry Service not found.");
            }
            PortletApplicationDefinition ctx = this.portletRegistry.getPortletApplication(applicationName);
            for (PortletDefinition dd : ctx.getPortlets()) {
                if (!portletName.equals(dd.getPortletName())) continue;
                for (Supports sd : dd.getSupports()) {
                    if (sd.getPortletModes() == null) {
                        if (!mode.equalsIgnoreCase(PortletMode.VIEW.toString())) continue;
                        return true;
                    }
                    Iterator pd = sd.getPortletModes().iterator();
                    while (pd.hasNext()) {
                        if (!mode.equalsIgnoreCase((String)pd.next())) continue;
                        return true;
                    }
                }
            }
        }
        catch (PortletContainerException e) {
            LOG.error("Error determining mode support.", (Throwable)e);
        }
        LOG.info("Portlet mode '" + mode + "' not found for portletId: '" + portletId + "'");
        return false;
    }

    private void loadPortalModes() {
        LOG.debug("Loading supported portal modes...");
        for (String mode : this.propertyService.getSupportedPortletModes()) {
            LOG.debug("Loading mode [" + mode + "]");
            this.supportedPortletModesByPortal.add(new PortletMode(mode));
        }
        LOG.debug("Loaded [" + this.supportedPortletModesByPortal.size() + "] supported portal modes");
    }

    public boolean isPortletManagedMode(String portletId, String mode) {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        try {
            PortletApplicationDefinition portletApp = this.portletRegistry.getPortletApplication(applicationName);
            for (CustomPortletModeType customMode : portletApp.getCustomPortletModes()) {
                boolean isPortletManagedMode = !customMode.isPortalManaged();
                if (!isPortletManagedMode || !customMode.getPortletMode().equalsIgnoreCase(mode)) continue;
                return true;
            }
        }
        catch (PortletContainerException e) {
            LOG.error("Error determining portlet managed mode support, so we assume that it is false.", (Throwable)e);
        }
        return false;
    }

    public Set<PortletMode> getSupportedPortletModes(String portletId) throws PortletContainerException {
        String applicationId;
        HashSet<PortletMode> modeSet = new HashSet<PortletMode>();
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        if (this.portletRegistry == null) {
            LOG.error("Optional Portlet Registry Service not found.");
            throw new PortletContainerException("Optional Portlet Registry Service not found.");
        }
        PortletApplicationDefinition portletApp = this.portletRegistry.getPortletApplication(applicationName);
        for (PortletDefinition dd : portletApp.getPortlets()) {
            if (!portletName.equals(dd.getPortletName())) continue;
            for (Supports sd : dd.getSupports()) {
                if (sd.getPortletModes() == null) {
                    modeSet.add(PortletMode.VIEW);
                    continue;
                }
                Iterator pd = sd.getPortletModes().iterator();
                while (pd.hasNext()) {
                    modeSet.add(new PortletMode((String)pd.next()));
                }
            }
        }
        return modeSet;
    }

    public PortletConfig getPortletConfig(String portletId) throws PortletContainerException {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        return this.portletContextService.getPortletConfig(applicationName, portletName);
    }
}

