/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.WindowState;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.CustomWindowState;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.SupportedWindowStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportedWindowStateServiceImpl
implements SupportedWindowStateService {
    private static final Logger LOG = LoggerFactory.getLogger(SupportedWindowStateServiceImpl.class);
    protected final PropertyConfigService propertyService;
    protected final PortletRegistryService portletRegistry;
    protected Set portalSupportedWindowStates = new HashSet(3);
    protected static final Set JSR168_WINDOW_STATES = new HashSet(3);

    public SupportedWindowStateServiceImpl(PropertyConfigService propertyService, PortletRegistryService portletRegistry) {
        CharSequence msg;
        this.propertyService = propertyService;
        this.portletRegistry = portletRegistry;
        LOG.debug("Initializing SupportedWindowStateService... ");
        this.portalSupportedWindowStates = propertyService.getSupportedWindowStates();
        if (LOG.isDebugEnabled()) {
            msg = new StringBuffer();
            if (this.portalSupportedWindowStates != null) {
                ((StringBuffer)msg).append("Portal supports [" + this.portalSupportedWindowStates.size() + "] window states.  ");
                Iterator i = this.portalSupportedWindowStates.iterator();
                while (i.hasNext()) {
                    ((StringBuffer)msg).append("[" + i.next() + "]");
                    if (!i.hasNext()) continue;
                    ((StringBuffer)msg).append(", ");
                }
                LOG.debug(((StringBuffer)msg).toString());
            }
        }
        if (this.portalSupportedWindowStates == null) {
            msg = "Portal supported window states is null!";
            LOG.error("Portal supported window states is null!");
            throw new DriverConfigurationException("Portal supported window states is null!");
        }
        LOG.debug("SupportedWindowStateService initialized.");
    }

    public boolean isWindowStateSupported(String portletId, String state) {
        if (JSR168_WINDOW_STATES.contains(state)) {
            return true;
        }
        return this.isWindowStateSupportedByPortal(state) && this.isWindowStateSupportedByPortlet(portletId, state);
    }

    public boolean isWindowStateSupportedByPortal(String state) {
        return this.portalSupportedWindowStates.contains(state);
    }

    public boolean isWindowStateSupportedByPortlet(String portletId, String state) {
        String appId;
        if (portletId == null || state == null || portletId.trim().equals("") || state.trim().equals("")) {
            StringBuffer errMsg = new StringBuffer("Cannot determine supported window states for portletId [" + portletId + "] and window state [" + state + "].  ");
            String msg = errMsg.append("One or both of the arguments is empty or null.").toString();
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (JSR168_WINDOW_STATES.contains(new WindowState(state))) {
            return true;
        }
        String applicationName = appId = PortletWindowConfig.parseContextPath((String)portletId);
        PortletApplicationDefinition portletAppDD = null;
        if (this.portletRegistry == null) {
            return false;
        }
        try {
            portletAppDD = this.portletRegistry.getPortletApplication(applicationName);
        }
        catch (PortletContainerException e) {
            StringBuffer errMsg = new StringBuffer("Cannot determine supported window states for portletId [" + portletId + "] and window state [" + state + "].  ");
            String msg = errMsg.append("Unable to access the Portlet Registry Service.").toString();
            LOG.error(msg, (Throwable)e);
        }
        List customWindowStates = portletAppDD.getCustomWindowStates();
        if (customWindowStates != null) {
            for (CustomWindowState customState : customWindowStates) {
                if (!customState.getWindowState().equals(state)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        JSR168_WINDOW_STATES.add(WindowState.MAXIMIZED);
        JSR168_WINDOW_STATES.add(WindowState.MINIMIZED);
        JSR168_WINDOW_STATES.add(WindowState.NORMAL);
    }
}

