/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePortalURLImpl
implements PortalURL {
    private static final Logger LOG = LoggerFactory.getLogger(RelativePortalURLImpl.class);
    private String urlBase;
    private String servletPath;
    private String renderPath;
    private String actionWindow;
    private String eventWindow;
    private String resourceWindow;
    private String cacheLevel;
    private String resourceID;
    private Map<String, String[]> publicParameterCurrent = new HashMap<String, String[]>();
    private Map<String, String[]> publicParameterNew = new HashMap<String, String[]>();
    private Map<String, String[]> privateRenderParameters = new HashMap<String, String[]>();
    private PortalURLParser urlParser;
    private Map<String, WindowState> windowStates = new HashMap<String, WindowState>();
    private Map<String, PortletMode> portletModes = new HashMap<String, PortletMode>();
    private Map<String, PortalURLParameter> parameters = new HashMap<String, PortalURLParameter>();

    public RelativePortalURLImpl(String urlBase, String contextPath, String servletName, PortalURLParser urlParser) {
        this.urlBase = urlBase;
        StringBuffer buffer = new StringBuffer();
        buffer.append(contextPath);
        buffer.append(servletName);
        this.servletPath = buffer.toString();
        this.urlParser = urlParser;
    }

    private RelativePortalURLImpl() {
    }

    public void setRenderPath(String renderPath) {
        this.renderPath = renderPath;
    }

    public String getRenderPath() {
        return this.renderPath;
    }

    public void addParameter(PortalURLParameter param) {
        this.parameters.put(param.getWindowId() + param.getName(), param);
    }

    public Collection<PortalURLParameter> getParameters() {
        return this.parameters.values();
    }

    public void setActionWindow(String actionWindow) {
        this.actionWindow = actionWindow;
    }

    public String getActionWindow() {
        return this.actionWindow;
    }

    public void setEventWindow(String eventWindow) {
        this.eventWindow = eventWindow;
    }

    public String getEventWindow() {
        return this.eventWindow;
    }

    public Map<String, PortletMode> getPortletModes() {
        return Collections.unmodifiableMap(this.portletModes);
    }

    public PortletMode getPortletMode(String windowId) {
        PortletMode mode = this.portletModes.get(windowId);
        if (mode == null) {
            mode = PortletMode.VIEW;
        }
        return mode;
    }

    public void setPortletMode(String windowId, PortletMode portletMode) {
        this.portletModes.put(windowId, portletMode);
    }

    public Map<String, WindowState> getWindowStates() {
        return Collections.unmodifiableMap(this.windowStates);
    }

    public WindowState getWindowState(String windowId) {
        WindowState state = this.windowStates.get(windowId);
        if (state == null) {
            state = WindowState.NORMAL;
        }
        return state;
    }

    public void setWindowState(String windowId, WindowState windowState) {
        this.windowStates.put(windowId, windowState);
    }

    public void clearParameters(String windowId) {
        Iterator<Map.Entry<String, PortalURLParameter>> it = this.parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PortalURLParameter> entry = it.next();
            PortalURLParameter param = entry.getValue();
            if (param.getWindowId() == null || !param.getWindowId().equals(windowId)) continue;
            it.remove();
        }
    }

    public void setCacheability(String cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getCacheability() {
        return this.cacheLevel;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String toString() {
        return this.toURL(false);
    }

    public String toURL(boolean absolute) {
        String result = this.urlParser.toString((PortalURL)this);
        if (absolute) {
            return this.urlBase + result;
        }
        return result;
    }

    @Deprecated
    public String getServerURI() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public synchronized PortalURL clone() {
        RelativePortalURLImpl portalURL = new RelativePortalURLImpl();
        portalURL.servletPath = this.servletPath;
        portalURL.parameters = new HashMap<String, PortalURLParameter>(this.parameters);
        portalURL.privateRenderParameters = new HashMap<String, String[]>(this.privateRenderParameters);
        portalURL.portletModes = new HashMap<String, PortletMode>(this.portletModes);
        portalURL.windowStates = new HashMap<String, WindowState>(this.windowStates);
        portalURL.cacheLevel = this.cacheLevel;
        portalURL.resourceID = this.resourceID;
        portalURL.renderPath = this.renderPath;
        portalURL.actionWindow = this.actionWindow;
        portalURL.urlParser = this.urlParser;
        portalURL.resourceWindow = this.resourceWindow;
        portalURL.publicParameterCurrent = this.publicParameterCurrent;
        return portalURL;
    }

    public void addPublicRenderParametersNew(Map<String, String[]> parameters) {
        for (String key : parameters.keySet()) {
            if (this.publicParameterNew.containsKey(key)) {
                this.publicParameterNew.remove(key);
            }
            String[] values = parameters.get(key);
            this.publicParameterNew.put(key, values);
        }
    }

    public void addPublicParameterCurrent(String name, String[] values) {
        this.publicParameterCurrent.put(name, values);
    }

    public void addPublicParameterActionResourceParameter(String parameterName, String value) {
        if (this.publicParameterCurrent.containsKey(parameterName)) {
            String[] tmp = this.publicParameterCurrent.get(parameterName);
            String[] values = new String[tmp.length + 1];
            values[0] = value;
            for (int i = 0; i < tmp.length; ++i) {
                values[i + 1] = tmp[i];
            }
            this.publicParameterCurrent.remove(parameterName);
            this.publicParameterCurrent.put(parameterName, (String[])values.clone());
        } else {
            this.publicParameterCurrent.put(parameterName, new String[]{value});
        }
    }

    public Map<String, String[]> getPublicParameters() {
        String[] paramvalue;
        HashMap<String, String[]> tmp = new HashMap<String, String[]>();
        for (String paramname : this.publicParameterCurrent.keySet()) {
            if (this.publicParameterNew.containsKey(paramname)) continue;
            paramvalue = this.publicParameterCurrent.get(paramname);
            tmp.put(paramname, paramvalue);
        }
        for (String paramname : this.publicParameterNew.keySet()) {
            paramvalue = this.publicParameterNew.get(paramname);
            if (paramvalue[0] == null) continue;
            tmp.put(paramname, paramvalue);
        }
        return tmp;
    }

    public Map<String, String[]> getNewPublicParameters() {
        return this.publicParameterNew;
    }

    public Map<String, String[]> getPrivateRenderParameters() {
        return this.privateRenderParameters;
    }

    public PageConfig getPageConfig(ServletContext servletContext) {
        String requestedPageId = this.getRenderPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested Page: " + requestedPageId);
        }
        return ((DriverConfiguration)servletContext.getAttribute("driverConfig")).getPageConfig(requestedPageId);
    }

    public String getResourceWindow() {
        return this.resourceWindow;
    }

    public void setResourceWindow(String resourceWindow) {
        this.resourceWindow = resourceWindow;
    }

    public synchronized void merge(PortalURL url, String windowId) {
        this.actionWindow = url.getActionWindow();
        this.resourceWindow = url.getResourceWindow();
        this.setPortletMode(windowId, url.getPortletMode(windowId));
        this.setWindowState(windowId, url.getWindowState(windowId));
        this.setCacheability(url.getCacheability());
        this.setResourceID(url.getResourceID());
        this.clearParameters(windowId);
        for (PortalURLParameter param : url.getParameters()) {
            if (!windowId.equals(param.getWindowId())) continue;
            this.addParameter(new PortalURLParameter(param.getWindowId(), param.getName(), param.getValues()));
        }
        Map newPublicParameters = url.getNewPublicParameters();
        for (Map.Entry entry : newPublicParameters.entrySet()) {
            if (((String[])entry.getValue())[0] == null) {
                this.publicParameterCurrent.remove(entry.getKey());
                continue;
            }
            this.publicParameterCurrent.put((String)entry.getKey(), (String[])entry.getValue());
        }
    }
}

