/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.gui.action;

import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class BillAction
extends BaseAction {
    static Logger logger = Logger.getLogger((String)BillAction.class.getName());

    public void isBillOnlySupportWeb() throws Exception {
        String realUrl;
        String iserviceUrl = this.getRequest().getParameter("iservice_url");
        if (!StringUtils.isEmpty((String)iserviceUrl)) {
            this.writeAjaxData(true, null, iserviceUrl);
            return;
        }
        String billId = this.getRequest().getParameter("billId");
        logger.info((Object)("BillID=" + billId));
        billId = this.getRealBillID(billId);
        logger.info((Object)("RealBillID=" + billId));
        String billUrl = this.getRequest().getParameter("billUrl");
        logger.info((Object)("billUrl=" + billUrl));
        if (!StringUtils.isEmpty((String)billUrl) && !StringUtils.isEmpty((String)(realUrl = BillAction.getRealUrlByBillUrl(billUrl)))) {
            realUrl = realUrl.indexOf("?") > 0 ? realUrl + "&billId=" + URLEncoder.encode(billId, "utf-8") : realUrl + "?billId=" + URLEncoder.encode(billId, "utf-8");
            realUrl = BillAction.replaceAllStr(realUrl, "&", "^&");
            logger.info((Object)("Get real url [" + realUrl + "] from billUrl"));
            this.writeAjaxData(true, null, realUrl);
            return;
        }
        String url = BillAction.isBillOnlySupportWeb(billId);
        this.writeAjaxData(!StringUtils.isEmpty((String)url), null, url);
    }

    private String getRealBillID(String billId) {
        if (!StringUtils.isEmpty((String)billId)) {
            billId = billId.replaceAll("888", "/");
            billId = billId.replaceAll("999", "\\+");
        }
        return billId;
    }

    private static String getRealUrlByBillUrl(String billUrl) {
        int index1 = billUrl.indexOf("iservice_url");
        if (index1 >= 0) {
            int index;
            int index2 = billUrl.indexOf("&", index1);
            index2 = index2 > 0 ? index2 : billUrl.length();
            String param = billUrl.substring(index1, index2);
            logger.info((Object)param);
            if (!StringUtils.isEmpty((String)param) && (index = param.indexOf("=")) >= 0) {
                return param.substring(index + 1);
            }
        }
        return null;
    }

    public static String isBillOnlySupportWeb(String billId) throws Exception {
        boolean webOnly = true;
        if (webOnly) {
            String billUrl = BillAction.getWebBillUrl(billId);
            logger.info((Object)("BillUrl=" + billUrl));
            return billUrl;
        }
        return null;
    }

    public static String getWebBillUrl(String billId) throws Exception {
        String serverURL = "";
        String toUrl = BillAction.getUrlByBillID(billId);
        if (!StringUtils.isEmpty((String)toUrl)) {
            toUrl = toUrl.indexOf("?") > 0 ? toUrl + "&billId=" + URLEncoder.encode(billId, "utf-8") : toUrl + "?billId=" + URLEncoder.encode(billId, "utf-8");
            String url = serverURL + "/easweb" + toUrl;
            url = BillAction.replaceAllStr(url, "&", "^&");
            return url;
        }
        logger.warn((Object)("Get Bill url by [" + billId + "], but it's url is null"));
        return "";
    }

    private static String replaceAllStr(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    protected static String getUrlByBillID(String billID) {
        String srcEditUrl;
        String entityName;
        String url = BillAction.getWebBillURL(billID);
        if (!StringUtils.isEmpty((String)url)) {
            logger.info((Object)("_getUrlByBillID myUrl = " + url));
            return url;
        }
        EntityObjectInfo entityInfo = BillAction.getEntityObjectInfo(billID);
        String rootPackage = BillAction.rootPackage(entityInfo);
        String rootUrl = BillAction.rootUrl(rootPackage);
        if (!BillAction.isFileExist(rootUrl, entityName = BillAction.startLowerCase(entityInfo.getName()))) {
            return null;
        }
        url = srcEditUrl = rootUrl + entityName + "Edit.jsf";
        return url;
    }

    private static boolean isFileExist(String rootUrl, String entityName) {
        String filePath = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war" + rootUrl + entityName + "Edit.xhtml";
        return new File(filePath).exists();
    }

    private static String rootPackage(EntityObjectInfo entityInfo) {
        String str = entityInfo.getPackage();
        int index = str.lastIndexOf(".");
        if (index == -1) {
            return str;
        }
        return str.substring(0, index);
    }

    private static String rootUrl(String packageName) {
        String url;
        String prefix = "com.kingdee.eas";
        if (packageName.startsWith(prefix)) {
            packageName = packageName.substring(prefix.length());
        }
        if (!(url = packageName.replace('.', '/')).startsWith("/")) {
            url = "/" + url;
        }
        return url + "/";
    }

    private static String startLowerCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    private static String getWebBillURL(String billID) {
        String[] dynamicEditUrl = BillAction.getDynamicEditURLByBillId(billID);
        if (dynamicEditUrl != null && dynamicEditUrl.length == 2) {
            StringBuffer urlStr = new StringBuffer(dynamicEditUrl[0]);
            if (!StringUtils.isEmpty((String)dynamicEditUrl[1])) {
                urlStr.append(urlStr.indexOf("?") < 0 ? "?" : "&").append("uipk").append("=").append(dynamicEditUrl[1]);
            }
            logger.info((Object)("gui getWebBillURL-urlStr.toString()= " + urlStr.toString()));
            return urlStr.toString();
        }
        String webUIurl = BillAction.getWebUIurl(billID);
        if (webUIurl != null) {
            logger.info((Object)("gui getWebBillURL-webUIurl= " + webUIurl));
            return webUIurl;
        }
        return "";
    }

    public static String getWebUIurl(String billId) {
        if (billId == null) {
            return null;
        }
        EntityObjectInfo billObject = BillAction.getEntityObjectInfo(billId);
        if (billObject == null) {
            throw new IllegalArgumentException("BillObject is null");
        }
        String webUI = billObject.getExtendedProperty("webEditUI");
        return BillAction.webUIName2URL(webUI);
    }

    public static String webUIName2URL(String pk) {
        int i;
        if (pk == null || pk.length() == 0) {
            return null;
        }
        String PREFIX = "com.kingdee.eas";
        if (pk.startsWith("com.kingdee.eas")) {
            pk = pk.substring("com.kingdee.eas".length());
        }
        StringBuffer url = new StringBuffer();
        String[] ms = pk.split("\\.");
        if (ms.length > 2 && "web".equals(ms[ms.length - 2])) {
            for (i = 0; i < ms.length - 2; ++i) {
                url.append(ms[i]).append("/");
            }
        } else {
            for (i = 0; i < ms.length - 1; ++i) {
                url.append(ms[i]).append("/");
            }
        }
        String name = ms[ms.length - 1];
        name = name.substring(0, 1).toLowerCase() + name.substring(1) + ".jsf";
        url.append(name);
        return url.toString();
    }

    private static String[] getDynamicEditURLByBillId(String billId) {
        EntityObjectInfo vo = BillAction.getEntityObjectInfo(billId);
        if (vo != null) {
            String v = vo.getExtendedProperty("isDynamic");
            String editpk = vo.getExtendedProperty("webEditUI");
            if ("true".equalsIgnoreCase(v) && !StringUtils.isEmpty((String)editpk)) {
                return new String[]{"/winlet/edit/editUIProxy.jsf", editpk};
            }
        }
        return null;
    }

    private static EntityObjectInfo getEntityObjectInfo(String billId) {
        BOSUuid uuid = BOSUuid.read((String)billId);
        String billType = uuid.getType().toString();
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(new BOSObjectType(billType));
        return entity;
    }

    public static void main(String[] args) {
        String str = "/easweb/hr/affair/fluctuationBizBillList.jsf?iservice_url=/easweb/hr/affair/fluctuationBizBillEdit.jsf";
        int index1 = str.indexOf("iservice_url");
        if (index1 >= 0) {
            int index2 = str.indexOf("&", index1);
            index2 = index2 > 0 ? index2 : str.length();
            System.out.println(str.substring(index1, index2));
        }
    }
}

