/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.other.action;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.myeas.PersonalParamCollection;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.IOfficialAccount;
import com.kingdee.eas.base.uiframe.OfficialAccountFactory;
import com.kingdee.eas.base.uiframe.OfficialAccountInfo;
import com.kingdee.eas.base.uiframe.gzh.info.TokenInfo;
import com.kingdee.eas.base.uiframe.gzh.util.HashHmacCrypto;
import com.kingdee.eas.base.uiframe.gzh.util.SinatureUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BossPersonalAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(BossPersonalAction.class);
    public static final String SERVER_NAME = EasCloud.CLOUD_URL;
    public static final String SERVICE_TOKEN = "/linkceo/auth/product/token";
    private static final String CLIENT_ID = EasCloud.CLIENT_ID;
    private static final String CLIENT_SECRET = EasCloud.CLIENT_SECRET;
    private static final String LAOXUGZHTWEBIP = "LAOXUGZHTWEBIP";

    public void bossGzhGuide() {
        String flag = this.getRequest().getParameter("hideen");
        if ("true".equals(flag)) {
            this.storeBossGzhHidden();
            return;
        }
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        try {
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            String userId = userInfo.getId().toString();
            boolean Hidden = this.getBossGzhHidden(userId);
            if (!Hidden) {
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, null);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
    }

    private boolean getBossGzhHidden(String userId) {
        String paramValue = null;
        try {
            PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection("where user.id='" + userId + "' and paramName='" + LAOXUGZHTWEBIP + "'");
            paramValue = coll != null && coll.size() > 0 ? (coll.get(0) == null ? "1" : coll.get(0).getParamValue()) : "0";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            paramValue = "1";
        }
        return "1".equals(paramValue);
    }

    private void storeBossGzhHidden() {
        try {
            PersonalParamFactory.getRemoteInstance().updatePersonalParam(LAOXUGZHTWEBIP, "1");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void buildAccessTokenInfo() {
        boolean success = false;
        LocalErr localErr = null;
        TreeMap<String, String> params = new TreeMap<String, String>();
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            params.put("clientId", CLIENT_ID);
            String uid = userInfo.getUid();
            params.put("uid", StringUtils.isEmpty((String)uid) ? "unknown" : uid);
            params.put("dataCenterCode", ctx.getAIS());
            String userId = userInfo.getId().toString();
            params.put("erpId", userId);
            params.put("erpName", userInfo.getName());
            String erpPhone = userInfo.getCell();
            params.put("erpPhone", StringUtils.isEmpty((String)erpPhone) ? "unknown" : erpPhone);
            String erpEmail = userInfo.getEmail();
            params.put("erpEmail", StringUtils.isEmpty((String)erpEmail) ? "unknown" : erpEmail);
            params.put("prodInstCode", StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID());
            params.put("prodSN", StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum());
            params.put("prodName", "EAS");
            params.put("prodVersion", baseInfo.getVersion());
            params.put("prodCategoryCode", "EAS");
            params.put("prodDeployWay", "OfflineERP");
            params.put("prodClientType", "WEB");
            params.put("prodSoftcode", StringUtils.isEmpty((String)baseInfo.getMechineCode()) ? "unknown" : baseInfo.getMechineCode());
            params.put("prodDomain", "unknown");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            params.put("serviceEndDate", baseInfo.getServiceDate() == null ? "unknown" : sdf.format(baseInfo.getServiceDate()));
            params.put("userRole", "Normal");
            params.put("userSource", "Product");
            params.put("customerLevel", "unknown");
            String customerName = baseInfo.getLicenseTo();
            params.put("customerName", StringUtils.isEmpty((String)customerName) ? "unknown" : new String(Base64Encoder.base64ToByteArray((String)customerName), "GBK"));
            params.put("extParam", BossPersonalAction.buildExtParam(baseInfo, userInfo));
            String apiUrl = SERVER_NAME + SERVICE_TOKEN;
            String url = apiUrl + "?" + BossPersonalAction.concatUrl(params);
            final String nonce = UUID.randomUUID().toString().replace("-", "");
            final String timeStamp = String.valueOf(new Date().getTime() / 1000L);
            String signature = HashHmacCrypto.sign((String)"POST", (String)SERVICE_TOKEN, params, (TreeMap)new TreeMap<String, String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("X-Api-Nonce", nonce);
                    this.put("X-Api-TimeStamp", timeStamp);
                }
            }, (String)CLIENT_SECRET);
            signature = signature.replaceAll(System.getProperty("line.separator"), "");
            params.put("url", url);
            params.put("Nonce", nonce);
            params.put("TimeStamp", timeStamp);
            params.put("Signature", signature);
            success = true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, params);
    }

    private static String buildExtParam(LicenseBaseInfo baseInfo, UserInfo userInfo) throws Exception {
        JSONObject rs = new JSONObject();
        JSONObject noneParam = new JSONObject();
        noneParam.put("client_id", (Object)CLIENT_ID);
        JSONObject ksm = new JSONObject();
        ksm.put("client_id", (Object)CLIENT_ID);
        ksm.put("productCode", (Object)baseInfo.getSerialNum());
        ksm.put("userId", (Object)userInfo.getId().toString());
        String account = "";
        if (!StringUtils.isEmpty((String)baseInfo.getLicenseTo())) {
            account = new String(Base64Encoder.base64ToByteArray((String)baseInfo.getLicenseTo()), "GBK");
        }
        ksm.put("account", (Object)account);
        ksm.put("username", (Object)userInfo.getName());
        ksm.put("email", (Object)(userInfo.getEmail() == null ? "" : userInfo.getEmail()));
        ksm.put("telephone", (Object)(userInfo.getCell() == null ? "" : userInfo.getCell()));
        rs.put("EAS_KSM", (Object)ksm);
        rs.put("EAS_KINGDEE_CLUB", (Object)noneParam);
        rs.put("EAS_OPPORTUNITY", (Object)BossPersonalAction.buildMyBuiness(userInfo));
        rs.put("EAS_ONLINESERVICE", (Object)noneParam.clone());
        JSONObject os = new JSONObject();
        os.put("client_id", (Object)"200148");
        os.put("productNo", (Object)baseInfo.getSerialNum());
        rs.put("EAS_CLUB_ONLINESERVICE", (Object)os);
        return rs.toJSONString();
    }

    private static JSONObject buildMyBuiness(UserInfo userInfo) {
        JSONObject rs = new JSONObject();
        String userNumber = userInfo.getNumber();
        String userName = userInfo.getName();
        String phoneNum = userInfo.getCell();
        if (phoneNum == null) {
            phoneNum = "";
        }
        String source = "\u5916\u90e8\u63a8\u8350-EAS\u4ea7\u54c1\u7aef";
        rs.put("cellephone", (Object)phoneNum);
        rs.put("account", (Object)userNumber);
        rs.put("name", (Object)userName);
        rs.put("source", (Object)source);
        rs.put("client_id", (Object)CLIENT_ID);
        rs.put("company", (Object)"");
        return rs;
    }

    public void encryptAccessToken() {
        boolean success = false;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String accessToken = this.getRequest().getParameter("accessToken");
        final long timestamp = new Date().getTime();
        UserInfo userInfo = null;
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            TokenInfo accessTokenTemp;
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            final String userId = userInfo.getId().toString();
            if (!StringUtil.isEmpty((String)accessToken)) {
                BossPersonalAction.store(userId, accessToken);
            }
            if ((accessTokenTemp = BossPersonalAction.get(userId)) == null || accessTokenTemp.getTimestamp() + (long)(accessTokenTemp.getExpiresIn() * 1000) > timestamp + 86400000L) {
                data.put("accessToken", "NO");
                success = true;
                this.writeAjaxData(success, localErr, data);
                return;
            }
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            final String uid = StringUtils.isEmpty((String)userInfo.getUid()) ? "unknown" : userInfo.getUid();
            final String proSN = StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum();
            String encryptAccessToken = SinatureUtil.aesSign((SortedMap)new TreeMap<Object, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("clientid", CLIENT_ID);
                    this.put("uid", uid);
                    this.put("erpId", userId);
                    this.put("prodSN", proSN);
                    this.put("timestamp", timestamp);
                }
            }, (String)accessTokenTemp.getAccessToken());
            data.put("encryptAccessToken", encryptAccessToken);
            data.put("timestamp", timestamp);
            data.put("notifyStatus", accessTokenTemp.getNotifyStatus());
            success = true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, data);
    }

    private static String concatUrl(TreeMap<String, String> parameters) throws UnsupportedEncodingException {
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, String> element : parameters.entrySet()) {
            params.append(element.getKey());
            params.append("=");
            params.append(URLEncoder.encode(element.getValue(), "UTF-8"));
            params.append("&");
        }
        int iLen = params.length();
        if (iLen > 0) {
            params = params.deleteCharAt(iLen - 1);
        }
        return params.toString();
    }

    public static void store(String userId, String accessToken) {
        try {
            OfficialAccountInfo info = new OfficialAccountInfo();
            info.setToken(accessToken);
            BossPersonalAction.getBizInterface().delete("where creator.id='" + userId + "'");
            BossPersonalAction.getBizInterface().addnew((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static TokenInfo get(String userId) {
        TokenInfo token = null;
        try {
            CoreBaseCollection coll = BossPersonalAction.getBizInterface().getCollection("where creator.id='" + userId + "'");
            if (coll != null && coll.size() > 0) {
                OfficialAccountInfo info = (OfficialAccountInfo)coll.get(0);
                token = (TokenInfo)JSONObject.parseObject((String)info.getToken(), TokenInfo.class);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return token;
    }

    protected static IOfficialAccount getBizInterface() throws Exception {
        return OfficialAccountFactory.getRemoteInstance();
    }
}

