/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.other.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.PrivacySetAndIgnore;
import com.kingdee.eas.base.myeas.PersonalParamCollection;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.cloud.kbc.CloudLicenseUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.portal.biz.common.action.BaseAction;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageGuideAction
extends BaseAction {
    private static Logger logger = LoggerFactory.getLogger(PageGuideAction.class);
    private static final String[] guideTypes = new String[]{"portal_new_pageGuide", "portal_old_pageGuide", "portalAdminMenu_pageGuide", "pageAdd_pageGuide", "newContainer_edit_pageGuide", "newContainer_pageGuide"};
    private static final String SHOW_PAGE_GUIDE_DIALOG = "SHOW_PAGE_GUIDE_DIALOG";
    private static final String SHOW_PIRVACY_GUIDE_DIALOG = "SHOW_PIRVACY_GUIDE_DIALOG";

    public void showPageGuide() {
        String guideType = this.getRequest().getParameter("guideType");
        if (!ArrayUtils.contains((Object[])guideTypes, (Object)guideType)) {
            logger.error(guideType + " is not guideType!");
            return;
        }
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            String userId = userInfo.getId().toString();
            boolean startPageGuide = this.isStartPageGuide(userId);
            if (!startPageGuide) {
                logger.error("not start portal guide");
                return;
            }
            boolean Hidden = this.isHidePageGuide(userId, guideType);
            if (!Hidden) {
                this.writeAjaxData(true, null, null);
                this.hidePageGuide(guideType);
            } else {
                this.writeAjaxData(false, null, null);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
    }

    private boolean isHidePageGuide(String userId, String guideType) {
        String paramValue = null;
        try {
            PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection("where user.id='" + userId + "' and paramName='" + guideType + "'");
            paramValue = coll != null && coll.size() > 0 ? (coll.get(0) == null ? "1" : coll.get(0).getParamValue()) : "0";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            paramValue = "1";
        }
        return "1".equals(paramValue);
    }

    private void hidePageGuide(String guideType) {
        try {
            PersonalParamFactory.getRemoteInstance().updatePersonalParam(guideType, "1");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void getIsStartPageGuide() {
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            String userId = userInfo.getId().toString();
            boolean isStartPageGuide = this.isStartPageGuide(userId);
            this.writeAjaxData(isStartPageGuide, null, null);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeAjaxData(false, null, null);
        }
    }

    private boolean isStartPageGuide(String userId) throws BOSException {
        PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection("where user.id='" + userId + "' and paramName='" + SHOW_PAGE_GUIDE_DIALOG + "'");
        String paramValue = coll != null && coll.size() > 0 ? (coll.get(0) == null ? "1" : coll.get(0).getParamValue()) : "1";
        boolean isStartPageGuide = false;
        isStartPageGuide = "1".equals(paramValue);
        return isStartPageGuide;
    }

    private boolean IsShowPageGuideDialog(String userId) throws BOSException {
        PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection("where user.id='" + userId + "' and paramName='SHOW_PAGE_GUIDE_DIALOG'");
        String paramValue = coll != null && coll.size() > 0 ? (coll.get(0) == null ? "1" : "0") : "1";
        boolean isStartPageGuide = false;
        isStartPageGuide = "1".equals(paramValue);
        return isStartPageGuide;
    }

    private boolean IsShowPrivacyGuideDialog(String userId) throws BOSException {
        if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(userId)) {
            return false;
        }
        PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection("where user.id='" + userId + "' and paramName='SHOW_PIRVACY_GUIDE_DIALOG'");
        String paramValue = coll != null && coll.size() > 0 ? (coll.get(0) == null ? "1" : "0") : "1";
        return "1".equals(paramValue);
    }

    public void updateIsStartPageGuide() {
        try {
            String isShow = this.getRequest().getParameter("isShow");
            if (!"0".equals(isShow) && !"1".equals(isShow)) {
                isShow = "0";
            }
            this.hidePageGuideDialog();
            PersonalParamFactory.getRemoteInstance().updatePersonalParam(SHOW_PAGE_GUIDE_DIALOG, isShow);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void updateIsStartPrivacyGuide() {
        try {
            String isShow = this.getRequest().getParameter("isShow");
            if (!"0".equals(isShow) && !"1".equals(isShow)) {
                isShow = "0";
            }
            PersonalParamFactory.getRemoteInstance().updatePersonalParam(SHOW_PIRVACY_GUIDE_DIALOG, isShow);
            this.writeLogForPrivacy(isShow);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void writeLogForPrivacy(String isShow) {
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        IObjectPK logPK = "1".equals(isShow) ? LogUtil.beginLog((Context)ctx, (String)"\u9690\u79c1\u4e2d\u5fc3\u4e0a\u7ebf\u901a\u77e5", (BOSObjectType)new PrivacySetAndIgnore().getType(), null, (String)"\u9690\u79c1\u4e2d\u5fc3\u4e0a\u7ebf\u901a\u77e5") : LogUtil.beginLog((Context)ctx, (String)"\u9690\u79c1\u4e2d\u5fc3\u4e0a\u7ebf\u901a\u77e5", (BOSObjectType)new PrivacySetAndIgnore().getType(), null, (String)"\u9690\u79c1\u4e2d\u5fc3\u4e0a\u7ebf\u901a\u77e5");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    public void getIsShowPrivacyGuideDialog() {
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            String userId = userInfo.getId().toString();
            boolean isShowPageGuideDialog = this.IsShowPrivacyGuideDialog(userId);
            this.writeAjaxData(isShowPageGuideDialog, null, null);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
    }

    public void getIsShowPageGuideDialog() {
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            String userId = userInfo.getId().toString();
            boolean isShowPageGuideDialog = this.IsShowPageGuideDialog(userId);
            this.writeAjaxData(isShowPageGuideDialog, null, null);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
    }

    private void hidePageGuideDialog() {
        try {
            PersonalParamFactory.getRemoteInstance().updatePersonalParam(SHOW_PAGE_GUIDE_DIALOG, "0");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void getIsShowValidityNoticeUI() {
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            boolean isCurValidityNotice = CloudLicenseUtil.isCurValidityNotice((Context)ctx);
            if (!isCurValidityNotice) {
                this.writeAjaxData(false, null, null);
                return;
            }
            long effectDays = CloudLicenseUtil.getValidateEffectDays(null);
            this.writeAjaxData(true, null, effectDays);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
    }

    public void confirmLicenseNotic() {
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            CloudLicenseUtil.validateNoticeOnce((Context)ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

