/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.other.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.SSOToYZJFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;

public class SSOToYZJManagerAction
extends BaseAction {
    private static final String ADDRESS = "http://www.yunzhijia.com";

    public void getConfig() {
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        String sql = "SELECT top 1 * FROM T_BAS_SSOTOYZJCONFIG ORDER BY FCREATETIME DESC";
        JSONObject result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                String address = rs.getString("faddress");
                String type = rs.getString("ftype");
                String loginType = rs.getString("FLoginType");
                result = new JSONObject();
                result.put((Object)"address", (Object)address);
                result.put((Object)"type", (Object)type);
                result.put((Object)"loginType", (Object)loginType);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            LocalErr localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(false, localErr, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            LocalErr localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
        if (result == null) {
            result = new JSONObject();
            result.put((Object)"address", (Object)ADDRESS);
            result.put((Object)"type", (Object)0);
            result.put((Object)"loginType", (Object)0);
            result.put((Object)"secret", (Object)"");
            this.writeAjaxData(true, null, result);
        } else {
            this.writeAjaxData(true, null, result);
        }
    }

    public void saveConfig() {
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        int type = Integer.parseInt(this.getRequest().getParameter("type"));
        String address = this.getRequest().getParameter("address");
        String secret = this.getRequest().getParameter("secret");
        String loginType = this.getRequest().getParameter("loginType");
        String id = BOSUuid.create((String)"F4AF4F04").toString();
        try {
            String sqlSelect;
            IRowSet rs;
            if (StringUtils.isEmpty((String)secret) && (rs = DbUtil.executeQuery((Context)ctx, (String)(sqlSelect = "SELECT top 1 * FROM T_BAS_SSOTOYZJCONFIG ORDER BY FCREATETIME DESC"))).next()) {
                secret = rs.getString("fsecret");
            }
            String sql = "INSERT INTO T_BAS_SSOTOYZJCONFIG(FID,FTYPE,FADDRESS,FSECRET,FLOGINTYPE,FCREATETIME) VALUES(?,?,?,?,?,?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id, type, address, secret, loginType, new Timestamp(new Date().getTime())});
        }
        catch (BOSException e) {
            e.printStackTrace();
            LocalErr localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(false, localErr, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            LocalErr localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
        this.writeAjaxData(true, null, null);
    }

    public void getSSOLoginUrl() {
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            Map result = SSOToYZJFacadeFactory.getLocalInstance((Context)ctx).getSSOUrl(userInfo.getId().toString());
            if (Boolean.valueOf(result.get("success").toString()).booleanValue()) {
                this.writeAjaxData(true, null, result.get("ssoLoginUrl"));
            } else {
                this.writeAjaxData(false, null, result.get("errorMsg"));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            LocalErr localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(false, localErr, null);
        }
        catch (BOSException e) {
            e.printStackTrace();
            LocalErr localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(false, localErr, null);
        }
    }
}

