/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.page.action;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.PortletIns;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.json.Supports;
import com.kingdee.portal.biz.common.json.SyncSettingInfo;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.enums.PageModeEnum;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.dto.EditPageDTO;
import com.kingdee.portal.biz.module.page.dto.OutlookDTO;
import com.kingdee.portal.biz.module.page.dto.PageEditPermissionDto;
import com.kingdee.portal.biz.module.page.dto.PageModel;
import com.kingdee.portal.biz.module.page.dto.PermDto;
import com.kingdee.portal.biz.module.page.entity.PageCache;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.page.service.PageCacheService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.entity.PortletTheme;
import com.kingdee.portal.biz.module.portlet.service.CardCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.biz.module.portlet.service.PortletThemeService;
import com.kingdee.portal.biz.module.portlet.service.PortletTmplService;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class OnlineEditAction
extends BaseAction {
    private static String RESULT_EDIT_DEFAULT = "editDefault";
    private static String RESULT_OUTLOOK = "outlook";
    private EditPageDTO editPageDTO;
    private OutlookDTO outlookDTO;
    private PermDto permDto;
    private String defId = "";
    private OnlineEditPageService onlineEditPageService = (OnlineEditPageService)PortalServiceLocator.getBean((String)"onlineEditPageService");
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");
    private PortletThemeService portletThemeService = (PortletThemeService)PortalServiceLocator.getBean((String)"portletThemeService");
    private PermService permService = (PermService)PortalServiceLocator.getBean((String)"permService");
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
    private PageCacheService pageCacheService = (PageCacheService)PortalServiceLocator.getBean((String)"pageCacheService");
    private PortletService portletService = (PortletService)PortalServiceLocator.getBean((String)"portletService");
    private PortletTmplService portletTmplService = (PortletTmplService)PortalServiceLocator.getBean((String)"portletTmplService");
    private SettingService settingService = (SettingService)PortalServiceLocator.getBean((String)"settingService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    private CardCategoryService cardCategoryService = (CardCategoryService)PortalServiceLocator.getBean((String)"cardCategoryService");
    private PortalContext portalContext;
    private static String PREF_PREFIX = "pref_";

    public String editPage() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            PageModel pageModel = this.onlineEditPageService.buildPageModel(portalContext, this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
            this.putPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId(), pageModel);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String editPage4RolePortal() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        PageCache pageCache = null;
        try {
            PageModel pageModel = this.onlineEditPageService.buildPageModel4RolePortal(portalContext, this.editPageDTO.getPageId(), this.editPageDTO.getUserId(), this.editPageDTO.getRolePortalPageId(), "portal_template_user");
            this.putPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId(), pageModel);
            pageCache = this.pageCacheService.buildTempPageCache4PageModel(portalContext, pageModel);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, pageCache);
        return null;
    }

    public String editPage4Customer() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        PageCache pageCache = null;
        try {
            PageModel pageModel = this.onlineEditPageService.buildPageModel(portalContext, this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
            this.putPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId(), pageModel);
            pageCache = this.pageCacheService.buildTempPageCache4PageModel(portalContext, pageModel);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, pageCache);
        return null;
    }

    public String getNewPagePermission() {
        boolean success = true;
        LocalErr localErr = null;
        PageEditPermissionDto dto = null;
        try {
            dto = this.pageService.getNewPagePermission(this.getPortalContext(), this.editPageDTO.getPageId());
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, dto);
        return null;
    }

    public String finishEditPage() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            PageModel pageModel = this.getPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
            this.resloveGsPosition(pageModel, this.editPageDTO);
            SyncSettingInfo syncSettingInfo = new SyncSettingInfo();
            syncSettingInfo = this.editPageDTO.isCovePersonal() ? PageHelper.getCoverSyncSettingInfo() : PageHelper.getIncrementSyncSettingInfo();
            if ((NodeTypeEnum.NEW_PAGE.equals((Object)pageModel.getPage().getNodeType()) || NodeTypeEnum.PLAN.equals((Object)pageModel.getPage().getNodeType())) && (!pageModel.getPage().getUserId().equalsIgnoreCase(portalContext.getLoginUser().getId()) || "00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(portalContext.getLoginUser().getId()))) {
                if (StringUtils.isEmpty((String)this.editPageDTO.getSaveType()) || "customer".equalsIgnoreCase(this.editPageDTO.getSaveType()) && !pageModel.getPage().getUserId().equalsIgnoreCase(portalContext.getLoginUser().getId())) {
                    String pageId = this.onlineEditPageService.saveOnlineEditPage4Customer(portalContext, pageModel, syncSettingInfo);
                    result.put("pageId", pageId);
                } else {
                    this.onlineEditPageService.saveOnlineEditPage4Current(portalContext, pageModel, syncSettingInfo);
                }
            } else {
                this.onlineEditPageService.saveOnlineEditPage(portalContext, pageModel, syncSettingInfo);
            }
            this.removePageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    private void resloveGsPosition(PageModel pageModel, EditPageDTO editPageDTO2) {
        if (this.editPageDTO.getGsPosition() != null) {
            JSONArray gsPostionColl = JSONArray.fromObject((Object)this.editPageDTO.getGsPosition());
            HashMap<String, String> map = new HashMap<String, String>(gsPostionColl.size());
            for (int i = 0; i < gsPostionColl.size(); ++i) {
                JSONObject tmp = (JSONObject)gsPostionColl.get(i);
                String id = tmp.getString("id");
                String gsx = tmp.getString("gsx");
                String gsy = tmp.getString("gsy");
                String gsw = tmp.getString("gsw");
                String gsh = tmp.getString("gsh");
                map.put(id, "{x:" + gsx + ",y:" + gsy + ",width:" + gsw + ",height:" + gsh + "}");
            }
            for (PortletInstance portletInstance : pageModel.getPltInsList()) {
                portletInstance.setGsPosition((String)map.get(portletInstance.getId()));
            }
        }
    }

    public String cancelEditPage() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            this.removePageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String addPortlet() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        PortletIns portletIns = new PortletIns();
        try {
            PortletTheme portletTheme;
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletDefId = this.editPageDTO.getPortletDefId();
            int orderNum = this.editPageDTO.getOrderNum();
            PortletDefinition portletDefinition = this.portletDefinitionService.findPortletDefinitionById(portletDefId);
            Map pltInsMap = this.onlineEditPageService.buildNewPortletInstanceMap(portalContext, pageId, userId, portletDefinition, orderNum);
            PortletInstance portletInstance = (PortletInstance)pltInsMap.get("portletInstance");
            PortletRuntimePreferences portletRuntimePreferences = (PortletRuntimePreferences)pltInsMap.get("portletRuntimePreferences");
            PageModel pageModel = this.getPageModel4Cache(pageId, userId);
            if (pageModel != null && pageModel.getPltInsList() != null) {
                pageModel.getPltInsList().add(portletInstance);
            }
            if (pageModel != null && pageModel.getPltRuntimePreferencesList() != null) {
                pageModel.getPltRuntimePreferencesList().add(portletRuntimePreferences);
            }
            this.putPltInsPreferences4Session(portletRuntimePreferences);
            portletIns.setInsId(portletInstance.getId());
            portletIns.setDefId(portletDefinition.getId());
            portletIns.setAppName(portletDefinition.getAppName());
            portletIns.setArea(portletInstance.getArea());
            portletIns.setDisplayName(new DisplayName(portletDefinition.getDisplayName()));
            portletIns.setPortletName(portletDefinition.getPortletName());
            portletIns.setInner(portletInstance.getInner());
            portletIns.setPortletType(portletDefinition.getPortletType());
            Supports supports = (Supports)JSONUtil.getObject4Json((String)portletDefinition.getSupports(), Supports.class);
            portletIns.setPortletModes(supports.getPortletModes());
            portletIns.setDefGsPosition(portletDefinition.getGsPosition());
            if (!StringUtil.isEmpty((String)portletDefinition.getThemeId()) && (portletTheme = this.portletThemeService.findPortletThemeById(portletDefinition.getThemeId())) != null) {
                portletIns.setTheme(portletTheme.getCode());
            }
            List tmplList = PortalCache.getEnabledPortletTmplList();
            String pltTmplCode = PortletHelper.getPortletTmplCode((String)portletDefinition.getTmplId(), (List)tmplList);
            portletIns.setTmpl(pltTmplCode);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, portletIns);
        return null;
    }

    public String removePortlet() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletInsId = this.editPageDTO.getPortletInsId();
            PageModel pageModel = this.getPageModel4Cache(pageId, userId);
            this.deletePortletInstance4PageModel(pageModel, portletInsId);
            this.deletePortletRuntimePreferences4PageModel(pageModel, portletInsId);
            if (PageModeEnum.EDIT_VIEW.equals((Object)this.editPageDTO.getPageMode())) {
                this.saveOnlineEditPage4EditView(pageModel);
            }
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String changLayout() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            PageModel pageModel = this.getPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
            pageModel.getPagePersonalExt().setLayoutTmplId(this.editPageDTO.getLayoutTmplId());
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String savePortletOrder() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            Map<String, String> pltInsId2AreaMapping = this.buildPltInsId2AreaMapping(this.editPageDTO.getPortletOrderStr());
            Map<String, Integer> pltInsId2OrderMapping = this.buildPltInsId2OrderMapping(this.editPageDTO.getPortletOrderStr());
            PageModel pageModel = this.getPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
            this.updatePortletInsOrder(pageModel, pltInsId2AreaMapping, pltInsId2OrderMapping);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String planSwitch() {
        return "success";
    }

    public String planSaveConfirm() {
        return "success";
    }

    public String toSaveAsPlan() {
        String number = PageHelper.generatePageNumber();
        this.getRequest().getSession().setAttribute("number", (Object)number);
        return "success";
    }

    public String saveAsPlan() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String planNumber = this.getRequest().getParameter("planNumber");
            String planName = this.getRequest().getParameter("planName");
            String pageMode = this.getRequest().getParameter("pageMode");
            String canCustomer = this.getRequest().getParameter("isCanCustomer");
            PageModel pageModel = null;
            if (PageModeEnum.VIEW.toString().equalsIgnoreCase(pageMode)) {
                pageModel = this.onlineEditPageService.buildPageModel(portalContext, this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
            } else {
                pageModel = this.getPageModel4Cache(this.editPageDTO.getPageId(), this.editPageDTO.getUserId());
                this.resloveGsPosition(pageModel, this.editPageDTO);
            }
            pageModel.getPage().setPageNumber(planNumber);
            pageModel.getPage().setDisplayName(planName);
            this.permDto.setCanCustomer(Boolean.valueOf(canCustomer).booleanValue());
            SyncSettingInfo syncSettingInfo = new SyncSettingInfo();
            syncSettingInfo = this.editPageDTO.isCovePersonal() ? PageHelper.getCoverSyncSettingInfo() : PageHelper.getIncrementSyncSettingInfo();
            String pageId = this.onlineEditPageService.saveOnlineEditPageAsPlan(portalContext, pageModel, syncSettingInfo, this.permDto);
            result.put("pageId", pageId);
            this.permService.getPermLlist(this.getPortalContext(), true);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String editDefault() {
        PortalContext portalContext = this.getPortalContext();
        try {
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletInsId = this.editPageDTO.getPortletInsId();
            PageModeEnum pageMode = this.editPageDTO.getPageMode();
            Preferences preferences = null;
            preferences = PageModeEnum.EDIT.equals((Object)pageMode) || PageModeEnum.EDIT_VIEW.equals((Object)pageMode) ? this.getPltInsPreferences4Session(pageId, userId, portletInsId) : this.portletService.findPortletInsPreferences(portalContext, portletInsId);
            this.getRequest().setAttribute("portletInsId", (Object)portletInsId);
            this.getRequest().setAttribute("preferences", (Object)preferences);
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return RESULT_EDIT_DEFAULT;
    }

    public String saveInsPref() {
        boolean success = true;
        LocalErr localErr = null;
        HashMap result = new HashMap();
        try {
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletInsId = this.editPageDTO.getPortletInsId();
            PageModeEnum pageMode = this.editPageDTO.getPageMode();
            Preferences preferences = this.buildInsPreferences();
            if (PageModeEnum.EDIT.equals((Object)pageMode) || PageModeEnum.EDIT_VIEW.equals((Object)pageMode)) {
                this.savaInsPref4EditMode(pageId, userId, portletInsId, preferences);
            } else {
                this.savaInsPref4ViewMode(portletInsId, preferences);
            }
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String resetDefaultInsPref() {
        try {
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletInsId = this.editPageDTO.getPortletInsId();
            PageModeEnum pageMode = this.editPageDTO.getPageMode();
            this.editDefault();
            Preferences preferences = this.portletService.findDefaultPreferences4PltIns(this.getPortalContext(), portletInsId);
            this.getRequest().setAttribute("preferences", (Object)preferences);
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return RESULT_EDIT_DEFAULT;
    }

    public String outlook() {
        try {
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletInsId = this.editPageDTO.getPortletInsId();
            PageModeEnum pageMode = this.editPageDTO.getPageMode();
            String inner = "false";
            String portletName = "";
            if (this.outlookDTO != null) {
                inner = this.outlookDTO.getInner();
            }
            this.outlookDTO = PageModeEnum.EDIT.equals((Object)pageMode) || PageModeEnum.EDIT_VIEW.equals((Object)pageMode) ? this.outlook4EditMode(pageId, userId, portletInsId) : this.outlook4ViewMode(pageId, userId, portletInsId);
            this.outlookDTO.setInner(inner);
            if (!StringUtil.isEmpty((String)this.defId)) {
                PortletDefinition portletDefinition = this.portletDefinitionService.findPortletDefinitionById(this.defId);
                portletName = portletDefinition.getPortletName();
            }
            this.getRequest().setAttribute("portletName", (Object)portletName);
            this.getRequest().setAttribute("portletInsId", (Object)portletInsId);
            this.getRequest().setAttribute("outlookDTO", (Object)this.outlookDTO);
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return RESULT_OUTLOOK;
    }

    public String saveOutlookParam() {
        boolean success = true;
        LocalErr localErr = null;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            boolean updatePageCache = false;
            String pageId = this.editPageDTO.getPageId();
            String userId = this.editPageDTO.getUserId();
            String portletInsId = this.editPageDTO.getPortletInsId();
            PageModeEnum pageMode = this.editPageDTO.getPageMode();
            if (PageModeEnum.EDIT.equals((Object)pageMode) || PageModeEnum.EDIT_VIEW.equals((Object)pageMode)) {
                String filterName;
                if (this.outlookDTO != null && (filterName = FilterSpecialCharactersTool.cleanXSS((String)this.outlookDTO.getPortletIns().getDisplayName())) != null && !filterName.equalsIgnoreCase(this.outlookDTO.getPortletIns().getDisplayName())) {
                    throw new Exception("\u540d\u79f0\u4e2d\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
                }
                this.saveOutlookParam4EditMode(pageId, userId, portletInsId, this.outlookDTO);
                if (PageModeEnum.EDIT_VIEW.equals((Object)pageMode)) {
                    updatePageCache = true;
                }
            } else {
                this.saveOutlookParam4ViewMode(pageId, userId, portletInsId, this.outlookDTO);
                updatePageCache = true;
            }
            result.put("updatePageCache", updatePageCache);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String resetDefOutlookParam() {
        try {
            String portletInsId = this.editPageDTO.getPortletInsId();
            this.outlook();
            PortletInstance defaultPortletInstance = this.portletService.findPortletInstance4DefaultOutlook(this.getPortalContext(), portletInsId);
            PortletInstance currentPortletInstance = this.outlookDTO.getPortletIns();
            currentPortletInstance.setDisplayName(defaultPortletInstance.getDisplayName());
            currentPortletInstance.setThemeId((String)PortalCache.getPortalProfileMap().get("default_portlet_theme"));
            currentPortletInstance.setTmplId((String)PortalCache.getPortalProfileMap().get("default_portlet_tmpl"));
            currentPortletInstance.setHeight(defaultPortletInstance.getHeight());
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return RESULT_OUTLOOK;
    }

    public void dragInstance2Container() {
        boolean success = false;
        LocalErr localErr = null;
        String result = "\u6210\u529f\u5c06Portlet\u52a0\u5165\u5230\u5bb9\u5668\u4e2d\uff01";
        try {
            result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.ContainerPortlet.ContainerPortlet", "ContainerPortlet.result.draginsuc");
            String containerId = this.getRequest().getParameter("containerId");
            String dragInsId = this.getRequest().getParameter("dragInsId");
            String pageId = this.getRequest().getParameter("pageId");
            String userId = this.getRequest().getParameter("userId");
            Preferences preferences = this.getPltInsPreferences4Session(pageId, userId, containerId);
            if (preferences != null) {
                List<String> ctInstanceList = new ArrayList();
                boolean isExit = false;
                for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                    if (!((Preference)preferences.getPreferences().get(i)).getName().equals("ctInstanceList")) continue;
                    ctInstanceList = ((Preference)preferences.getPreferences().get(i)).getValues();
                    isExit = true;
                    int maxTab = 10;
                    try {
                        String container_max_tab = this.settingService.findPortalProfileByConfigItem("container_max_tab").getConfigValue();
                        if (container_max_tab != null) {
                            maxTab = Integer.parseInt(container_max_tab);
                        }
                    }
                    catch (PortalBizException container_max_tab) {
                        // empty catch block
                    }
                    if (ctInstanceList.size() >= maxTab) {
                        String max = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.ContainerPortlet.ContainerPortlet", "ContainerPortlet.result.max");
                        String countplt = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.ContainerPortlet.ContainerPortlet", "ContainerPortlet.result.countplt");
                        result = max + " " + maxTab + " " + countplt;
                        break;
                    }
                    boolean findIndex = false;
                    for (int j = 0; j < ctInstanceList.size(); ++j) {
                        if (!dragInsId.equals(ctInstanceList.get(j))) continue;
                        findIndex = true;
                        break;
                    }
                    if (findIndex) continue;
                    ctInstanceList.add(dragInsId);
                    ((Preference)preferences.getPreferences().get(i)).setValues(ctInstanceList);
                    success = true;
                }
                if (isExit < true) {
                    preferences.addPreference(new Preference("ctInstanceList", dragInsId));
                    success = true;
                }
            } else {
                preferences = new Preferences();
                preferences.addPreference(new Preference("ctInstanceList", dragInsId));
                success = true;
            }
            if (success) {
                PortletInstance instance = this.getPltIns4Session(pageId, userId, dragInsId);
                instance.setInner(Boolean.valueOf(true));
                this.savaInsPref4EditMode(pageId, userId, containerId, preferences);
            }
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void containerRemoveIns() {
        boolean success = false;
        LocalErr localErr = null;
        try {
            String containerId = this.getRequest().getParameter("containerId");
            String dragInsId = this.getRequest().getParameter("dragInsId");
            String pageId = this.getRequest().getParameter("pageId");
            String userId = this.getRequest().getParameter("userId");
            PageModel pageModel = this.getPageModel4Cache(pageId, userId);
            this.deletePortletInstance4PageModel(pageModel, dragInsId);
            this.deletePortletRuntimePreferences4PageModel(pageModel, dragInsId);
            Preferences preferences = this.getPltInsPreferences4Session(pageId, userId, containerId);
            if (preferences != null) {
                List ctInstanceList = new ArrayList();
                for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                    if (!((Preference)preferences.getPreferences().get(i)).getName().equals("ctInstanceList")) continue;
                    ctInstanceList = ((Preference)preferences.getPreferences().get(i)).getValues();
                    int delIndex = 0;
                    for (int j = 0; j < ctInstanceList.size(); ++j) {
                        if (!dragInsId.equals(ctInstanceList.get(j))) continue;
                        delIndex = j;
                    }
                    ctInstanceList.remove(delIndex);
                    ((Preference)preferences.getPreferences().get(i)).setValues(ctInstanceList);
                }
            }
            this.savaInsPref4EditMode(pageId, userId, containerId, preferences);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
    }

    public void containerDragOutIns() {
        boolean success = false;
        LocalErr localErr = null;
        try {
            String containerId = this.getRequest().getParameter("containerId");
            String dragInsId = this.getRequest().getParameter("dragInsId");
            String pageId = this.getRequest().getParameter("pageId");
            String userId = this.getRequest().getParameter("userId");
            PortletInstance instance = this.getPltIns4Session(pageId, userId, dragInsId);
            instance.setInner(Boolean.valueOf(false));
            Preferences preferences = this.getPltInsPreferences4Session(pageId, userId, containerId);
            if (preferences != null) {
                List ctInstanceList = new ArrayList();
                for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                    if (!((Preference)preferences.getPreferences().get(i)).getName().equals("ctInstanceList")) continue;
                    ctInstanceList = ((Preference)preferences.getPreferences().get(i)).getValues();
                    int delIndex = 0;
                    for (int j = 0; j < ctInstanceList.size(); ++j) {
                        if (!dragInsId.equals(ctInstanceList.get(j))) continue;
                        delIndex = j;
                    }
                    ctInstanceList.remove(delIndex);
                    ((Preference)preferences.getPreferences().get(i)).setValues(ctInstanceList);
                }
            }
            this.savaInsPref4EditMode(pageId, userId, containerId, preferences);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
    }

    public void containerSetInsOrder() {
        boolean success = false;
        LocalErr localErr = null;
        try {
            String containerId = this.getRequest().getParameter("containerId");
            String insIdList = this.getRequest().getParameter("insIdList");
            String pageId = this.getRequest().getParameter("pageId");
            String userId = this.getRequest().getParameter("userId");
            Preferences preferences = this.getPltInsPreferences4Session(pageId, userId, containerId);
            if (preferences != null) {
                ArrayList<String> ctInstanceList = new ArrayList<String>();
                String[] idList = insIdList.split(",");
                for (int j = 0; j < idList.length; ++j) {
                    ctInstanceList.add(idList[j]);
                }
                for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                    if (!((Preference)preferences.getPreferences().get(i)).getName().equals("ctInstanceList")) continue;
                    ((Preference)preferences.getPreferences().get(i)).setValues(ctInstanceList);
                }
            }
            this.savaInsPref4EditMode(pageId, userId, containerId, preferences);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
    }

    public String findPortalTmplDataList() {
        boolean success = true;
        LocalErr localErr = null;
        Map result = null;
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            String spaceId = "e7e04dcc-415a-406a-bd49-3fb540778118";
            int level = 10;
            result = this.pageService.findBizNavWithLevel(portalContext, spaceId, level, this.getPermMap());
        }
        catch (PortalBizException ex) {
            success = false;
            localErr = this.handleErr((Exception)((Object)ex));
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String findCardList() {
        return "success";
    }

    public String findCardCategoryList() {
        LocalErr localErr = null;
        List list = null;
        try {
            list = this.cardCategoryService.findAllCardCategory();
        }
        catch (PortalBizException e) {
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(true, null, list);
        return null;
    }

    private void resetDefOutlookParam4EditMode(String pageId, String userId, String portletInsId) throws PortalBizException {
        PageModel pageModel = this.getPageModel4Cache(pageId, userId);
        List pltInsList = pageModel.getPltInsList();
        if (pltInsList != null && !pltInsList.isEmpty()) {
            for (PortletInstance tempPltIns : pltInsList) {
                if (!tempPltIns.getId().equals(portletInsId)) continue;
                this.portletService.resetDefaultOutlook4EditMode(this.getPortalContext(), tempPltIns);
                break;
            }
        }
    }

    private void resetDefOutlookParam4ViewMode(String pageId, String userId, String portletInsId) throws PortalBizException {
        this.portletService.resetDefaultOutlook4ViewMode(this.getPortalContext(), portletInsId);
    }

    private void saveOutlookParam4EditMode(String pageId, String userId, String portletInsId, OutlookDTO outlookDTO) throws PortalBizException {
        PageModel pageModel = this.getPageModel4Cache(pageId, userId);
        List pltInsList = pageModel.getPltInsList();
        if (pltInsList != null && !pltInsList.isEmpty()) {
            for (PortletInstance pltIns : pltInsList) {
                if (!pltIns.getId().equals(portletInsId)) continue;
                pltIns.setThemeId(outlookDTO.getPortletIns().getThemeId());
                pltIns.setTmplId(outlookDTO.getPortletIns().getTmplId());
                pltIns.setDisplayName(outlookDTO.getPortletIns().getDisplayName());
                pltIns.setHeight(outlookDTO.getPortletIns().getHeight());
                break;
            }
        }
        if (PageModeEnum.EDIT_VIEW.equals((Object)this.editPageDTO.getPageMode())) {
            this.saveOnlineEditPage4EditView(pageModel);
        }
    }

    private void saveOutlookParam4ViewMode(String pageId, String userId, String pltInsId, OutlookDTO outlookDTO) throws PortalBizException {
        PortletInstance pltIns = outlookDTO.getPortletIns();
        pltIns.setId(pltInsId);
        pltIns.setUserId(userId);
        this.portletService.updatePltInsOutlook(this.getPortalContext(), pltIns);
    }

    private OutlookDTO buildBaseOutlookDTO() throws PortalBizException {
        OutlookDTO outlookDTO = new OutlookDTO();
        List portletThemeList = this.portletThemeService.findPortletThemeList4Enable();
        List portletTmplList = this.portletTmplService.findPortletTmplList4Enable();
        outlookDTO.setPortletThemeList(portletThemeList);
        outlookDTO.setPortletTmplList(portletTmplList);
        return outlookDTO;
    }

    private OutlookDTO outlook4ViewMode(String pageId, String userId, String pltInsId) throws PortalBizException {
        OutlookDTO outlookDTO = this.buildBaseOutlookDTO();
        PortletInstance portletIns = this.portletService.findPortletInsById(this.getPortalContext(), pltInsId);
        outlookDTO.setPortletIns(portletIns);
        this.defId = portletIns.getDefinitionId();
        return outlookDTO;
    }

    private OutlookDTO outlook4EditMode(String pageId, String userId, String portletInsId) throws PortalBizException {
        OutlookDTO outlookDTO = this.buildBaseOutlookDTO();
        PortletInstance portletIns = this.getPltIns4Session(pageId, userId, portletInsId);
        outlookDTO.setPortletIns(portletIns);
        this.defId = portletIns.getDefinitionId();
        return outlookDTO;
    }

    private PortletInstance getPltIns4Session(String pageId, String userId, String insId) {
        PageModel pageModel = this.getPageModel4Cache(pageId, userId);
        List portletInsList = pageModel.getPltInsList();
        if (portletInsList != null && !portletInsList.isEmpty()) {
            for (PortletInstance pltIns : portletInsList) {
                if (!pltIns.getId().equals(insId)) continue;
                return pltIns;
            }
        }
        return null;
    }

    private Preferences resetInsPref4EditMode(String pageId, String userId, String portletInsId) throws PortalBizException {
        Preferences preferences = this.portletService.findPortletInsPreferences(this.getPortalContext(), portletInsId);
        this.savaInsPref4EditMode(pageId, userId, portletInsId, preferences);
        return preferences;
    }

    private void resetInsPref4ViewMode(String pageId, String userId, String portletInsId) throws PortalBizException {
        this.portletService.resetDefaultPreferences4PltIns(this.getPortalContext(), portletInsId);
    }

    private void savaInsPref4EditMode(String pageId, String userId, String portletInsId, Preferences preferences) throws PortalBizException {
        PageModel pageModel = this.getPageModel4Cache(pageId, userId);
        List insPrefList = pageModel.getPltRuntimePreferencesList();
        if (insPrefList != null && !insPrefList.isEmpty()) {
            for (PortletRuntimePreferences pref : insPrefList) {
                if (!pref.getInsId().equals(portletInsId)) continue;
                pref.setPreferences(preferences.toString());
                break;
            }
        }
        if (PageModeEnum.EDIT_VIEW.equals((Object)this.editPageDTO.getPageMode())) {
            this.saveOnlineEditPage4EditView(pageModel);
        }
    }

    private void savaInsPref4ViewMode(String pltInsId, Preferences preferences) throws PortalBizException {
        this.portletService.updatePortletPreferences(this.getPortalContext(), pltInsId, preferences);
    }

    private Preferences buildInsPreferences() {
        Preferences preferences = new Preferences();
        Map paramMap = this.getRequest().getParameterMap();
        for (Object key : paramMap.keySet()) {
            if (!key.toString().startsWith(PREF_PREFIX)) continue;
            Preference preference = new Preference();
            String itemName = key.toString().substring(PREF_PREFIX.length());
            preference.setName(itemName);
            Object value = paramMap.get(key);
            if (value instanceof String[]) {
                for (String tempValue : (String[])value) {
                    preference.addValue(tempValue);
                }
            } else {
                preference.addValue(value.toString());
            }
            preferences.addPreference(preference);
        }
        return preferences;
    }

    private Map<String, String> buildPltInsId2AreaMapping(String portletOrderStr) {
        String[] areaArray;
        HashMap<String, String> areaMap = new HashMap<String, String>();
        for (String areaStr : areaArray = portletOrderStr.split("\\|")) {
            String[] tempAreaArray;
            if (StringUtil.isEmpty((String)areaStr) || (tempAreaArray = areaStr.split("\\$")) == null || tempAreaArray.length != 2) continue;
            String areaId = tempAreaArray[0];
            String[] insIdArray = tempAreaArray[1].split("_");
            if (insIdArray == null) continue;
            for (String insId : insIdArray) {
                areaMap.put(insId, areaId);
            }
        }
        return areaMap;
    }

    private Map<String, Integer> buildPltInsId2OrderMapping(String portletOrderStr) {
        String[] areaArray;
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        for (String areaStr : areaArray = portletOrderStr.split("\\|")) {
            String[] insIdArray;
            String[] tempAreaArray;
            if (StringUtil.isEmpty((String)areaStr) || (tempAreaArray = areaStr.split("\\$")) == null || tempAreaArray.length != 2 || (insIdArray = tempAreaArray[1].split("_")) == null) continue;
            int i = 1;
            for (String insId : insIdArray) {
                orderMap.put(insId, i++);
            }
        }
        return orderMap;
    }

    private void updatePortletInsOrder(PageModel pageModel, Map<String, String> pltInsId2AreaMapping, Map<String, Integer> pltInsId2OrderMapping) throws PortalBizException {
        if (pageModel != null && pageModel.getPltInsList() != null) {
            for (int i = 0; i < pageModel.getPltInsList().size(); ++i) {
                PortletInstance tempIns = (PortletInstance)pageModel.getPltInsList().get(i);
                String newArea = pltInsId2AreaMapping.get(tempIns.getId());
                if (StringUtil.isEmpty((String)newArea)) continue;
                tempIns.setArea(newArea);
                tempIns.setOrderNum(pltInsId2OrderMapping.get(tempIns.getId()));
            }
        }
        if (PageModeEnum.EDIT_VIEW.equals((Object)this.editPageDTO.getPageMode())) {
            this.saveOnlineEditPage4EditView(pageModel);
        }
    }

    private void saveOnlineEditPage4EditView(PageModel pageModel) throws PortalBizException {
        this.onlineEditPageService.saveOnlineEditPage(this.getPortalContext(), pageModel, null);
    }

    private void deletePortletInstance4PageModel(PageModel pageModel, String portletInsId) {
        if (pageModel != null && pageModel.getPltInsList() != null) {
            int insIndex = -1;
            for (int i = 0; i < pageModel.getPltInsList().size(); ++i) {
                PortletInstance tempIns = (PortletInstance)pageModel.getPltInsList().get(i);
                if (!portletInsId.equals(tempIns.getId())) continue;
                insIndex = i;
                pageModel.getDelPltInsIdList().add(portletInsId);
                break;
            }
            if (insIndex != -1) {
                pageModel.getPltInsList().remove(insIndex);
            }
        }
    }

    private void deletePortletRuntimePreferences4PageModel(PageModel pageModel, String portletInsId) {
        if (pageModel != null && pageModel.getPltRuntimePreferencesList() != null) {
            int insPreferIndex = -1;
            for (int i = 0; i < pageModel.getPltRuntimePreferencesList().size(); ++i) {
                PortletRuntimePreferences tempInsRuntimePref = (PortletRuntimePreferences)pageModel.getPltRuntimePreferencesList().get(i);
                if (!portletInsId.equals(tempInsRuntimePref.getInsId())) continue;
                insPreferIndex = i;
                pageModel.getDelPltRuntimePreferencesIdList().add(tempInsRuntimePref.getId());
                this.deletePltInsPreferences4Session(tempInsRuntimePref.getInsId());
                break;
            }
            if (insPreferIndex != -1) {
                pageModel.getPltRuntimePreferencesList().remove(insPreferIndex);
            }
        }
    }

    private void putPageModel4Cache(String pageId, String userId, PageModel pageModel) {
        HashMap<String, PageModel> pageModelMap = (HashMap<String, PageModel>)this.getRequest().getSession().getAttribute("temp_page_edit_model");
        if (pageModelMap == null) {
            pageModelMap = new HashMap<String, PageModel>();
            this.getRequest().getSession().setAttribute("temp_page_edit_model", pageModelMap);
        }
        String pageMdoelKey = pageId + "_" + userId;
        pageModelMap.put(pageMdoelKey, pageModel);
    }

    private PageModel getPageModel4Cache(String pageId, String userId) {
        Map pageModelMap = (Map)this.getRequest().getSession().getAttribute("temp_page_edit_model");
        String pageMdoelKey = pageId + "_" + userId;
        return (PageModel)pageModelMap.get(pageMdoelKey);
    }

    private void removePageModel4Cache(String pageId, String userId) {
        Map pageModelMap = (Map)this.getRequest().getSession().getAttribute("temp_page_edit_model");
        PageModel pageModel = this.getPageModel4Cache(pageId, userId);
        String pageModelKey = pageId + "_" + userId;
        pageModelMap.remove(pageModelKey);
    }

    private void setPltInsPreferences4Session(String insId, Preferences preferences) {
        Map<String, Preferences> preferenceMap = this.getPltInsPreferenceMap();
        preferenceMap.put(insId, preferences);
    }

    private Preferences getPltInsPreferences4Session(String pageId, String userId, String portletInsId) {
        Preferences preferences = new Preferences();
        PageModel pageModel = this.getPageModel4Cache(pageId, userId);
        List insPrefList = pageModel.getPltRuntimePreferencesList();
        if (insPrefList != null && !insPrefList.isEmpty()) {
            for (PortletRuntimePreferences pref : insPrefList) {
                if (!pref.getInsId().equals(portletInsId)) continue;
                preferences = PortletHelper.convPreferences((String)pref.getPreferences());
                break;
            }
        }
        return preferences;
    }

    private void putPltInsPreferences4Session(PortletRuntimePreferences portletRuntimePreferences) {
        String insId = portletRuntimePreferences.getInsId();
        Preferences preferences = null;
        String preferencesStr = portletRuntimePreferences.getPreferences();
        if (!StringUtil.isEmpty((String)preferencesStr)) {
            preferences = PortletHelper.convPreferences((String)preferencesStr);
            this.setPltInsPreferences4Session(insId, preferences);
        }
    }

    private void deletePltInsPreferences4Session(String insId) {
        Map<String, Preferences> preferenceMap = this.getPltInsPreferenceMap();
        preferenceMap.remove(insId);
    }

    private Map<String, Preferences> getPltInsPreferenceMap() {
        HashMap preferenceMap = (HashMap)this.getRequest().getSession().getAttribute("temp_plt_runtime_map");
        if (preferenceMap == null) {
            preferenceMap = new HashMap();
            this.getRequest().getSession().setAttribute("temp_plt_runtime_map", preferenceMap);
        }
        return preferenceMap;
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public EditPageDTO getEditPageDTO() {
        return this.editPageDTO;
    }

    public void setEditPageDTO(EditPageDTO editPageDTO) {
        this.editPageDTO = editPageDTO;
    }

    public OutlookDTO getOutlookDTO() {
        return this.outlookDTO;
    }

    public void setOutlookDTO(OutlookDTO outlookDTO) {
        this.outlookDTO = outlookDTO;
    }

    public PermDto getPermDto() {
        return this.permDto;
    }

    public void setPermDto(PermDto permDto) {
        this.permDto = permDto;
    }
}

