/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.util.AttachmentUtils;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ConvertDownloadServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String attachId = request.getParameter("attId");
        String dataCenter = request.getParameter("dc");
        String locale = request.getParameter("lc");
        logger.error("=======downservlet attachId:" + attachId + " dataCenter:" + dataCenter + " locale:" + locale);
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)attachId) && !StringUtils.isEmpty((String)dataCenter)) {
            if (StringUtils.isEmpty((String)locale)) {
                locale = "l2";
            }
            Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, null);
            logger.error("=======downservlet ctx:" + ctx.getAIS() + " username:" + ctx.getUserName());
            attachId = AttachmentUtils.init().checkID(attachId);
            AttachmentInfo info = null;
            try {
                BOSUuid.read((String)attachId);
                info = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachId));
                if (info == null) {
                    info = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo("where attachFID = '" + attachId + "'");
                }
            }
            catch (Exception e) {
                logger.error("getRemote attachment info throws exception; id is :" + attachId, (Throwable)e);
                errorInfo = "\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25/download attachment fail";
            }
            String nameStr = "";
            if (info != null) {
                nameStr = info.getName() + "." + info.getSimpleName();
                if (info.getFile() == null) {
                    try {
                        byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(info.getId().toString());
                        info.setFile(files);
                    }
                    catch (Exception e) {
                        logger.error("AttachmentManagerFacade getRemote attachment info throws exception; id is :" + attachId, (Throwable)e);
                        errorInfo = "\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25/download attachment fail";
                    }
                }
            }
            ServletOutputStream output = null;
            try {
                output = response.getOutputStream();
                if (info != null && info.getFile() == null) {
                    logger.error("attachment'file is null :" + nameStr + " id is :" + attachId);
                    errorInfo = "\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25/download attachment fail";
                }
                output.write(info.getFile());
            }
            catch (Exception e) {
                logger.error("download attachment end error: id is :" + attachId, (Throwable)e);
                errorInfo = "\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25/download attachment fail";
            }
            finally {
                try {
                    if (!"".equals(errorInfo)) {
                        output.write(errorInfo.getBytes());
                    }
                    output.flush();
                    output.close();
                }
                catch (Exception ex) {
                    logger.error("download attachment close output error:", (Throwable)ex);
                }
            }
        } else {
            ServletOutputStream output = null;
            output = response.getOutputStream();
            logger.error("view attachment argument is null attachId:" + attachId + " datacenter is :" + dataCenter);
            errorInfo = "\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25/download attachment fail";
            output.write(errorInfo.getBytes());
            try {
                output.flush();
                output.close();
            }
            catch (Exception ex) {
                logger.error("download attachment close output error:", (Throwable)ex);
            }
        }
    }
}

