/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.portal.biz.common.exception.handle.ErrHandle;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataCenterServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        ArrayList list = new ArrayList();
        try {
            dcList = dcRegister.getDCList();
            for (DCInfo dc : dcList) {
                HashMap<String, Object> dcMap = new HashMap<String, Object>();
                dcMap.put("id", dc.getNumber());
                dcMap.put("dbName", dc.getDBName());
                dcMap.put("dbType", dc.getDBType());
                dcMap.put("language", dc.tb);
                dcMap.put("version", dc.getVersion());
                dcMap.put("solutionName", dc.getSolutionName());
                list.add(dcMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(resp, false, ErrHandle.getLocalErr((Exception)e, null), null);
            return;
        }
        this.writeAjaxData(resp, true, null, list);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void writeAjaxData(HttpServletResponse response, boolean success, LocalErr errinfo, Object result) {
        try {
            Object tempResult = result == null ? "" : result;
            HashMap<String, Object> ajaxData = new HashMap<String, Object>();
            ajaxData.put("success", success);
            ajaxData.put("errinfo", errinfo);
            ajaxData.put("result", tempResult);
            String jsonObj = JSONUtil.getJson4Object(ajaxData);
            String _contentType = "text/json;charset=utf-8";
            byte[] _result = jsonObj.toString().getBytes("utf-8");
            DataCenterServlet.writeResponse(response, _contentType, _result);
        }
        catch (Exception e) {
            System.out.println("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}" + e.getMessage());
        }
    }

    private static void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setHeader("cache-control", "no-cache");
            response.setHeader("charset", "utf-8");
            if (!StringUtils.isEmpty((String)contentType)) {
                response.setContentType(contentType);
            }
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            System.out.println("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}" + ex.getMessage());
        }
    }
}

