/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.uiframe.MyComFunctionFacadeFactory;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.handle.ErrHandle;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.portal.biz.module.personal.entity.PersonalProfile;
import com.kingdee.portal.biz.module.personal.service.PersonalProfileService;
import com.kingdee.portal.biz.module.pub.common.enums.FileTypeEnum;
import com.kingdee.portal.biz.module.pub.common.util.PubConstant;
import com.kingdee.portal.biz.module.pub.entity.PubFile;
import com.kingdee.portal.biz.module.pub.service.PubFileService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.FileUtil;
import com.kingdee.portal.common.util.HttpUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ImgServlet.class);
    private ServletContext context = null;
    private static final String DEFAULT_USER_LOGO = "/res/img/global/icons/default-user-logo.png";
    private static final String DEFAULT_SHR_USER_LOGO = "/res/img/global/icons/default-shr-user-logo.png";
    private static final String DEFAULT_COMMON_IMG = "/res/img/global/icons/default-common-img.png";
    private static final String DEFAULT_VIEWTMPL = "/res/img/global/icons/default-viewtmpl.png";
    private PubFileService pubFileService = (PubFileService)PortalServiceLocator.getBean((String)"pubFileService");
    private PersonalProfileService personalProfileService = (PersonalProfileService)PortalServiceLocator.getBean((String)"personalProfileService");
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = request.getParameter("type");
        if (FileTypeEnum.USER_LOGO.toString().equalsIgnoreCase(type)) {
            this.findUserLogo(request, response);
        } else if (FileTypeEnum.COMMON_IMG.toString().equalsIgnoreCase(type)) {
            this.findCommonImg(request, response);
        } else if (FileTypeEnum.VIEWTMPL_PIC.toString().equalsIgnoreCase(type)) {
            this.findViewTmplPic(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void findCommonImg(HttpServletRequest request, HttpServletResponse response) {
        String id = StringUtil.convNull((String)request.getParameter("id"));
        String appName = StringUtil.convNull((String)request.getParameter("appName"));
        String parameterStr = id + appName;
        if (!FilterSpecialCharactersTool.checkParamsValid((String)parameterStr)) {
            try {
                request.getRequestDispatcher("/pages/common/unvalibaleUrl.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                logger.error(e.getMessage());
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            return;
        }
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        try {
            if (this.isSysIcon(id, appName)) {
                String imgPath = Constant.SYSTEM_ROOT_PATH + PubConstant.SYS_ICONS_PATH + id;
                this.response4FileImg(response, portalContext, imgPath, DEFAULT_COMMON_IMG);
                return;
            }
            if (this.isQuickIcon(id, appName)) {
                String imgPath = Constant.SYSTEM_ROOT_PATH + PubConstant.QUICK_ICONS_PATH + id;
                this.response4FileImg(response, portalContext, imgPath, DEFAULT_COMMON_IMG);
                return;
            }
            if (this.isPageIcon(id, appName)) {
                this.response4DatabaseImg(response, portalContext, id, DEFAULT_COMMON_IMG);
                return;
            }
            if (this.isPortletIcon(id, appName)) {
                if (this.isUUID(id)) {
                    this.response4DatabaseImg(response, portalContext, id, DEFAULT_COMMON_IMG);
                } else {
                    String imgPath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + appName + ".war" + id;
                    File imgFile = new File(imgPath);
                    if (imgFile == null || !imgFile.exists() || !imgFile.isFile()) {
                        imgPath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + "plt_portal.war" + id;
                    }
                    this.response4FileImg(response, portalContext, imgPath, DEFAULT_COMMON_IMG);
                    return;
                }
            }
            this.response4FileImg(response, portalContext, null, DEFAULT_COMMON_IMG);
        }
        catch (Exception ex) {
            LocalErr err = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            logger.error(err.toString());
            this.response4FileImg(response, portalContext, null, DEFAULT_COMMON_IMG);
        }
    }

    private boolean isUUID(String id) {
        String uid = StringUtil.convNull((String)id);
        return uid.length() == 36 && uid.split("-").length == 5;
    }

    private boolean isSysIcon(String id, String appName) {
        String icon = StringUtil.convNull((String)id);
        return icon.startsWith("sys_");
    }

    private boolean isPageIcon(String id, String appName) {
        return StringUtil.convNull((String)appName).length() <= 0;
    }

    private boolean isPortletIcon(String id, String appName) {
        return StringUtil.convNull((String)appName).length() > 0;
    }

    private boolean isQuickIcon(String id, String appName) {
        String icon = StringUtil.convNull((String)id);
        return icon.startsWith("app_");
    }

    private void response4DatabaseImg(HttpServletResponse response, PortalContext portalContext, String id, String defaultImg) {
        try {
            PubFile pubFile = this.pubFileService.findPubFileById(portalContext, id);
            this.response4DatabaseImg(response, portalContext, pubFile, defaultImg);
        }
        catch (Exception ex) {
            LocalErr err = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            logger.error(err.toString());
            ex.printStackTrace();
        }
    }

    private void response4DatabaseImg(HttpServletResponse response, PortalContext portalContext, PubFile pubFile, String defaultImg) {
        try {
            if (pubFile != null && pubFile.getContent() != null) {
                this.writeResponse(response, pubFile.getContentType(), pubFile.getContent());
            } else {
                this.response4DefaultImg(response, defaultImg);
            }
        }
        catch (Exception ex) {
            LocalErr err = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            logger.error(err.toString());
            ex.printStackTrace();
        }
    }

    private void response4FileImg(HttpServletResponse response, PortalContext portalContext, String imgPath, String defaultImg) {
        if (StringUtil.isEmpty((String)imgPath)) {
            this.response4DefaultImg(response, defaultImg);
            return;
        }
        File imgFile = new File(imgPath);
        if (imgFile == null || !imgFile.exists() || !imgFile.isFile()) {
            logger.error("\u4e0d\u80fd\u627e\u5230\u6307\u5b9a\u56fe\u7247\uff1a" + imgPath);
            this.response4DefaultImg(response, defaultImg);
        } else {
            byte[] imgContent = FileUtil.getByteArrayData((String)imgPath);
            if (imgContent != null) {
                this.writeResponse(response, "image/gif", imgContent);
            }
        }
    }

    private void response4DefaultImg(HttpServletResponse response, String defaultImg) {
        byte[] imgContent = this.getDefaultImgContent(defaultImg);
        if (imgContent != null) {
            this.writeResponse(response, "image/gif", imgContent);
        } else {
            logger.error("\u9ed8\u8ba4\u56fe\u7247\u4e22\u5931\uff1a" + defaultImg);
        }
    }

    private void findUserLogo(HttpServletRequest request, HttpServletResponse response) {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (this.easService.isStartSHR(ctx)) {
                byte[] personPhoto = MyComFunctionFacadeFactory.getLocalInstance((Context)ctx).getPersonPhoto(portalContext.getLoginUser().getId());
                if (personPhoto != null) {
                    this.writeResponse(response, "image/gif", personPhoto);
                } else {
                    this.response4DefaultImg(response, DEFAULT_SHR_USER_LOGO);
                }
                return;
            }
            if (this.hasFromLogonPage(request) && !StringUtil.isEmpty((String)(portalContext = this.buildTempPortalContext4LoginPage(request)).getLoginUser().getCode())) {
                PubFile pubFile = this.pubFileService.findUserLogoByUserCode(portalContext, portalContext.getLoginUser().getCode());
                this.response4DatabaseImg(response, portalContext, pubFile, DEFAULT_USER_LOGO);
                return;
            }
            PersonalProfile personalProfile = this.personalProfileService.findLoginUserLogo(portalContext);
            String id = personalProfile == null ? "" : personalProfile.getConfigValue();
            this.response4DatabaseImg(response, portalContext, id, DEFAULT_USER_LOGO);
        }
        catch (Exception ex) {
            LocalErr err = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            logger.error(err.toString());
            this.response4DefaultImg(response, DEFAULT_USER_LOGO);
        }
    }

    private boolean hasFromLogonPage(HttpServletRequest request) {
        boolean fromLogonPage = false;
        if (request.getRequestURI().indexOf("uncheck") > 0) {
            fromLogonPage = true;
        }
        return fromLogonPage;
    }

    private PortalContext buildTempPortalContext4LoginPage(HttpServletRequest request) throws Exception {
        String userId = StringUtil.convNull((String)request.getParameter("userId"));
        if (StringUtil.isEmpty((String)userId)) {
            userId = HttpUtil.getCookieValue((HttpServletRequest)request, (String)"EasPortalUserId", (String)"");
        }
        userId = URLDecoder.decode(userId, "UTF-8");
        String userCode = StringUtil.convNull((String)request.getParameter("userName"));
        if (StringUtil.isEmpty((String)userCode)) {
            userCode = HttpUtil.getCookieValue((HttpServletRequest)request, (String)"EasPortalUsername", (String)"");
        }
        userCode = URLDecoder.decode(userCode, "UTF-8");
        String dataCenter = StringUtil.convNull((String)request.getParameter("dataCenter"));
        if (StringUtil.isEmpty((String)dataCenter)) {
            dataCenter = HttpUtil.getCookieValue((HttpServletRequest)request, (String)"EasPortalDataCenterCode", (String)"");
        }
        if (StringUtil.isEmpty((String)userId) && StringUtil.isEmpty((String)userCode) || StringUtil.isEmpty((String)dataCenter)) {
            throw new Exception("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        User user = new User();
        user.setId(userId);
        user.setCode(userCode);
        PortalContext portalContext = new PortalContext();
        portalContext.setLoginUser(user);
        portalContext.setLocale(Locale.CHINA);
        DSObserver.putDSName((String)dataCenter);
        portalContext.getMetaInfo().put("current_data_center", dataCenter);
        return portalContext;
    }

    private void findViewTmplPic(HttpServletRequest request, HttpServletResponse response) {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        String id = StringUtil.convNull((String)request.getParameter("id"));
        if (!FilterSpecialCharactersTool.checkParamsValid((String)id)) {
            try {
                request.getRequestDispatcher("/pages/common/unvalibaleUrl.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                logger.error(e.getMessage());
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            return;
        }
        String locale = portalContext.getLocale().toString();
        if (locale.equals("en")) {
            String fileName = id.substring(0, id.lastIndexOf("."));
            String fileType = id.substring(id.lastIndexOf("."), id.length());
            id = fileName + "_en" + fileType;
        }
        try {
            String imgPath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + "plt_portal.war" + PubConstant.VIEWTMPL_PIC_PATH + id;
            this.response4FileImg(response, portalContext, imgPath, DEFAULT_VIEWTMPL);
        }
        catch (Exception ex) {
            LocalErr err = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            logger.error(err.toString());
            this.response4FileImg(response, portalContext, null, DEFAULT_VIEWTMPL);
        }
    }

    private byte[] getDefaultImgContent(String imgPath) {
        return FileUtil.getByteArrayData((InputStream)this.context.getResourceAsStream(imgPath));
    }

    private void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setContentType(contentType);
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }
}

