/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.setting.entity.LogoSetting;
import com.kingdee.portal.biz.module.setting.service.LogoSettingService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.FileUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoImgServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(LogoImgServlet.class);
    private ServletContext context = null;
    private LogoSettingService logoSettingService = (LogoSettingService)PortalServiceLocator.getBean((String)"logoSettingService");

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = StringUtil.convNull((String)request.getParameter("type"));
        String dataCenter = request.getParameter("dataCenter");
        String language = request.getParameter("language");
        String insId = request.getParameter("insId");
        StringBuilder builder = new StringBuilder();
        String parameterStr = builder.append(type).append(dataCenter).append(language).append(insId).toString();
        if (!FilterSpecialCharactersTool.checkParamsValid((String)parameterStr)) {
            try {
                request.getRequestDispatcher("/pages/common/unvalibaleUrl.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                logger.error(e.getMessage());
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            return;
        }
        boolean isWriteSession = this.writeSession(request, response, insId, language, type);
        if (isWriteSession) {
            return;
        }
        LogoSetting logoSetting = null;
        try {
            logoSetting = this.logoSettingService.getLogoSettingByLogoName(type, dataCenter, language);
        }
        catch (Exception e) {
            logger.error("getLogoSettingByLogoName error!", (Throwable)e);
        }
        if (logoSetting == null) {
            this.writeResponse(response, "image/png", this.getFilePrePath(type) + this.getDefaultPicFileName(type, language));
            return;
        }
        File logoFile = new File(this.getFilePrePath(type), type + "_logo_" + dataCenter + "_" + language + ".png");
        if (logoFile.exists()) {
            long fileLastModified = logoFile.lastModified();
            if (logoSetting.getLastUpdateTime().getTime() > fileLastModified) {
                this.writeFile(this.getFilePrePath(type) + type + "_logo_" + dataCenter + "_" + language + ".png", logoSetting.getLogoContent());
            }
        } else {
            this.writeFile(this.getFilePrePath(type) + type + "_logo_" + dataCenter + "_" + language + ".png", logoSetting.getLogoContent());
        }
        this.writeResponse(response, "image/png", logoSetting.getLogoContent());
    }

    private boolean writeSession(HttpServletRequest request, HttpServletResponse response, String insId, String language, String type) {
        String logoPath;
        HashMap logoMap;
        HashMap logoMaps = (HashMap)request.getSession().getAttribute("logoMaps");
        if (logoMaps != null && (logoMap = (HashMap)logoMaps.get(insId)) != null && (logoPath = (String)logoMap.get(type + "Logo_" + language)) != null) {
            logoPath = logoPath.replaceAll("\\\\", "/");
            String fileName = logoPath.substring(logoPath.lastIndexOf("/") + 1, logoPath.length());
            String filePath = this.getUploadFilePath(fileName);
            this.writeResponse(response, "image/png", filePath);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String file, byte[] content) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(content);
        }
        catch (Exception e) {
            logger.error("writeFile error!", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setContentType(contentType);
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002", (Throwable)ex);
        }
    }

    private String getDefaultPicFileName(String type, String language) {
        return type + "_logo_default_" + language + ".png";
    }

    private String getFilePrePath(String type) {
        if ("top".equals(type)) {
            return Constant.SYSTEM_ROOT_PATH + "res" + Constant.SYSTEM_PATH_SEPARATOR + "img" + Constant.SYSTEM_PATH_SEPARATOR + "global" + Constant.SYSTEM_PATH_SEPARATOR + "common" + Constant.SYSTEM_PATH_SEPARATOR;
        }
        int lIndex = Constant.SYSTEM_ROOT_PATH.indexOf("portal.ear");
        String tempPath = Constant.SYSTEM_ROOT_PATH.substring(0, lIndex);
        return tempPath + "eas.ear" + Constant.SYSTEM_PATH_SEPARATOR + "sso_web.war" + Constant.SYSTEM_PATH_SEPARATOR + "images" + Constant.SYSTEM_PATH_SEPARATOR + "newlogin1" + Constant.SYSTEM_PATH_SEPARATOR;
    }

    private String getUploadFilePath(String fileName) {
        return Constant.SYSTEM_ROOT_PATH + "res" + Constant.SYSTEM_PATH_SEPARATOR + "file" + Constant.SYSTEM_PATH_SEPARATOR + "upload" + Constant.SYSTEM_PATH_SEPARATOR + fileName;
    }

    private void writeResponse(HttpServletResponse response, String contentType, String filePath) {
        try {
            byte[] imgContent = FileUtil.getByteArrayData((String)filePath);
            response.setContentType(contentType);
            response.getOutputStream().write(imgContent);
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

