/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet.wps;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class WPSCallbackServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String url = req.getRequestURI();
        if (this.checkPathParamXSS(url)) {
            try {
                resp.sendRedirect("/eassso/unreg/unvalibaleParam.jsp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String fileId;
            int pos = url.lastIndexOf("/");
            String post = url.substring(pos + 1);
            String json = "";
            if (!url.contains("versions") && "download".equals(post)) {
                fileId = url.substring(url.indexOf("files/") + 6, pos);
                json = this.getFileUrlWithId(fileId, req, resp);
            } else if ("permission".equals(post)) {
                fileId = url.substring(url.indexOf("files/") + 6, pos);
                json = this.getFilePermissionWithId(fileId, req, resp);
            } else if (url.contains("/getFileDownloadWithId/")) {
                this.getFileDownloadWithPathId(post, req, resp);
            } else if ("token".equals(post)) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
                String cuUserId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
                LtpaToken token = LtpaTokenManager.generate((String)("wps-" + cuUserId + "||" + ctx.getSolution() + "||" + ctx.getAIS() + "||" + ctx.getLocale().toString() + "||" + ctx.getContextID() + "||" + ctx.getUserName() + "-wps"), (String)LtpaTokenManager.getDefaultLtpaConfig());
                String code = token.toString();
                json = "{\"code\":\"" + code + "\"}";
            } else if ("users".equals(post)) {
                json = this.getUserInfo(req, resp);
            } else if ("upload".equals(post)) {
                fileId = url.substring(url.indexOf("files/") + 6, pos);
                json = this.uploadFiles(fileId, req, resp);
            } else if ("versions".equals(post)) {
                fileId = url.substring(url.indexOf("files/") + 6, pos);
                json = this.getVersions(fileId, req, resp);
            } else if (url.contains("/versions/") && !url.contains("download") && !"versions".equals(post)) {
                fileId = url.substring(url.indexOf("files/") + 6, url.indexOf("/version"));
                json = this.getVersionById(fileId, post, req, resp);
            } else if (url.contains("versions") && "download".equals(post)) {
                fileId = url.substring(url.indexOf("files/") + 6, url.indexOf("/version"));
                String version = url.substring(url.indexOf("versions/") + 9, url.indexOf("/download"));
                json = this.getVersionDownloadUrlById(fileId, version, req, resp);
            } else {
                json = this.getFileInfoWithId(post, req, resp);
            }
            resp.setCharacterEncoding("utf-8");
            resp.setContentType("application/json;charset=utf-8");
            PrintWriter out = null;
            try {
                out = resp.getWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            out.write(json);
        }
    }

    public String getFileInfoWithId(String fileId, HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        AttachmentInfo info = null;
        StringBuffer jsonBuffer = new StringBuffer();
        StringBuffer tempIdBuffer = new StringBuffer();
        tempIdBuffer.append(fileId);
        fileId = this.foramtFileId(fileId);
        jsonBuffer.append("{\"code\": 0,\"data\": {");
        try {
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            info = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(fileId));
            String cuUserId = this.foramtFId(tempList[0]);
            jsonBuffer.append("    \"create_time\": " + info.getCreateTime().getTime() + ",\n    \"creator_id\": \"" + cuUserId + "\",\n    \"id\": \"" + tempIdBuffer.toString() + "_status_" + ids[1] + "\",\n    \"modifier_id\": \"" + cuUserId + "\",\n    \"modify_time\": " + info.getLastUpdateTime().getTime() + ",\n    \"name\": \"" + info.getName() + "." + info.getSimpleName() + "\",\n    \"size\": " + info.getSizeInByte() + ",\n    \"version\": 1\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jsonBuffer.append("}}");
        return jsonBuffer.toString();
    }

    public String getFileUrlWithId(String fileId, HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        StringBuffer jsonBuffer = new StringBuffer();
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        jsonBuffer.append("{\"code\": 0,\"data\": {");
        try {
            String url = "/portal/wpsToEASServlet/v3/3rd/files/getFileDownloadWithId/" + fileId + "||" + token;
            url = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + url;
            jsonBuffer.append("    \"url\": \"" + url + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jsonBuffer.append("}}");
        return jsonBuffer.toString();
    }

    public String getFilePermissionWithId(String fileId, HttpServletRequest req, HttpServletResponse resp) {
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        String cuUserId = this.foramtFId(tempList[0]);
        String[] ids = fileId.split("_status_");
        int isupload = 0;
        if (ids.length > 1 && "EDIT".equals(ids[1])) {
            isupload = 1;
        }
        StringBuffer jsonBuffer = new StringBuffer();
        jsonBuffer.append("{\n  \"code\": 0,\n  \"data\": {\n    \"comment\": 0,\n    \"copy\": 0,\n    \"download\": " + isupload + ",\n    \"history\": " + isupload + ",\n    \"print\": 0,\n    \"read\": 1,\n    \"rename\": 0,\n    \"saveas\": " + isupload + ",\n    \"update\": " + isupload + ",\n    \"user_id\": \"" + cuUserId + "\"  }}");
        return jsonBuffer.toString();
    }

    public String getUserInfo(HttpServletRequest req, HttpServletResponse resp) {
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        StringBuffer jsonBuffer = new StringBuffer();
        jsonBuffer.append("{\n  \"code\": 0,\n  \"data\": [");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct d.FID,d.FName_L2 as userName\nFROM T_BAS_Attachment a,T_BAS_BoAttchAsso b,T_BAS_AttachmentWPSHistroy c,t_pm_user d\nWHERE a.FID=c.FAttachmentID AND a.FID=b.FAttachmentID AND a.FLastUpdateUserID=d.FID ");
        try {
            int count = 0;
            boolean isUser = false;
            String nowUserID = this.foramtFId(tempList[0]);
            String nowUserName = this.foramtFId(tempList[5]);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null) {
                while (rs.next()) {
                    if (count != 0) {
                        jsonBuffer.append(",");
                    }
                    if (nowUserID.equals(this.foramtFId(rs.getString("FID")))) {
                        isUser = true;
                    }
                    jsonBuffer.append("{\"id\": \"" + this.foramtFId(rs.getString("FID")) + "\",\"name\":\"" + rs.getString("userName") + "\"}");
                    ++count;
                }
                if (!isUser) {
                    if (count == 0) {
                        jsonBuffer.append("{\"id\": \"" + nowUserID + "\",\"name\":\"" + nowUserName + "\"}");
                    } else {
                        jsonBuffer.append(",{\"id\": \"" + nowUserID + "\",\"name\":\"" + nowUserName + "\"}");
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        jsonBuffer.append("]}");
        return jsonBuffer.toString();
    }

    public String uploadFiles(String fileId, HttpServletRequest req, HttpServletResponse resp) {
        MultipartFile EDITFILE = null;
        try {
            CommonsMultipartResolver resolver = new CommonsMultipartResolver(req.getSession().getServletContext());
            MultipartHttpServletRequest multipartHttpServletRequest = resolver.resolveMultipart(req);
            Map fileMap = multipartHttpServletRequest.getFileMap();
            for (Map.Entry entry : fileMap.entrySet()) {
                EDITFILE = (MultipartFile)entry.getValue();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        AttachmentInfo info = null;
        StringBuffer jsonBuffer = new StringBuffer();
        StringBuffer tempIdBuffer = new StringBuffer();
        tempIdBuffer.append(fileId);
        fileId = this.foramtFileId(fileId);
        jsonBuffer.append("{\"code\": 0,\"data\": {");
        try {
            if (EDITFILE != null) {
                this.saveFile(ctx, EDITFILE, fileId, req, resp);
            }
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            info = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(fileId));
            String cuUserId = this.foramtFId(tempList[0]);
            int version = this.getVersionAfterUpload(fileId, ctx);
            jsonBuffer.append("    \"create_time\": " + info.getCreateTime().getTime() + ",\n    \"creator_id\": \"" + cuUserId + "\",\n    \"id\": \"" + tempIdBuffer.toString() + "_status_" + ids[1] + "\",\n    \"modifier_id\": \"" + cuUserId + "\",\n    \"modify_time\": " + info.getLastUpdateTime().getTime() + ",\n    \"name\": \"" + info.getName() + "." + info.getSimpleName() + "\",\n    \"size\": " + info.getSizeInByte() + ",\n    \"version\": " + version + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jsonBuffer.append("}}");
        return jsonBuffer.toString();
    }

    public int getVersionAfterUpload(String fileId, Context ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.FID,a.FAttachID,a.FName_l2,a.FSimpleName,a.FSize,a.FSizeInByte,a.FLastUpdateTime,d.FName_L2 as userName,FVersion ");
        sql.append(" FROM T_BAS_Attachment a,T_BAS_BoAttchAsso b,T_BAS_AttachmentWPSHistroy c,t_pm_user d ");
        sql.append(" WHERE a.FID=c.FAttachmentID AND a.FID=b.FAttachmentID AND a.FLastUpdateUserID=d.FID ");
        sql.append(" AND  c.FParentAttachmentID ='" + fileId + "' ");
        sql.append(" ORDER BY a.FLastUpdateTime DESC ");
        int version = 0;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null) {
                version = rs.size();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return version;
    }

    public void saveFile(Context ctx, MultipartFile EDITFILE, String attachID, HttpServletRequest request, HttpServletResponse response) throws BOSException, EASBizException {
        AttachmentInfo info = null;
        IAttachment iAttachment = null;
        byte[] oldAttByte = null;
        try {
            if (EDITFILE == null || EDITFILE.getBytes() == null || EDITFILE.getBytes().length < 0) {
                return;
            }
            iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            info = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachID));
            if (info == null) {
                info = iAttachment.getAttachmentInfo("where attachID = '" + attachID + "'");
            }
            oldAttByte = info != null && info.getFile() != null ? info.getFile() : this.downloadFile(ctx, attachID);
            info.setFile(EDITFILE.getBytes());
            info.setSize(StringUtil4File.getFileSizeRepresentation((long)EDITFILE.getBytes().length));
            info.setSizeInByte(EDITFILE.getBytes().length);
            iAttachment.save((IObjectPK)new ObjectUuidPK(attachID), (CoreBaseInfo)info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        info.setFile(oldAttByte);
        this.saveVersion(ctx, info);
    }

    private void saveVersion(Context ctx, AttachmentInfo info) {
        IAttachment iAttachment = null;
        if (info == null) {
            return;
        }
        try {
            String parentId = info.getId().toString();
            iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            BOSUuid attFid = BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"F4AF4F03"));
            BOSUuid boFid = BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"172F3A47"));
            String attachID_temp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            info.getBoAttchAsso().get(0).setId(boFid);
            info.getBoAttchAsso().get(0).setBoID(info.getId().toString());
            info.setId(attFid);
            info.setAttachID(attachID_temp);
            iAttachment.addnew(info);
            this.saveHistroy(ctx, attachID_temp, attFid.toString(), parentId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveHistroy(Context ctx, String id, String attachmentID, String parentId) {
        int version = this.getVersionAfterUpload(parentId, ctx) + 1;
        String sql = "INSERT INTO T_BAS_AttachmentWPSHistroy(FID,FAttachmentID,FParentAttachmentID,FVersion) VALUES('" + id + "','" + attachmentID + "','" + parentId + "','" + version + "')";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public String getVersions(String fileId, HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        Object info = null;
        StringBuffer jsonBuffer = new StringBuffer();
        StringBuffer tempIdBuffer = new StringBuffer();
        tempIdBuffer.append(fileId);
        fileId = this.foramtFileId(fileId);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.FID,a.FAttachID,a.FName_l2,a.FSimpleName,a.FSize,a.FSizeInByte,a.FLastUpdateTime,d.FID as userId,d.FName_L2 as userName,c.FVersion ");
        sql.append(" FROM T_BAS_Attachment a,T_BAS_BoAttchAsso b,T_BAS_AttachmentWPSHistroy c,t_pm_user d ");
        sql.append(" WHERE a.FID=c.FAttachmentID AND a.FID=b.FAttachmentID AND a.FLastUpdateUserID=d.FID ");
        sql.append(" AND  c.FParentAttachmentID ='" + fileId + "' ");
        sql.append(" ORDER BY a.FLastUpdateTime DESC ");
        try {
            String pattern = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            jsonBuffer.append("{\"code\": 0,\"data\":[ ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null) {
                int count = 0;
                while (rs.next()) {
                    Date date = sdf.parse(rs.getString("FLastUpdateTime"));
                    if (count != 0) {
                        jsonBuffer.append(",");
                    }
                    jsonBuffer.append("{    \"create_time\": " + date.getTime() + ",\n    \"creator_id\": \"" + this.foramtFId(rs.getString("userId")) + "\",\n    \"id\": \"" + tempIdBuffer.toString() + "_status_" + ids[1] + "\",\n    \"modifier_id\": \"" + this.foramtFId(rs.getString("userId")) + "\",\n    \"modify_time\": " + date.getTime() + ",\n    \"name\": \"" + rs.getString("FName_l2") + "." + rs.getString("FSimpleName") + "\",\n    \"size\": " + rs.getString("FSizeInByte") + ",\n    \"version\": " + rs.getString("FVersion") + "\n }");
                    ++count;
                }
            }
            jsonBuffer.append("]}");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return jsonBuffer.toString();
    }

    public String getVersionById(String fileId, String version, HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        AttachmentInfo info = null;
        StringBuffer jsonBuffer = new StringBuffer();
        StringBuffer tempIdBuffer = new StringBuffer();
        tempIdBuffer.append(fileId);
        fileId = this.foramtFileId(fileId);
        jsonBuffer.append("{\"code\": 0,\"data\": {");
        try {
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            info = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(fileId));
            jsonBuffer.append("    \"create_time\": " + info.getCreateTime().getTime() + ",\n    \"creator_id\": \"" + this.foramtFId(info.getLastUpdateUser().getId().toString()) + "\",\n    \"id\": \"" + tempIdBuffer.toString() + "_status_" + ids[1] + "\",\n    \"modifier_id\": \"" + this.foramtFId(info.getLastUpdateUser().getId().toString()) + "\",\n    \"modify_time\": " + info.getLastUpdateTime().getTime() + ",\n    \"name\": \"" + info.getName() + "." + info.getSimpleName() + "\",\n    \"size\": " + info.getSizeInByte() + ",\n    \"version\": " + version + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jsonBuffer.append("}}");
        return jsonBuffer.toString();
    }

    public String getVersionDownloadUrlById(String fileId, String version, HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        String token = LtpaTokenManager.toCookie((String)req.getHeader("X-Weboffice-Token")).getValue();
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        StringBuffer jsonBuffer = new StringBuffer();
        fileId = this.foramtFileId(fileId);
        String newFileId = "";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.FID,a.FAttachID,a.FName_l2,a.FSimpleName,a.FSize,a.FSizeInByte,a.FLastUpdateTime,d.FID as userId,d.FName_L2 as userName,c.FVersion ");
        sql.append(" FROM T_BAS_Attachment a,T_BAS_BoAttchAsso b,T_BAS_AttachmentWPSHistroy c,t_pm_user d ");
        sql.append(" WHERE a.FID=c.FAttachmentID AND a.FID=b.FAttachmentID AND a.FLastUpdateUserID=d.FID ");
        sql.append(" AND  c.FParentAttachmentID ='" + fileId + "' ");
        sql.append(" ORDER BY a.FLastUpdateTime DESC ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null) {
                int versions = rs.size();
                while (rs.next()) {
                    if (versions == Integer.parseInt(version)) {
                        newFileId = rs.getString("FID");
                    }
                    --versions;
                }
            }
            jsonBuffer.append("]}");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.getFileUrlWithId(newFileId, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFileDownloadWithPathId(String fileId, HttpServletRequest req, HttpServletResponse response) {
        String[] ids = fileId.split("_status_");
        if (ids.length > 1) {
            fileId = ids[0];
        }
        fileId = this.foramtFileId(fileId);
        String token = fileId.split("\\|\\|")[1];
        String tempToken = BASE64Util.decodeAsString((String)token);
        tempToken = tempToken.substring(tempToken.indexOf("wps-") + 4, tempToken.indexOf("-wps"));
        String[] tempList = tempToken.split("\\|\\|");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
        if (ctx == null) {
            ctx = new Context((IObjectPK)new ObjectUuidPK(tempList[0]), tempList[1], tempList[2], new Locale(tempList[3]), tempList[4]);
        }
        String attachID = fileId = this.foramtFileId(fileId.split("\\|\\|")[0]);
        response.reset();
        ServletOutputStream outStream = null;
        byte[] attByte = null;
        InputStream inStream = null;
        AttachmentInfo info = null;
        try {
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            info = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachID));
            if (info != null) {
                String nameStr = info.getName() + "." + info.getSimpleName();
                response.setHeader("Content-Disposition", nameStr);
                String type = this.getContentType(info.getSimpleName());
                response.setContentType(type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            outStream = response.getOutputStream();
            attByte = info != null && info.getFile() != null ? info.getFile() : this.downloadFile(ctx, attachID);
            inStream = new ByteArrayInputStream(attByte);
            response.setContentLength(inStream.available());
            int bytes = 0;
            while ((bytes = inStream.read(attByte)) != -1) {
                outStream.write(attByte, 0, bytes);
            }
            if (outStream != null) {
                outStream.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            try {
                response.flushBuffer();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            try {
                response.flushBuffer();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    private byte[] downloadFile(Context ctx, String attId) throws BOSException, EASBizException {
        byte[] data = null;
        if (!StringUtils.isEmpty((String)attId)) {
            AttachmentInfo info = null;
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            try {
                info = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(attId));
                if (info == null) {
                    info = iAttachment.getAttachmentInfo("where attachID = '" + attId + "'");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (info != null && info.getFile() != null) {
                    data = info.getFile();
                }
                if (info != null && info.getFile() == null) {
                    data = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(info.getId().toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public String getContentType(String simplename) {
        if (simplename.equals("doc") || simplename.equals("docx")) {
            return "application/msword";
        }
        if (simplename.equals("xls") || simplename.equals("xlsx")) {
            return "application/x-excel";
        }
        if (simplename.equals("ppt") || simplename.equals("pptx")) {
            return "application/ms-powerpoint";
        }
        if (simplename.equals("pdf")) {
            return "application/pdf";
        }
        if (simplename.equals("zip") || simplename.equals("rar")) {
            return "application/zip";
        }
        return "text/plain;charset=utf-8";
    }

    public String foramtFileId(String fileId) {
        fileId = fileId.replaceAll("_2F", "/");
        fileId = fileId.replaceAll("_2B", "\\+");
        fileId = fileId.replaceAll("_3D", "=");
        fileId = fileId.replaceAll("%7C", "|");
        return fileId;
    }

    public String foramtFId(String fileId) {
        if (!StringUtils.isEmpty((String)fileId)) {
            fileId = fileId.replaceAll("000", "LL");
            fileId = fileId.replaceAll("-", "__");
            fileId = fileId.replaceAll("/", "_2F");
            fileId = fileId.replaceAll("\\+", "_2B");
            fileId = fileId.replaceAll("=", "_3D");
        }
        return fileId;
    }

    public boolean checkPathParamXSS(String param) {
        String[] dangerCharacters;
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        boolean isXSS = false;
        for (String s : dangerCharacters = new String[]{"{", "}", "<", ">", "\\|", "\\./", "\\.\\./", "()", "javascript", "document", "eval", "onblur", "onclick", "script", "alert", "iframe"}) {
            if (!param.contains(s)) continue;
            isXSS = true;
            break;
        }
        return isXSS;
    }
}

