/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet.yzj.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AjaxException;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AppAuth2Exception;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.OpenApiAuthException;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.Ajax;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.AppAuth2;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.AuthorizationUtil;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import com.kingdee.eas.cp.eip.sso.util.AutoLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudToEASManager {
    private static final Logger logger = LoggerFactory.getLogger(CloudToEASManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserInfoMapByOpenId(Context ctx, String openId) {
        String sql = "SELECT umap.fusernumber userNumber FROM T_pm_easxtusermap umap where fxtid = ?";
        String userNumber = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{openId});
            if (rs.next()) {
                userNumber = rs.getString("userNumber");
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return userNumber;
    }

    public static Context getContextWithAutoLoginCfg() throws ServletException {
        String dataCenter = AutoLoginConfigPropUtil.getDataCenter();
        String language = AutoLoginConfigPropUtil.getLocale();
        Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)language, null);
        return ctx;
    }

    public static String getOpenId(String qrcode_ticket) throws AppAuth2Exception, OpenApiAuthException, AjaxException {
        String access_token = null;
        try {
            access_token = AppAuth2.getAccess_token();
        }
        catch (AppAuth2Exception e) {
            logger.error("get Access_token Exception : " + e.getMessage());
            throw e;
        }
        String oauth_consumer_key = QrCodeTokenHelper.getAppID();
        String oauth_consumer_secret = QrCodeTokenHelper.getAppSecret();
        String oauth_signature_method = "HMAC-SHA1";
        long oauth_timestamp = System.currentTimeMillis() / 1000L;
        String oauth_nonce = String.valueOf(oauth_timestamp + (long)QrCodeTokenHelper.RAND.nextInt());
        float oauth_version = 1.0f;
        HttpPost post = new HttpPost(QrCodeTokenHelper.getTicketTokenURL());
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        JSONObject params = new JSONObject();
        params.put("access_token", (Object)access_token);
        params.put("ticket", (Object)qrcode_ticket);
        StringEntity paramsEntity = new StringEntity(params.toString(), "utf-8");
        post.setEntity((HttpEntity)paramsEntity);
        try {
            String oauth_signature = AuthorizationUtil.generateAuthorizationHeader((String)oauth_consumer_key, (String)oauth_consumer_secret, (String)oauth_signature_method, (long)oauth_timestamp, (String)oauth_nonce, (float)oauth_version, null, null, null, (String)QrCodeTokenHelper.getTicketTokenURL(), new HashMap(), (String)"POST");
            post.setHeader("Authorization", oauth_signature);
        }
        catch (Exception e) {
            logger.error("generateAuthorizationHeader error:  ");
            e.printStackTrace();
            OpenApiAuthException oaae = new OpenApiAuthException("\u751f\u6210\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\u3002" + e.getMessage());
            throw oaae;
        }
        String ret = null;
        try {
            ret = Ajax.exceuteRequest((HttpRequestBase)post, (String)"utf-8");
        }
        catch (AjaxException e) {
            logger.error("get openid from yunzhijia error :   " + e.getMessage());
            e.printStackTrace();
            throw new AjaxException("\u672a\u77e5\u5f02\u5e38(\u83b7\u53d6openid)\uff0c\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\u3002" + e.getMessage());
        }
        logger.error(ret);
        if (ret != null) {
            JSONObject retJson = JSONObject.parseObject((String)ret);
            JSONObject data = (JSONObject)retJson.get((Object)"data");
            boolean success = retJson.getBoolean("success");
            if (success) {
                String openid = data.getString("openid");
                String userName = data.getString("username");
                logger.error("QrCodeLogin : from yunzhizjia UserName " + userName);
                return openid;
            }
            logger.error("get openid from yunzhijia; return success is false, Unknown Exception");
            throw new AjaxException("\u672a\u77e5\u5f02\u5e38\uff0c\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        return null;
    }
}

