/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.system.context;

import com.kingdee.bos.Context;
import com.kingdee.bos.sso.client.context.AbstractContextConstructor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.portal.web.system.SysManager;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PortalContextConstructor
extends AbstractContextConstructor {
    private static Logger logger = Logger.getLogger(PortalContextConstructor.class);

    public boolean initContext(String userNmae, Map<String, Object> attributes, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.buildPortalContext(attributes, httpRequest);
        return true;
    }

    private void buildPortalContext(Map<String, Object> attributes, HttpServletRequest request) {
        Context context = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (context == null) {
            logger.error((Object)(logger.getClass().getName() + " buildPortalContext context is null"));
            return;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        PortalContext portalContext = new PortalContext();
        portalContext.setIp(request.getRemoteAddr());
        portalContext.setLocale(PortalContextConstructor.populateStandardLocal(context.getLocale()));
        portalContext.setLoginDate(new Date());
        portalContext.setSessionId(request.getSession().getId());
        portalContext.getMetaInfo().put("eas_context", context);
        portalContext.getMetaInfo().put("eas_context_id", context.getContextID());
        User loginUser = new User();
        loginUser.setId(userInfo.getId().toString());
        loginUser.setCode(userInfo.getNumber());
        loginUser.setName(userInfo.getName());
        portalContext.setLoginUser(loginUser);
        portalContext.getMetaInfo().put("current_data_center", attributes.get("dataCenter"));
        DataCenterManager dataCenterManager = new DataCenterManager(context);
        portalContext.getMetaInfo().put("current_data_center_name", dataCenterManager.getDatacenterName(context));
        request.getSession().setAttribute("portal_context", (Object)portalContext);
        SysManager.logonSuccess(request.getSession());
    }

    private static Locale populateStandardLocal(Locale easLocale) {
        if ("l1".equals(easLocale.getLanguage())) {
            return Locale.ENGLISH;
        }
        if ("l2".equals(easLocale.getLanguage())) {
            return Locale.CHINA;
        }
        if ("l3".equals(easLocale.getLanguage())) {
            return Locale.TAIWAN;
        }
        return Locale.CHINA;
    }
}

