/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.complexquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.md5;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.RowSetSizeParamConfig;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.base.syssetting.app.complexquery.IEmpQueryImpl;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.util.ParamUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.web.util.UuidGenerator;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class AbstractEmpQueryImpl
implements IEmpQueryImpl {
    private static final String QUERY_STORE_DATA = "query_store_data";
    private static final String TEMP_TABLE_NAME = "temp_table_name";
    private static final String QUERY_SQL = "query_sql";
    private static final String TEMP_TABLE_COUNT = "query_store_count";
    private static final String QUERY_STORE_KEY = "query_store_key";
    private static Logger logger = Logger.getLogger(AbstractEmpQueryImpl.class);

    @Override
    public GridDataEntity execQuery(HttpServletRequest request, Context ctx, String function, SqlParam param) throws Exception {
        GridDataEntity gridData = null;
        gridData = param.isNeedDistinct() ? this.empQuery(request, ctx, function, param) : this.execQueryReal(request, ctx, function, param);
        return gridData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GridDataEntity execQuery0(HttpServletRequest request, Context ctx, String function, SqlParam param) throws Exception {
        boolean isEnableEncrypt = ParamUtil.IsEnableEncrypt((Context)ctx);
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        Map otherParams = (Map)request.getAttribute("_userData_");
        long totalCount = 0L;
        int rows = (Integer)otherParams.get("rows");
        int page = (Integer)otherParams.get("page");
        boolean isExportAllToExcelCount = (Boolean)otherParams.get("isExportAllToExcelCount");
        boolean isOrderForExportAll = false;
        String exportCustomSql = null;
        if (null != otherParams.get("sHRSupportExportOrder")) {
            isOrderForExportAll = (Boolean)otherParams.get("sHRSupportExportOrder");
        }
        if (null != otherParams.get("exportCustomSql")) {
            exportCustomSql = (String)otherParams.get("exportCustomSql");
        }
        if (StringUtils.isEmpty(exportCustomSql) && param.isNeedDistinct()) {
            isOrderForExportAll = false;
        }
        String queryUuid = null;
        String tempTableName = null;
        long begin = 0L;
        long end = 0L;
        Connection conn = null;
        Statement statement = null;
        Object rs = null;
        StringBuffer orderBySql = new StringBuffer();
        int dbType = -1;
        String excuteSql = null;
        if (isExportAllToExcelCount) {
            GridDataEntity t12222222;
            try {
                String querySql = null;
                if (StringUtils.isEmpty((String)exportCustomSql)) {
                    if (isOrderForExportAll) {
                        this.addSorterItemToSelector(param);
                    }
                    querySql = this.getStructureConfigParseSql(request, ctx, param);
                    if (isOrderForExportAll && param.getSorter() != null) {
                        SorterItemInfo info = null;
                        StringBuffer orderby = new StringBuffer().append(" order by ");
                        for (int i = 0; i < param.getSorter().size(); ++i) {
                            if (i > 0) {
                                orderby.append(",");
                            }
                            info = param.getSorter().get(i);
                            orderby.append(" \"").append(info.getPropertyName()).append("\" ").append(info.getSortType());
                        }
                        orderBySql.append(orderby.toString());
                    }
                } else {
                    querySql = this.getCustomSQL(request, ctx, param, orderBySql, exportCustomSql);
                }
                begin = System.currentTimeMillis();
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                conn = EJBFactory.getConnection((Context)ctx);
                statement = conn.createStatement();
                dbType = KSqlUtil.getDbType((Connection)conn);
                if (isEnableEncrypt) {
                    int indexOf = (querySql = querySql.replaceAll("\r|\n", " ").replaceAll("\\s+", " ")).toLowerCase().indexOf(" from ");
                    if (indexOf > 0) {
                        String substring = querySql.substring(indexOf);
                        excuteSql = "select count(*) cc " + substring;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("sql not right:" + SHRCheck.vaildLog((String)request.getParameter("uipk"))));
                        }
                        excuteSql = MessageFormat.format("select count(*) cc from ({0})  as tt", querySql);
                    }
                    rs = DbUtil.executeQuery((Context)ctx, (String)excuteSql);
                    JdbcRowSet rs0 = new JdbcRowSet();
                    rs0.populate((ResultSet)rs);
                    while (rs0.next()) {
                        totalCount = rs0.getLong("cc");
                    }
                } else {
                    long t0 = System.currentTimeMillis();
                    excuteSql = MessageFormat.format("select * into {0} from ( {1} ) TTT ", tempTableName, querySql);
                    statement.execute(excuteSql);
                    long t12222222 = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("execQuery0 tempTableName create cost: {0} ms, {1} s, querySql:{2}", t12222222 - t0, Float.valueOf((float)(t12222222 - t0) / 1000.0f), excuteSql));
                    }
                    excuteSql = MessageFormat.format("select count(*) cc from {0} ", tempTableName);
                    rs = statement.executeQuery(excuteSql);
                    JdbcRowSet rs0 = new JdbcRowSet();
                    rs0.populate((ResultSet)rs);
                    while (rs0.next()) {
                        totalCount = rs0.getLong("cc");
                    }
                }
                HashMap<String, Object> userdata = new HashMap<String, Object>();
                userdata.put("querySql", querySql);
                userdata.put("tempTableName", tempTableName);
                userdata.put("dbType", dbType);
                userdata.put("conn", conn);
                userdata.put("statement", statement);
                userdata.put("empQueryImplOrderBySql", orderBySql.toString());
                GridDataEntity gridData = new GridDataEntity();
                gridData.setRecords(totalCount);
                gridData.setUserdata(userdata);
                end = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("execQuery0 tempTable and count cost:{0} ms, {1} s", end - begin, Float.valueOf((float)(end - begin) / 1000.0f)));
                }
                t12222222 = gridData;
            }
            catch (SQLException e) {
                try {
                    this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
                    logger.error((Object)("333 sql is:" + SHRCheck.vaildLog(excuteSql)), (Throwable)e);
                    throw new SHRWebException("Sql3 execute exception : " + excuteSql, e);
                    catch (Exception e2) {
                        this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
                        throw new SHRWebException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, null, null);
                    if (totalCount <= 0L) {
                        this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, null, null);
            if (totalCount <= 0L) {
                this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
            }
            return t12222222;
        }
        GridDataEntity gridData = new GridDataEntity();
        begin = System.currentTimeMillis();
        ArrayList rowList = null;
        tempTableName = (String)otherParams.get("tempTableName");
        boolean isLastTime = (Boolean)otherParams.get("isLastTime");
        dbType = (Integer)otherParams.get("dbType");
        conn = (Connection)otherParams.get("conn");
        statement = (Statement)otherParams.get("statement");
        orderBySql.append((String)otherParams.get("empQueryImplOrderBySql"));
        String qureySql = (String)otherParams.get("querySql");
        excuteSql = isEnableEncrypt ? (StringUtils.isEmpty((String)exportCustomSql) && isOrderForExportAll ? qureySql + " " + orderBySql.toString() : qureySql) : (StringUtils.isEmpty((String)exportCustomSql) && isOrderForExportAll ? MessageFormat.format("SELECT * from {0} {1}", tempTableName, orderBySql.toString()) : MessageFormat.format("SELECT * from {0}", tempTableName));
        PagingHelper pageHelper = new PagingHelper();
        try {
            excuteSql = excuteSql.replaceAll("\r|\n", " ").replaceAll("\\s+", " ");
            excuteSql = pageHelper.getPagingSqlNoOptmize(ctx, excuteSql, (page - 1) * rows, rows);
            long t0 = System.currentTimeMillis();
            if (isEnableEncrypt) {
                ParamData paramData = pageHelper.getParamData();
                rs = this.exeQuerySql(ctx, excuteSql, paramData);
            } else {
                rs = statement.executeQuery(excuteSql);
            }
            JdbcRowSet rs0 = new JdbcRowSet();
            rs0.populate((ResultSet)rs);
            long t1 = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("execQuery0 pageHelper.getPagingSqlNoOptmize cost:{0} ms, {1} s, excuteSql:{2}", t1 - t0, Float.valueOf((float)(t1 - t0) / 1000.0f), excuteSql));
            }
            rowList = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rs0);
        }
        catch (SQLException e) {
            logger.error((Object)("333 sql is:" + excuteSql), (Throwable)e);
            this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
            throw new SHRWebException("Sql3 execute exception : " + excuteSql, e);
        }
        catch (Exception e) {
            this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
            if (isLastTime) {
                this.releaseResource(ctx, tempTableName, conn, statement, (ResultSet)rs);
            }
        }
        if (null == rowList) {
            rowList = new ArrayList();
        }
        gridData.setRows(rowList);
        gridData.setQueryUuid(queryUuid);
        gridData.setRecords(gridData.getRows().size());
        gridData.setPage(page);
        return gridData;
    }

    @Override
    public GridDataEntity empQuery(HttpServletRequest request, Context ctx, String function, SqlParam param) throws Exception {
        List rowList;
        String queryUuid;
        int page;
        int rows;
        int totalCount;
        block39: {
            block38: {
                boolean isEnableEncrypt = ParamUtil.IsEnableEncrypt((Context)ctx);
                if (StringUtils.isEmpty((String)function)) {
                    function = "EmpQuery";
                }
                String tempTableName = null;
                totalCount = 0;
                long begin = 0L;
                long end = 0L;
                rows = param.getRows();
                page = param.getPage();
                queryUuid = null;
                String queryKeyOld = null;
                String queryKeyNow = this.md5HashCode(param);
                Map<String, Map<String, Object>> storeDatas = null;
                String querySql = "";
                Map<String, Object> storeData = null;
                if (param.isSupportQueryUuid()) {
                    queryUuid = param.getQueryUuid();
                    storeDatas = this.getStoreDatas(request);
                    storeData = storeDatas.get(queryUuid);
                    if (storeData != null) {
                        tempTableName = (String)storeData.get(TEMP_TABLE_NAME);
                        queryKeyOld = (String)storeData.get(QUERY_STORE_KEY);
                        querySql = (String)storeData.get(QUERY_SQL);
                        if (!param.isSynchTotal()) {
                            totalCount = (Integer)storeData.get(TEMP_TABLE_COUNT);
                        }
                        if (!queryKeyOld.equals(queryKeyNow)) {
                            storeDatas.remove(queryUuid);
                            if (tempTableName != null) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                            }
                            storeData = null;
                            tempTableName = null;
                            totalCount = 0;
                        }
                    }
                }
                if (StringUtils.isEmpty(tempTableName)) {
                    this.addSorterItemToSelector(param);
                    querySql = this.getStructureConfigParseSql(request, ctx, param);
                    tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                    String tempSql = "select * into " + tempTableName + " from (" + querySql + ") T ";
                    DbUtil.execute((Context)ctx, (String)tempSql.toString());
                    if (param.isSupportQueryUuid() && null != storeDatas) {
                        queryUuid = UuidGenerator.generate();
                        storeData = new HashMap<String, Object>();
                        storeData.put(TEMP_TABLE_NAME, tempTableName);
                        storeData.put(QUERY_STORE_KEY, queryKeyNow);
                        storeData.put(QUERY_SQL, querySql);
                        if (!param.isSynchTotal()) {
                            storeData.put(TEMP_TABLE_COUNT, totalCount);
                        }
                        storeDatas.put(queryUuid, storeData);
                    }
                }
                if (isEnableEncrypt) {
                    if (param.isReqTotalCount() || !param.isSynchTotal()) {
                        String excuteSql = null;
                        int indexOf = (querySql = querySql.replaceAll("\r|\n", " ").replaceAll("\\s+", " ")).toLowerCase().indexOf(" from ");
                        if (indexOf > 0) {
                            String substring = querySql.substring(indexOf);
                            excuteSql = "select count(*) cc " + substring;
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("sql not right:" + SHRCheck.vaildLog((String)request.getParameter("uipk"))));
                            }
                            excuteSql = MessageFormat.format("select count(*) cc from ({0})  as tt", querySql);
                        }
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)excuteSql);
                        JdbcRowSet rs0 = new JdbcRowSet();
                        rs0.populate((ResultSet)rs);
                        while (rs0.next()) {
                            totalCount = rs0.getInt("cc");
                        }
                        if (null != storeData) {
                            storeData.put(TEMP_TABLE_COUNT, totalCount);
                        }
                    } else {
                        totalCount = rows * page;
                    }
                } else if (param.isReqTotalCount() || !param.isSynchTotal()) {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from " + tempTableName));
                    while (rs.next()) {
                        totalCount = rs.getInt(1);
                    }
                    if (null != storeData) {
                        storeData.put(TEMP_TABLE_COUNT, totalCount);
                    }
                } else {
                    totalCount = rows * page;
                }
                int length = rows;
                if (page * rows > totalCount) {
                    length = totalCount - (page - 1) * rows;
                }
                int start = (page - 1) * rows;
                rowList = null;
                int top = start + length;
                if (param.isReqTotalCount() && param.isSynchTotal()) break block38;
                String sql = "";
                String orderby = "";
                if (param.getSorter() != null) {
                    SorterItemInfo info = null;
                    orderby = " order by ";
                    for (int i = 0; i < param.getSorter().size(); ++i) {
                        if (i > 0) {
                            orderby = orderby + ",";
                        }
                        info = param.getSorter().get(i);
                        orderby = orderby + " \"" + info.getPropertyName() + "\" " + info.getSortType();
                    }
                }
                if (isEnableEncrypt) {
                    sql = querySql + orderby;
                } else {
                    sql = "SELECT TOP " + top + " * from " + tempTableName;
                    sql = sql + orderby;
                }
                PagingHelper pageHelper = new PagingHelper();
                Connection conn = null;
                try {
                    begin = System.currentTimeMillis();
                    conn = EJBFactory.getConnection((Context)ctx);
                    sql = pageHelper.getPagingSqlNoOptmize(ctx, sql, start, length);
                    ParamData paramData = pageHelper.getParamData();
                    IRowSet rowset = this.exeQuerySql(ctx, sql, paramData);
                    end = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("empQuery pageHelper.getPagingSqlNoOptmize and query cost:{0} ms, {1} s, querySql:{2}", begin - end, Float.valueOf((float)(begin - end) / 1000.0f), sql));
                    }
                    rowList = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowset);
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Connection)conn);
                break block39;
            }
            rowList = new ArrayList();
        }
        GridDataEntity gridData = new GridDataEntity();
        gridData.setRows(rowList);
        gridData.setQueryUuid(queryUuid);
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        if (param.isReqTotalCount() || !param.isSynchTotal()) {
            gridData.setRecords(totalCount);
        } else {
            gridData.setRecords(gridData.getRows() == null ? 0L : (long)gridData.getRows().size());
        }
        if (gridData.getRows() == null || gridData.getRows().size() == 0) {
            gridData.setTotal(0L);
        }
        gridData.setPage(page);
        return gridData;
    }

    @Override
    public GridDataEntity execQueryReal(HttpServletRequest request, Context ctx, String function, SqlParam param) throws Exception {
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        int rows = param.getRows();
        int page = param.getPage();
        String querySql = null;
        int totalCount = 0;
        long begin = 0L;
        long end = 0L;
        String queryUuid = null;
        String queryKeyOld = null;
        String queryKeyNow = this.md5HashCode(param);
        Map<String, Map<String, Object>> storeDatas = null;
        Map<String, Object> storeData = null;
        if (param.isSupportQueryUuid()) {
            queryUuid = param.getQueryUuid();
            storeDatas = this.getStoreDatas(request);
            storeData = storeDatas.get(queryUuid);
            if (storeData != null) {
                querySql = (String)storeData.get(QUERY_SQL);
                queryKeyOld = (String)storeData.get(QUERY_STORE_KEY);
                if (!param.isSynchTotal()) {
                    totalCount = (Integer)storeData.get(TEMP_TABLE_COUNT);
                }
                if (!queryKeyOld.equals(queryKeyNow)) {
                    storeDatas.remove(queryUuid);
                    storeData = null;
                    querySql = null;
                    totalCount = 0;
                }
            }
        }
        if (querySql == null) {
            this.addSorterItemToSelector(param);
            querySql = this.getStructureConfigParseSql(request, ctx, param);
            if (param.isSupportQueryUuid() && null != storeDatas) {
                queryUuid = UuidGenerator.generate();
                storeData = new HashMap<String, Object>();
                storeData.put(QUERY_SQL, querySql);
                storeData.put(QUERY_STORE_KEY, queryKeyNow);
                if (!param.isSynchTotal()) {
                    storeData.put(TEMP_TABLE_COUNT, totalCount);
                }
                storeDatas.put(queryUuid, storeData);
            }
        }
        String subSql = querySql.substring(querySql.indexOf("FROM"));
        if (param.isReqTotalCount() || param.isAll() || !param.isSynchTotal()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) " + subSql));
            if (rs.next()) {
                totalCount = rs.getInt(1);
            }
            if (null != storeData) {
                storeData.put(TEMP_TABLE_COUNT, totalCount);
            }
        } else {
            totalCount = rows * page;
        }
        if (param.getSorter() != null) {
            SorterItemInfo info = null;
            String orderby = " order by ";
            for (int i = 0; i < param.getSorter().size(); ++i) {
                if (i > 0) {
                    orderby = orderby + ",";
                }
                info = param.getSorter().get(i);
                orderby = orderby + " \"" + info.getPropertyName() + "\" " + info.getSortType();
            }
            querySql = querySql + orderby;
        }
        if (param.isAll()) {
            rows = totalCount;
            page = 1;
        }
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        List<Map<String, Object>> rowList = this.doPagingQuery(ctx, param, querySql, start, length);
        GridDataEntity gridData = new GridDataEntity();
        gridData.setRows(rowList);
        gridData.setQueryUuid(queryUuid);
        int n = rows = 0 == rows ? 1 : rows;
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        if (param.isReqTotalCount() || !param.isSynchTotal()) {
            gridData.setRecords(totalCount);
        } else {
            gridData.setRecords(gridData.getRows() == null ? 0L : (long)gridData.getRows().size());
        }
        if (gridData.getRows() == null || gridData.getRows().size() == 0) {
            gridData.setTotal(0L);
        }
        gridData.setPage(page);
        return gridData;
    }

    @Override
    public void removeStoreData(HttpServletRequest request, String key) {
        Map<String, Map<String, Object>> storeDatas = this.getStoreDatas(request);
        storeDatas.remove(key);
    }

    protected final void addSorterItemToSelector(SqlParam param) {
        int i;
        SorterItemCollection sorter = param.getSorter();
        if (sorter == null) {
            return;
        }
        String fieldName = null;
        Map selector = param.getSelectMapping();
        String selectFieldName = null;
        boolean isExist = false;
        int size = sorter.size();
        for (int i2 = 0; i2 < size; ++i2) {
            fieldName = sorter.get(i2).getPropertyName();
            isExist = false;
            for (Map.Entry e : selector.entrySet()) {
                selectFieldName = (String)e.getKey();
                if (!selectFieldName.equalsIgnoreCase(fieldName)) continue;
                isExist = true;
                break;
            }
            if (isExist) {
                sorter.get(i2).setPropertyName(selectFieldName);
                continue;
            }
            selector.put(fieldName, fieldName);
        }
        HashSet<String> dump = new HashSet<String>();
        SorterItemCollection removeSorters = new SorterItemCollection();
        int size2 = sorter.size();
        for (i = 0; i < size2; ++i) {
            if (dump.contains(sorter.get(i).getPropertyName())) {
                removeSorters.add(sorter.get(i));
                continue;
            }
            dump.add(sorter.get(i).getPropertyName());
        }
        if (removeSorters.size() > 0) {
            size2 = removeSorters.size();
            for (i = 0; i < size2; ++i) {
                sorter.remove(removeSorters.get(i));
            }
        }
    }

    protected final void releaseResource(Context ctx, String tempTableName, Connection conn, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
    }

    protected abstract String getCustomSQL(HttpServletRequest var1, Context var2, SqlParam var3, StringBuffer var4, String var5);

    protected final String md5HashCode(SqlParam param) {
        StringBuffer sb = new StringBuffer();
        sb.append(param.getSelectMapping().toString());
        if (StringUtils.isEmpty((String)param.getFilterInfo().getMaskString())) {
            sb.append(param.getFilterInfo().toString());
        } else {
            sb.append(param.getFilterInfo().getFilterItems().toString());
        }
        if (null != param.getDynExtendSQLJoinConditionPostFragment()) {
            sb.append(param.getDynExtendSQLJoinConditionPostFragment().toString());
        }
        sb.append(param.getFilterDate().toString());
        sb.append(param.getInfoCtr().toString());
        if (null != param.getSorter()) {
            sb.append(param.getSorter().toString());
        }
        md5 md = new md5(sb.toString());
        md.processString();
        return md.getStringDigest();
    }

    protected final Map<String, Map<String, Object>> getStoreDatas(HttpServletRequest request) {
        HashMap storeDatas = (HashMap)request.getSession().getAttribute(QUERY_STORE_DATA);
        if (storeDatas == null) {
            storeDatas = new HashMap();
            request.getSession().setAttribute(QUERY_STORE_DATA, storeDatas);
        }
        return storeDatas;
    }

    protected List<Map<String, Object>> doPagingQuery(Context ctx, SqlParam param, String querySql, int start, int length) throws Exception {
        int maxPagingRowSize = this.getMaxPagingRowSize(param);
        int pagingRowSize = Math.min(length, maxPagingRowSize);
        int currentIndex = start;
        Connection conn = null;
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        List rows = null;
        if (!param.isReqTotalCount()) {
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                PagingHelper pageHelper = new PagingHelper();
                boolean isSQLServerDB = SystemContextUtil.isSQLServerDB((Context)ctx);
                for (int fetchRowSize = 0; fetchRowSize < length; fetchRowSize += pagingRowSize) {
                    int top = currentIndex + pagingRowSize;
                    if (top > start + length) {
                        top = start + length;
                        pagingRowSize = top - currentIndex;
                    }
                    String sql = querySql.trim().replaceFirst("SELECT", "SELECT TOP " + top);
                    long begin = System.currentTimeMillis();
                    sql = pageHelper.getPagingSqlNoOptmize(ctx, sql, currentIndex, pagingRowSize);
                    if (!isSQLServerDB && "SCHINESE_PINYIN".equals(param.getSorterMethod()) && sql.indexOf("ORDER BY") > -1) {
                        StringBuffer order0 = new StringBuffer();
                        String orderByEnd = sql.substring(sql.indexOf("ORDER BY"), sql.length());
                        String orderBy = orderByEnd.substring(0, orderByEnd.indexOf(")"));
                        String[] orders = orderBy.replace("ORDER BY ", "").split(",");
                        order0.append("ORDER BY ");
                        int i = 0;
                        for (String s : orders) {
                            String[] fields = s.trim().split("\\s+");
                            if (i > 0) {
                                order0.append(",");
                            }
                            order0.append(" NLSSORT(").append(fields[0].trim()).append(", 'NLS_SORT=SCHINESE_PINYIN_M') ").append(fields[1].trim());
                            ++i;
                        }
                        sql = sql.replace(orderBy, order0.toString());
                    }
                    ParamData paramData = pageHelper.getParamData();
                    IRowSet rowset = this.exeQuerySql(ctx, sql, paramData);
                    long end = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("doPagingQuery pageHelper.getPagingSqlNoOptmize and query cost:{0} ms, {1} s, querySql:{2}", begin - end, Float.valueOf((float)(begin - end) / 1000.0f), sql));
                    }
                    rows = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowset);
                    rowList.addAll(rows);
                    currentIndex = top;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return rowList;
    }

    public IRowSet exeQuerySql(Context ctx, String sql, ParamData param) throws SHRWebException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new SHRWebException(exc);
        }
        try {
            statement = conn.prepareStatement(sql);
            ParamData.setParamDataToStatement((ParamData)param, (PreparedStatement)statement);
            rs = statement.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("exeQuerySql:" + sql), (Throwable)exc);
                throw new SHRWebException(exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    protected final int getMaxPagingRowSize(SqlParam param) {
        return new RowSetSizeParamConfig().getCollectionExceptionSize() / param.getSelectMapping().size();
    }

    protected abstract String getStructureConfigParseSql(HttpServletRequest var1, Context var2, SqlParam var3) throws EASBizException, BOSException;
}

