/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.button.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.service.SHRDataPermissionModel;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.permission.button.impl.ListDataButtonPermissionModelBuilder;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class QueryListButtonDataPermissionModelBuilder
extends ListDataButtonPermissionModelBuilder {
    private static Logger logger = Logger.getLogger(QueryListButtonDataPermissionModelBuilder.class);

    public IRowSet getBizObject(HttpServletRequest request) throws SHRWebException {
        String query = this.uiViewInfo.getQuery();
        Set<String> billIdSet = this.getBillIdSet(request);
        if (null == billIdSet || billIdSet.isEmpty()) {
            try {
                String method = request.getParameter("method");
                if (StringUtils.isEmpty((String)method)) {
                    method = "initalize";
                }
                logger.debug((Object)MessageFormat.format("QueryListButtonDataPermissionModelBuilder getBizObject ,param billIdSet is null. uipk is {0},method is {1}", this.uiViewInfo.getUipk(), method));
            }
            catch (Exception method) {
                // empty catch block
            }
            return null;
        }
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(query));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = null;
        try {
            rowSet = exec.executeQuery();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    @Override
    public List<SHRDataPermissionModel> convertBizObjectToDataPermissionObject(HttpServletRequest request, Object bizObject) throws SHRWebException {
        Set<String> adminOrgFieldSet = this.getAdminOrgFieldName();
        Set<String> hrOrgFieldSet = this.getHrOrgFieldName();
        String isDefaultManageField = this.getDefaultManageFieldName();
        String checkRule = this.getCheckRuleFieldName();
        ArrayList<SHRDataPermissionModel> list = new ArrayList<SHRDataPermissionModel>();
        if (null == bizObject) {
            return list;
        }
        IRowSet rowSet = (IRowSet)bizObject;
        try {
            while (rowSet.next()) {
                Set<String> hrOrgFieldValueSet;
                SHRDataPermissionModel dataPermissionModel = new SHRDataPermissionModel();
                dataPermissionModel.setCheckRule(checkRule);
                Set<String> fieldValueSet = this.getFieldValueSet(adminOrgFieldSet, rowSet);
                if (!fieldValueSet.isEmpty()) {
                    dataPermissionModel.setOrgId(fieldValueSet);
                }
                if (!(hrOrgFieldValueSet = this.getFieldValueSet(hrOrgFieldSet, rowSet)).isEmpty()) {
                    dataPermissionModel.setHrOrgId(hrOrgFieldValueSet);
                }
                try {
                    dataPermissionModel.setDefaultManage(rowSet.getBoolean(isDefaultManageField));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                list.add(dataPermissionModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private Set<String> getFieldValueSet(Set<String> fieldSet, IRowSet rowSet) throws SQLException {
        HashSet<String> fieldValueSet = new HashSet<String>();
        for (String field : fieldSet) {
            fieldValueSet.add(rowSet.getString(field));
        }
        return fieldValueSet;
    }
}

