/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ExpFilterConfigInfo;
import com.kingdee.shr.base.permission.ExpTypeEnum;
import com.kingdee.shr.base.syssetting.ConfigSolutionInfo;
import com.kingdee.shr.base.syssetting.FormDefaultValueSchemeInfo;
import com.kingdee.shr.base.syssetting.ListFilterSolutionFactory;
import com.kingdee.shr.base.syssetting.ListFilterSolutionInfo;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.base.syssetting.ListQuerySolutionInfo;
import com.kingdee.shr.base.syssetting.ListSetSolutionInfo;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo;
import com.kingdee.shr.base.syssetting.app.upgrade.DynamicListSchemeHelper;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.model.DataFetcherHelper;
import com.kingdee.shr.base.syssetting.sensitive.IShrSensitiveService;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceFactory;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.ParamUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class CommonListQuerySolutionUtil {
    private static Logger logger = Logger.getLogger(CommonListQuerySolutionUtil.class);
    private static final String FASTFILTERITEM_KEY = "fastFilterItem";
    private static final String ADVANCEFILTER_KEY = "advancedFilter";

    public static ListFilterSolutionInfo assembleListFilterSolutionInfo(Context ctx, String data) throws EASBizException {
        ListFilterSolutionInfo info = new ListFilterSolutionInfo();
        return (ListFilterSolutionInfo)CommonListQuerySolutionUtil.doAssembleInfo(ctx, data, (ConfigSolutionInfo)info);
    }

    public static FormDefaultValueSchemeInfo assembleFormDefaultSolutionInfo(Context ctx, String data) throws EASBizException {
        FormDefaultValueSchemeInfo info = new FormDefaultValueSchemeInfo();
        return (FormDefaultValueSchemeInfo)CommonListQuerySolutionUtil.doAssembleInfo(ctx, data, (ConfigSolutionInfo)info);
    }

    public static ListSetSolutionInfo assembleListSetSolutionInfo(Context ctx, String data) throws EASBizException {
        ListSetSolutionInfo info = new ListSetSolutionInfo();
        return (ListSetSolutionInfo)CommonListQuerySolutionUtil.doAssembleInfo(ctx, data, (ConfigSolutionInfo)info);
    }

    public static void checkAdministratorEditable(Context ctx, ListQuerySchemeTypeEnum type) throws EASBizException {
        UserInfo userInfo;
        if (ListQuerySchemeTypeEnum.SYSTEM.equals((Object)type) && null != (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) && !UserType.SYSTEM.equals((Object)userInfo.getType())) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonplateResourse", "sys_admin_modified")});
        }
    }

    public static void checkDataParamExist(Map param) throws EASBizException {
        String data = (String)param.get("data");
        if (StringUtils.isEmpty((String)data)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{"data param is miss"});
        }
    }

    public static void putDefaultTypeIfAbsent(ListQuerySolutionInfo info) {
        if (info.getType() == null) {
            info.setType(ListQuerySchemeTypeEnum.USER);
        }
    }

    public static SelectorItemCollection assembleSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("uiview.uipk"));
        return sic;
    }

    public static FilterInfo assembleDeleteSchemeFilter(Map param) {
        String id = (String)param.get("id");
        String[] ids = id.split(",");
        HashSet<String> set = new HashSet<String>();
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            set.add(ids[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        return filterInfo;
    }

    public static Map<String, Object> convertListSetSolutioninfoToMap(Context ctx, ListSetSolutionInfo info, boolean isQeury) throws EASBizException, BOSException {
        return CommonListQuerySolutionUtil.listFilterInfoToMap(ctx, (ListQuerySolutionInfo)info, isQeury, true);
    }

    public static Map<String, Object> convertListFilterSolutioninfoToMap(Context ctx, ListFilterSolutionInfo info, boolean isQeury) throws EASBizException, BOSException {
        return CommonListQuerySolutionUtil.listFilterInfoToMap(ctx, (ListQuerySolutionInfo)info, isQeury, true);
    }

    public static Map<String, Object> listFilterInfoToMap(Context ctx, ListQuerySolutionInfo info, boolean isQeury, boolean isNeedTrans) throws EASBizException {
        String uipk = info.getUiview().getUipk();
        Map<String, Object> map = CommonListQuerySolutionUtil.assebembleInfoToMap((ConfigSolutionInfo)info, ctx);
        String config = info.getConfig();
        if (!StringUtils.isEmpty((String)config) && !"{}".equals(config)) {
            try {
                if (isNeedTrans) {
                    HashMap configMap = JSONUtils.convertJsonToObject(ctx, info.getConfig());
                    CommonListQuerySolutionUtil.fixedListFilterSchemeDataStruct(ctx, configMap, info);
                    if (isQeury) {
                        CommonListQuerySolutionUtil.listFilterInfoToMapMultiLan(ctx, (Map<String, Object>)configMap, info);
                    }
                    map.put("config", CommonListQuerySolutionUtil.warpConfigMap(ctx, configMap, uipk));
                } else {
                    map.put("config", null);
                }
            }
            catch (SHRWebException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return map;
    }

    private static IQueryExecutor getQueryExecutor(Context ctx, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewinfo, String[] values, String query) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)query));
        exec.setObjectView(CommonListQuerySolutionUtil.getEntityViewInfo(uiviewinfo, values, true));
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    private static EntityViewInfo getEntityViewInfo(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewinfo, String[] values, boolean isQuery) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        int total = uiviewinfo.getFields().size();
        for (int i = 0; i < total; ++i) {
            FieldInfo f = uiviewinfo.getFields().get(i);
            if (f != null && null != f.getProperty()) {
                if (f.getProperty() instanceof OwnPropertyInfo) {
                    selector.add(new SelectorItemInfo(f.getName()));
                    continue;
                }
                if (isQuery) {
                    selector.add(new SelectorItemInfo(f.getName()));
                    continue;
                }
                LinkPropertyInfo p = (LinkPropertyInfo)f.getProperty();
                EntityObjectInfo so = p.getRelationship().getSupplierObject();
                selector.add(new SelectorItemInfo(f.getName() + ".id"));
                if (null != so.getPropertyByNameRuntime("name")) {
                    selector.add(new SelectorItemInfo(f.getName() + ".name"));
                }
                if (null == so.getPropertyByNameRuntime("number")) continue;
                selector.add(new SelectorItemInfo(f.getName() + ".number"));
                continue;
            }
            if (null == f) continue;
            selector.add(new SelectorItemInfo(f.getName()));
        }
        entityViewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)DataValueTranslatorUtil.stringArray2String((String[])values), CompareType.INNER));
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private static List<Map<String, Object>> getDatas(Context ctx, String uipk, String values, Object dataItem) throws SHRWebException, BOSException {
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        ArrayList<Map<String, Object>> datas = null;
        String[] valuesTemp = values.split(",");
        try {
            for (String id : valuesTemp) {
                BOSUuid.read((String)id);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((String)uiviewinfo.getQuery())) {
            return DataFetcherHelper.getByEntityAllDataFetcher(ctx, CommonListQuerySolutionUtil.getEntityViewInfo(uiviewinfo, valuesTemp, false), uiviewinfo.getModel(), 0, valuesTemp.length);
        }
        datas = new ArrayList<Map<String, Object>>();
        IQueryExecutor queryExecutor = null;
        for (String id : valuesTemp) {
            queryExecutor = CommonListQuerySolutionUtil.getQueryExecutor(ctx, uiviewinfo, new String[]{id}, uiviewinfo.getQuery());
            CommonListQuerySolutionUtil.addFilterToQueryExecutor(ctx, queryExecutor, uiviewinfo, id, dataItem);
            List<Map<String, Object>> l = DataFetcherHelper.getByQueryAllDataFetcher(ctx, queryExecutor, 0, 1);
            if (l.size() <= 0) continue;
            datas.addAll(l);
        }
        return datas;
    }

    private static void addFilterToQueryExecutor(Context ctx, IQueryExecutor queryExecutor, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewinfo, String id, Object dataItem) {
        Map data0 = null;
        if (dataItem instanceof List) {
            List dataItems = (List)dataItem;
            int total = dataItems.size();
            for (int i = 0; i < total; ++i) {
                Map d = (Map)dataItems.get(i);
                if (!id.equals((String)d.get("id"))) continue;
                data0 = d;
                break;
            }
        } else if (dataItem instanceof Map) {
            data0 = (Map)dataItem;
        } else {
            return;
        }
        if (null == data0) {
            return;
        }
        FilterInfo filter = queryExecutor.getObjectView().getFilter();
        List<FieldInfo> lfs = uiviewinfo.getFields();
        for (FieldInfo fi : lfs) {
            Object value;
            if ("id".equals(fi.getName()) || !"hidden".equals(fi.getType()) || null == (value = data0.get(fi.getName()))) continue;
            filter.getFilterItems().add(new FilterItemInfo(fi.getName(), value));
        }
    }

    private static void listFilterInfoToMapMultiLan(Context ctx, Map<String, Object> configMap, ListQuerySolutionInfo info) throws SHRWebException {
        CommonListQuerySolutionUtil.listFilterInfoToMapMultiLan(ctx, configMap, info.getUiview());
    }

    private static void listFilterInfoToMapMultiLan(Context ctx, Map<String, Object> configMap, UIViewInfo uiview) throws SHRWebException {
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewinfo;
        Map advancedFilter;
        Map fastFilter = (Map)configMap.get(FASTFILTERITEM_KEY);
        if (null != fastFilter) {
            Set key = fastFilter.keySet();
            try {
                Iterator iterator = key.iterator();
                while (iterator.hasNext()) {
                    Object dataItem;
                    List<Map<String, Object>> datas;
                    Map each = (Map)fastFilter.get(iterator.next());
                    if (!"F7".equalsIgnoreCase((String)each.get("dataType"))) continue;
                    String uipk = (String)each.get("uipk");
                    String values = (String)each.get("values");
                    if (StringUtils.isEmpty((String)values) || null == (datas = CommonListQuerySolutionUtil.getDatas(ctx, uipk, values, dataItem = each.get("dataItem"))) || datas.size() <= 0) continue;
                    each.put("dataItem", datas);
                }
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
        }
        if (null == (advancedFilter = (Map)configMap.get(ADVANCEFILTER_KEY))) {
            return;
        }
        Map filterItemMaping = (Map)advancedFilter.get("filterItemMaping");
        if (null == filterItemMaping) {
            return;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewinfoSearch = uiviewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uiview.getUipk());
        if (!StringUtils.isEmpty((String)uiviewinfo.getSearchView())) {
            uiviewinfoSearch = UIViewUtil.getUIViewInfoByUIPK(ctx, uiviewinfo.getSearchView());
        }
        Set keyCondtion = filterItemMaping.keySet();
        Map eachCondtion = null;
        Map condition_key = null;
        String name = null;
        String type = null;
        QueryConfigFieldInfo queryConfigFieldInfo = null;
        QueryFieldInfo queryFieldInfo = null;
        Map<String, QueryFieldInfo> otherSchemeInfo = null;
        if ("dynamicList" == uiview.getType().getValue()) {
            otherSchemeInfo = CommonListQuerySolutionUtil.getAtsAndCmpItemInfos(ctx, filterItemMaping, uiview);
        }
        try {
            Iterator iterator = keyCondtion.iterator();
            while (iterator.hasNext()) {
                eachCondtion = null;
                condition_key = null;
                name = null;
                type = null;
                queryConfigFieldInfo = null;
                queryFieldInfo = null;
                eachCondtion = (Map)filterItemMaping.get(iterator.next());
                name = (String)eachCondtion.get("name");
                type = (String)eachCondtion.get("type");
                condition_key = (Map)eachCondtion.get("condition_key");
                if ("dynamicList" == uiview.getType().getValue()) {
                    if (CommonListQuerySolutionUtil.isAtsOrCmpProject(name)) {
                        if (null == otherSchemeInfo || null == (queryFieldInfo = otherSchemeInfo.get(name.split("\\.")[1]))) continue;
                        if (null != condition_key) {
                            condition_key.put("name", queryFieldInfo.getNameMultiLan().get(ctx.getLocale().getDisplayName()));
                            continue;
                        }
                        eachCondtion.put("nameAlias", queryFieldInfo.getNameMultiLan().get(ctx.getLocale().getDisplayName()));
                        continue;
                    }
                    String queryConfigFieldId = (String)condition_key.get("id");
                    queryConfigFieldInfo = StringUtils.isEmpty((String)queryConfigFieldId) ? StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)uiview.getModel(), (String)name) : StructureConfigConvertHelper.getQueryFieldById((Context)ctx, (String)uiview.getModel(), (String)queryConfigFieldId);
                    if (null != queryConfigFieldInfo) {
                        if (null != condition_key) {
                            String conditionKeyName = (String)condition_key.get("name");
                            if (conditionKeyName.indexOf(".") != -1) {
                                condition_key.put("name", MessageFormat.format("{0}.{1}", queryConfigFieldInfo.getParent().getName(ctx.getLocale()), queryConfigFieldInfo.getAlias(ctx.getLocale())));
                            } else {
                                condition_key.put("name", queryConfigFieldInfo.getAlias(ctx.getLocale()));
                            }
                        } else {
                            eachCondtion.put("nameAlias", queryConfigFieldInfo.getAlias(ctx.getLocale()));
                        }
                    }
                    if (null != queryConfigFieldInfo && !StringUtils.isEmpty((String)queryConfigFieldInfo.getUipk())) {
                        type = "link";
                    }
                    if (null == queryConfigFieldInfo) continue;
                    CommonListQuerySolutionUtil.advancefilterConvert(ctx, type, queryConfigFieldInfo.getUipk(), eachCondtion, condition_key);
                    continue;
                }
                if (null != uiviewinfoSearch && null != uiviewinfoSearch.getField(name)) {
                    FieldInfo f = uiviewinfoSearch.getField(name);
                    String alias = f.getAlias();
                    if (null == f.getProperty() && f.getName().equals(f.getAlias()) && null != (f = uiviewinfo.getField(name))) {
                        alias = f.getAlias();
                    }
                    if (null != condition_key) {
                        condition_key.put("name", alias);
                    } else {
                        eachCondtion.put("nameAlias", alias);
                    }
                }
                if (null == condition_key) continue;
                if (!StringUtils.isEmpty((String)((String)condition_key.get("uipk"))) && !"null".equalsIgnoreCase((String)condition_key.get("uipk"))) {
                    type = "link";
                }
                CommonListQuerySolutionUtil.advancefilterConvert(ctx, type, (String)condition_key.get("uipk"), eachCondtion, condition_key);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    private static Map<String, QueryFieldInfo> getAtsAndCmpItemInfos(Context ctx, Map filterItemMaping, UIViewInfo uiview) {
        HashSet<String> items = new HashSet<String>();
        Set keyCondtion = filterItemMaping.keySet();
        Map eachCondtion = null;
        Map otherSchemeInfo = null;
        String name = null;
        Iterator iterator = keyCondtion.iterator();
        while (iterator.hasNext()) {
            eachCondtion = null;
            name = null;
            eachCondtion = (Map)filterItemMaping.get(iterator.next());
            name = (String)eachCondtion.get("name");
            if (!CommonListQuerySolutionUtil.isAtsOrCmpProject(name)) continue;
            items.add(name.split("\\.")[1]);
        }
        try {
            String osfName = CommonListQuerySolutionUtil.getOSFName(uiview.getModel());
            if (items.size() > 0) {
                otherSchemeInfo = (Map)OSFExecutor.executeOSF((Context)ctx, (Map)CommonListQuerySolutionUtil.getParams(items), (String)osfName);
            }
        }
        catch (Exception e) {
            otherSchemeInfo = null;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return otherSchemeInfo;
    }

    private static Map getParams(Set<String> items) {
        HashMap<String, String> param = new HashMap<String, String>();
        StringBuffer s = new StringBuffer();
        if (items.size() < 1) {
            return param;
        }
        for (String ss : items) {
            s.append(",").append(ss);
        }
        param.put("items", s.substring(1));
        return param;
    }

    private static String getOSFName(String schemeNumber) {
        if (CommonListQuerySolutionUtil.isCmpScheme(schemeNumber)) {
            return "getMulCmpItem";
        }
        if (CommonListQuerySolutionUtil.isAtsScheme(schemeNumber)) {
            return "getMulAtsItem";
        }
        return null;
    }

    private static boolean isAtsScheme(String schemeNumber) {
        return "010ATS".equals(schemeNumber) || "011ATS".equals(schemeNumber) || "012ATS".equals(schemeNumber);
    }

    private static boolean isCmpScheme(String schemeNumber) {
        return "002".equals(schemeNumber);
    }

    private static void advancefilterConvert(Context ctx, String type, String uipk, Map eachCondtion, Map condition_key) throws SHRWebException, BOSException {
        if ("link".equals(type)) {
            StringBuffer values = new StringBuffer();
            if (null == eachCondtion.get("value")) {
                return;
            }
            boolean isList = false;
            if (eachCondtion.get("value") instanceof List) {
                List vs = (List)eachCondtion.get("value");
                int total = vs.size();
                if (total <= 0) {
                    return;
                }
                for (int i = 0; i < total; ++i) {
                    if (i > 0) {
                        values.append(",");
                    }
                    values.append((String)((Map)vs.get(i)).get("id"));
                }
                isList = true;
            } else if (eachCondtion.get("value") instanceof Map) {
                Map value = (Map)eachCondtion.get("value");
                values.append((String)value.get("id"));
            } else {
                return;
            }
            List<Map<String, Object>> datas = CommonListQuerySolutionUtil.getDatas(ctx, uipk, values.toString(), eachCondtion.get("value"));
            if (null != datas && datas.size() > 0) {
                if (isList) {
                    eachCondtion.put("value", datas);
                } else {
                    eachCondtion.put("value", datas.get(0));
                }
            }
        } else if (SHREnumUtil.isEnum((String)type)) {
            if (null != condition_key) {
                String enumSource = (String)condition_key.get("enumSource");
                String value = (String)eachCondtion.get("value");
                if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)enumSource)) {
                    return;
                }
                Enum objEnum = (Enum)com.kingdee.shr.base.syssetting.app.util.MetaDataUtil.findEnumByValue((String)enumSource, (Object)value);
                if (null != objEnum) {
                    String alias = objEnum.getAlias(ctx.getLocale());
                    if (StringUtils.isEmpty((String)alias)) {
                        alias = objEnum.getAlias();
                    }
                    eachCondtion.put("nameAlias", alias);
                }
            }
        } else if ("String".equals(type) && eachCondtion.get("valueMultiLang") instanceof Map) {
            Map valueMultiLang = (Map)eachCondtion.get("valueMultiLang");
            eachCondtion.put("value", valueMultiLang.get(ctx.getLocale().toString()));
        }
    }

    public static void fixedListFilterSchemeDataStruct(Context ctx, Map<String, Object> configMap, ListQuerySolutionInfo info) throws SHRWebException {
        Map fastFilterItemValue;
        if (null == configMap) {
            return;
        }
        Map advanceFilter = (Map)configMap.get(ADVANCEFILTER_KEY);
        boolean isEncryptMode = ParamUtil.IsEnableEncrypt((Context)ctx);
        if (isEncryptMode && null != advanceFilter) {
            Map filterItemMaping = (Map)advanceFilter.get("filterItemMaping");
            boolean isEncryptField = false;
            com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, info.getUiview().getUipk());
            if (null != viewinfo) {
                Map tMap;
                int i = 1;
                while (null != (tMap = (Map)filterItemMaping.get("t" + Integer.toString(i)))) {
                    tMap = (Map)filterItemMaping.get("t" + Integer.toString(i));
                    Map conditionKeyMap = (Map)tMap.get("condition_key");
                    if (null != conditionKeyMap.get("field")) {
                        isEncryptField = UIViewUtil.isEncryptField(ctx, viewinfo, conditionKeyMap.get("field").toString());
                    } else if (null != tMap.get("name")) {
                        isEncryptField = UIViewUtil.isEncryptField(ctx, viewinfo, conditionKeyMap.get("name").toString());
                    }
                    conditionKeyMap.put("isEncryptField", isEncryptField);
                    tMap.put("condition_key", conditionKeyMap);
                    filterItemMaping.put("t" + Integer.toString(i), tMap);
                    tMap = null;
                    isEncryptField = false;
                    ++i;
                }
            }
            advanceFilter.put("filterItemMaping", filterItemMaping);
            configMap.put(ADVANCEFILTER_KEY, advanceFilter);
        }
        if (null == (fastFilterItemValue = (Map)configMap.get(FASTFILTERITEM_KEY))) {
            return;
        }
        Object advancedFilter = fastFilterItemValue.get(ADVANCEFILTER_KEY);
        if (null != advancedFilter) {
            logger.error((Object)("[ configMap format error, schemeName is : ]" + info.getName()));
            logger.error((Object)SHRCheck.vaildLog((String)("[ configMap format  is : ]" + configMap.toString())));
            fastFilterItemValue.remove(ADVANCEFILTER_KEY);
            configMap.put(ADVANCEFILTER_KEY, advancedFilter);
        }
        if (null != advanceFilter && null != advanceFilter.get("condition") && StringUtils.isEmpty((String)advanceFilter.get("condition").toString())) {
            configMap.put(ADVANCEFILTER_KEY, null);
        }
        CommonListQuerySolutionUtil.fixedDynamicAdvanceSchemeDataStruct(ctx, info, configMap);
    }

    private static void fixedDynamicAdvanceSchemeDataStruct(Context ctx, ListQuerySolutionInfo info, Map<String, Object> configMap) throws SHRWebException {
        Object advancefilterMap = configMap.get(ADVANCEFILTER_KEY);
        if (advancefilterMap instanceof Map) {
            Map advancefilterMap0 = (Map)advancefilterMap;
            Map filterItemMaping = (Map)advancefilterMap0.get("filterItemMaping");
            if (null == filterItemMaping) {
                return;
            }
            Set key = filterItemMaping.keySet();
            for (String tn : key) {
                Map tnValue = (Map)filterItemMaping.get(tn);
                String name = (String)tnValue.get("name");
                String type = (String)tnValue.get("type");
                Map condition_key = (Map)tnValue.get("condition_key");
                if (condition_key != null || !"intEnum".equalsIgnoreCase(type) && !"StringEnum".equalsIgnoreCase(type) && !"Enum".equalsIgnoreCase(type)) continue;
                UIViewInfo uiview = info.getUiview();
                String model = uiview.getModel();
                if ("dynamicList" == uiview.getType().getValue()) {
                    QueryConfigFieldInfo queryConfigFieldInfo = DynamicListSchemeHelper.getQueryConfigFieldInfo((Context)ctx, (String)model, (String)name);
                    if (null == queryConfigFieldInfo) continue;
                    String id = queryConfigFieldInfo.getId().toString();
                    StructureConfigColumnsInfo info1 = queryConfigFieldInfo.getFactField();
                    String dataType = info1.getDataType();
                    String enumSource = info1.getEnumSource();
                    tnValue.put("condition_key", CommonListQuerySolutionUtil.assembleConditionKeyMap(id, null, enumSource, dataType, queryConfigFieldInfo.getAlias(), queryConfigFieldInfo.getFactField().getNumber()));
                    continue;
                }
                if ("list" != uiview.getType().getValue()) continue;
                try {
                    com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uiview.getUipk());
                    if (!StringUtils.isEmpty((String)viewinfo.getQuery())) {
                        String entityName = MetaDataUtil.getEntityNameByQueryField(viewinfo.getQuery(), name);
                        if (StringUtils.isEmpty((String)entityName)) continue;
                        BizEnumInfo bizEnumInfo = MetaDataUtil.getBizEnumInfo(entityName, name);
                        String enumClassName = bizEnumInfo.getClassName();
                        FieldInfo fieldInfo = viewinfo.getField(name);
                        tnValue.put("condition_key", CommonListQuerySolutionUtil.assembleConditionKeyMap("", null, enumClassName, type, fieldInfo.getAlias(), name));
                        continue;
                    }
                    if (StringUtils.isEmpty((String)viewinfo.getModel())) continue;
                    BizEnumInfo bizEnumInfo = MetaDataUtil.getBizEnumInfo(viewinfo.getModel(), name);
                    String enumClassName = bizEnumInfo.getClassName();
                    FieldInfo fieldInfo = viewinfo.getField(name);
                    tnValue.put("condition_key", CommonListQuerySolutionUtil.assembleConditionKeyMap("", null, enumClassName, type, fieldInfo.getAlias(), name));
                }
                catch (SHRWebException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static Map<String, Object> assembleConditionKeyMap(String id, String uipk, String enumSource, String type, String alias, String field) {
        HashMap<String, Object> conditionKeyMap = new HashMap<String, Object>();
        conditionKeyMap.put("id", "");
        conditionKeyMap.put("uipk", uipk);
        conditionKeyMap.put("enumSource", enumSource);
        conditionKeyMap.put("type", type);
        conditionKeyMap.put("name", alias);
        conditionKeyMap.put("field", field);
        return conditionKeyMap;
    }

    public static Map<String, Object> listSetInfoToMap(ListQuerySolutionInfo info, Context ctx, boolean isQeury) throws EASBizException, BOSException {
        Map<String, Object> map = CommonListQuerySolutionUtil.assebembleInfoToMap((ConfigSolutionInfo)info, ctx);
        String config = info.getConfig();
        if (!StringUtils.isEmpty((String)config)) {
            try {
                boolean isEncrypt;
                HashMap configMap = JSONUtils.convertJsonToObject(ctx, info.getConfig());
                if (isQeury) {
                    CommonListQuerySolutionUtil.listSetInfoToMapMultiLan(ctx, configMap, info);
                }
                if (isEncrypt = true) {
                    CommonListQuerySolutionUtil.processEncryptField(ctx, configMap, info);
                }
                map.put("config", configMap);
            }
            catch (SHRWebException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return map;
    }

    private static void processEncryptField(Context ctx, Map<?, ?> configMap, ListQuerySolutionInfo info) throws SHRWebException {
        List columns = (List)configMap.get("columns");
        String uipk = info.getUiview().getUipk();
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfoByUIPK = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        if (columns.size() > 0) {
            for (int i = 0; i < columns.size(); ++i) {
                Map fieldMap = (Map)columns.get(i);
                String name = (String)fieldMap.get("name");
                boolean encryptField = UIViewUtil.isEncryptField(ctx, uiViewInfoByUIPK, name);
                if (encryptField) {
                    fieldMap.put("isEncryptField", encryptField);
                    continue;
                }
                fieldMap.put("isEncryptField", false);
            }
        }
    }

    public static Map<String, Object> listSetInfoToMap(ListQuerySolutionInfo info, Context ctx, boolean isQeury, QueryConfigCollection qcc) throws EASBizException, BOSException {
        Map<String, Object> map = CommonListQuerySolutionUtil.assebembleInfoToMap((ConfigSolutionInfo)info, ctx);
        String config = info.getConfig();
        if (!StringUtils.isEmpty((String)config)) {
            try {
                boolean isEnableEncrypt;
                HashMap configMap = JSONUtils.convertJsonToObject(ctx, info.getConfig());
                if (isQeury) {
                    CommonListQuerySolutionUtil.listSetInfoToMapMultiLan(ctx, configMap, info, qcc);
                }
                if (isEnableEncrypt = ParamUtil.IsEnableEncrypt((Context)ctx)) {
                    CommonListQuerySolutionUtil.processEncryptField(ctx, configMap, info);
                }
                map.put("config", configMap);
            }
            catch (SHRWebException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return map;
    }

    private static boolean isAtsOrCmpProject(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return false;
        }
        if (fieldName.toUpperCase().matches("CMP_CTB.S\\d+")) {
            return true;
        }
        return fieldName.toUpperCase().matches("ATS_RESULT.S\\d+");
    }

    private static void setSensitiveInfo(Context ctx, Map<String, Object> extendOptions, QueryConfigFieldInfo qcf) throws SHRWebException {
        Map<String, Object> sensitiveRule = (Map<String, Object>)extendOptions.get("sensitiveRule");
        if (null != sensitiveRule) {
            return;
        }
        IShrSensitiveService iShrSensitiveService = ShrSensitiveServiceFactory.getInstance().getIShrSensitiveService();
        sensitiveRule = iShrSensitiveService.getFieldSensitiveForEntity(ctx, qcf.getFactField().getStructureConfig().getEntityName(), qcf.getFactField().getNumber(), null);
        if (null != sensitiveRule) {
            extendOptions.put("sensitiveRule", sensitiveRule);
        }
    }

    private static void listSetInfoToMapMultiLan(Context ctx, Map<?, ?> configMap, ListQuerySolutionInfo info) throws BOSException, EASBizException {
        String schema = info.getUiview().getModel();
        List columns = (List)configMap.get("columns");
        String type = null;
        String combineName = null;
        String extendOptions0 = null;
        HashMap extendOptions = null;
        QueryConfigFieldInfo qcf = null;
        PropertyInfo propertyInfo = null;
        try {
            long beginTime = System.currentTimeMillis();
            long endTime = System.currentTimeMillis();
            for (Map each : columns) {
                type = (String)each.get("type");
                combineName = (String)each.get("name");
                extendOptions0 = null;
                extendOptions = null;
                qcf = null;
                extendOptions = new HashMap();
                beginTime = System.currentTimeMillis();
                if (!CommonListQuerySolutionUtil.isAtsOrCmpProject(combineName)) {
                    qcf = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)schema, (String)combineName);
                }
                endTime = System.currentTimeMillis();
                logger.info((Object)SHRCheck.vaildLog((String)MessageFormat.format("listSetInfoToMapMultiLan schema:{0}, combineName:{1}, cost : {2} ms,{3} s", schema, combineName, endTime - beginTime, Float.valueOf((float)(endTime - beginTime) / 1000.0f))));
                if (null != qcf) {
                    extendOptions0 = qcf.getFactField().getExtendOptions();
                }
                if (!StringUtils.isEmpty(extendOptions0)) {
                    extendOptions = JSONUtils.convertJsonToObject(ctx, extendOptions0);
                }
                if (null != qcf) {
                    CommonListQuerySolutionUtil.setSensitiveInfo(ctx, extendOptions, qcf);
                }
                if (DataType.TIME.getName().equals(type) || DataType.DATE.getName().equals(type) || DataType.TIMESTAMP.getName().equals(type)) {
                    if (null != qcf) {
                        propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)qcf.getFactField().getStructureConfig().getEntityName(), (String)qcf.getFactField().getNumber());
                    }
                    UserNantionalUtil.dateExtendOptionsSetting((Context)ctx, (Map)extendOptions, (boolean)true, (DataType)DataType.getEnum((String)type), propertyInfo);
                }
                if (DataType.DOUBLE.getName().equals(type) || DataType.DECIMAL.getName().equals(type) || DataType.FLOAT.getName().equals(type)) {
                    UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, (Map)extendOptions, (boolean)true);
                }
                if (DataType.LONG.getName().equals(type) || DataType.INTEGER.getName().equals(type)) {
                    UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, (Map)extendOptions, (boolean)true);
                    Map numberOptions = (Map)extendOptions.get("numberOptions");
                    numberOptions.put("decimalPrecision", 0);
                }
                each.put("extendOptions", extendOptions);
            }
        }
        catch (SHRWebException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static void listSetInfoToMapMultiLan(Context ctx, Map<?, ?> configMap, ListQuerySolutionInfo info, QueryConfigCollection qcc) throws BOSException, EASBizException {
        String schema = info.getUiview().getModel();
        List columns = (List)configMap.get("columns");
        String type = null;
        String combineName = null;
        String extendOptions0 = null;
        HashMap extendOptions = null;
        QueryConfigFieldInfo qcf = null;
        PropertyInfo propertyInfo = null;
        try {
            long beginTime = System.currentTimeMillis();
            long endTime = System.currentTimeMillis();
            for (Map each : columns) {
                type = (String)each.get("type");
                combineName = (String)each.get("name");
                extendOptions0 = null;
                extendOptions = null;
                qcf = null;
                extendOptions = new HashMap();
                beginTime = System.currentTimeMillis();
                if (!CommonListQuerySolutionUtil.isAtsOrCmpProject(combineName)) {
                    qcf = StructureConfigConvertHelper.getQueryConfigFieldInfo((QueryConfigCollection)qcc, (String)combineName);
                }
                endTime = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("listSetInfoToMapMultiLan schema:{0}, combineName:{1}, cost : {2} ms,{3} s", schema, combineName, endTime - beginTime, Float.valueOf((float)(endTime - beginTime) / 1000.0f)));
                }
                if (null != qcf) {
                    extendOptions0 = qcf.getFactField().getExtendOptions();
                }
                if (!StringUtils.isEmpty(extendOptions0)) {
                    extendOptions = JSONUtils.convertJsonToObject(ctx, extendOptions0);
                }
                if (null != qcf) {
                    CommonListQuerySolutionUtil.setSensitiveInfo(ctx, extendOptions, qcf);
                }
                if (DataType.TIME.getName().equals(type) || DataType.DATE.getName().equals(type) || DataType.TIMESTAMP.getName().equals(type)) {
                    if (null != qcf) {
                        propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)qcf.getFactField().getStructureConfig().getEntityName(), (String)qcf.getFactField().getNumber());
                    }
                    UserNantionalUtil.dateExtendOptionsSetting((Context)ctx, (Map)extendOptions, (boolean)true, (DataType)DataType.getEnum((String)type), propertyInfo);
                }
                if (DataType.DOUBLE.getName().equals(type) || DataType.DECIMAL.getName().equals(type) || DataType.FLOAT.getName().equals(type)) {
                    UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, (Map)extendOptions, (boolean)true);
                }
                if (DataType.LONG.getName().equals(type) || DataType.INTEGER.getName().equals(type)) {
                    UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, (Map)extendOptions, (boolean)true);
                    Map numberOptions = (Map)extendOptions.get("numberOptions");
                    numberOptions.put("decimalPrecision", 0);
                }
                each.put("extendOptions", extendOptions);
            }
        }
        catch (SHRWebException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static Map<String, Object> assebembleInfoToMap(ConfigSolutionInfo info, Context ctx) throws HRCommonException {
        if (info == null) {
            return null;
        }
        String uipk = info.getUiview().getUipk();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (info.getId() != null) {
            map.put("id", info.getId().toString());
        }
        boolean isDefault = info.isIsDefault();
        map.put("name", info.getName());
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().startsWith("{") && info.getName().endsWith("}")) {
            map.put("nameMultiLan", info.getName());
            map.put("name", info.getName(ctx.getLocale()));
        } else {
            map.put("nameMultiLan", MutilanUtils.setMultiFieldValue((String)"name", (IObjectValue)info));
        }
        map.put("isDefault", isDefault);
        map.put("isDynamicList", UIType.dynamicList.equals((Object)info.getUiview().getType()));
        map.put("isPublic", info.isIsPublic());
        map.put("type", info.getType().getValue());
        map.put("uipk", uipk);
        map.put("scheme", info.getUiview().getModel());
        map.put("category", info.getCategory());
        map.put("solutionId", info.getString("solutionId"));
        map.put("inner", info.isInner());
        return map;
    }

    public static Map<?, ?> warpConfigMap(Context ctx, Map<?, ?> configMap, String uipk) {
        Set<String> fastFilterItemSet = CommonListQuerySolutionUtil.assembleFasterItemMap(ctx, uipk);
        Map fastFilterItemMap = (Map)configMap.get(FASTFILTERITEM_KEY);
        if (null == fastFilterItemMap) {
            return configMap;
        }
        Iterator iterator = fastFilterItemMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (fastFilterItemSet.contains(key)) continue;
            iterator.remove();
        }
        return configMap;
    }

    private static Set<String> assembleFasterItemMap(Context ctx, String uipk) {
        HashSet<String> set = new HashSet<String>();
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo = null;
        try {
            viewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            Document doc = XMLUtil.parseXML(viewInfo.getContent());
            Element rootElement = doc.getRootElement();
            Element fastFilterElement = XMLUtil.getElement(rootElement, "fastFilter");
            if (null != fastFilterElement) {
                Attribute attr = fastFilterElement.getAttribute("visible");
                if (attr != null && "false".equalsIgnoreCase(attr.getValue())) {
                    return set;
                }
                List filterItem = fastFilterElement.getChildren();
                for (Object object : filterItem) {
                    if (!(object instanceof Element)) continue;
                    Element filterItemElement = (Element)object;
                    String filterItemNameValue = filterItemElement.getAttributeValue("name");
                    Attribute filterItemAttr = filterItemElement.getAttribute("visible");
                    if (filterItemAttr != null && "false".equalsIgnoreCase(filterItemAttr.getValue())) continue;
                    set.add(filterItemNameValue);
                }
            }
        }
        catch (SHRWebException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return set;
    }

    private static ConfigSolutionInfo doAssembleInfo(Context ctx, String data, ConfigSolutionInfo info) throws EASBizException {
        try {
            Map config;
            String category;
            String uipk;
            Number type;
            HashMap map = JSONUtils.convertJsonToObject(ctx, data);
            ListFilterSolutionInfo info0 = null;
            String id = (String)map.get("id");
            if (!StringUtils.isEmpty((String)id)) {
                info.setId(BOSUuid.read((String)id));
                try {
                    info0 = ListFilterSolutionFactory.getLocalInstance((Context)ctx).getListFilterSolutionInfo((IObjectPK)new ObjectUuidPK(id));
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (map.get("name") instanceof Map) {
                Map nameMap = (Map)map.get("name");
                for (String key : nameMap.keySet()) {
                    info.setName((String)nameMap.get(key), LocaleUtils.getLocale((String)key));
                }
            } else {
                List lml = BOSConfigUtil.getLanguageMapingList();
                Map lang = null;
                String name = (String)map.get("name");
                info.setName((String)map.get("name"));
                int total = lml.size();
                for (int i = 0; i < total; ++i) {
                    lang = (Map)lml.get(i);
                    info.setName(name, LocaleUtils.getLocale((String)((String)lang.get("lang"))));
                }
            }
            if (map.containsKey("isDefault")) {
                info.setIsDefault(((Boolean)map.get("isDefault")).booleanValue());
            }
            if (map.containsKey("isPublic")) {
                boolean pub = (Boolean)map.get("isPublic");
                info.setIsPublic(pub);
            }
            if (map.containsKey("type") && (type = (Number)map.get("type")) != null) {
                info.setType(ListQuerySchemeTypeEnum.getEnum((int)type.intValue()));
            }
            if (null != info0) {
                info.setType(info0.getType());
            }
            if (!StringUtils.isEmpty((String)(uipk = (String)map.get("uipk")))) {
                uipk = uipk.replace("$page", "");
                UIViewInfo uiViewInfo = UIViewUtil.getUIViewFromDB(ctx, uipk);
                info.setUiview(uiViewInfo);
            }
            if (!StringUtils.isEmpty((String)(category = (String)map.get("category")))) {
                info.setCategory(category);
            }
            if ((config = (Map)map.get("config")) != null) {
                CommonListQuerySolutionUtil.checkConfigDataStructure(config);
                info.setConfig(JSONUtils.convertObjectToJson(ctx, config));
            }
        }
        catch (SHRWebException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
        return info;
    }

    private static void checkConfigDataStructure(Map<?, ?> config) throws EASBizException {
        Map fastFilterItemMap;
        Set fastFilterItemMapKeySet;
        Object fastFilterItem = config.get(FASTFILTERITEM_KEY);
        if (null != fastFilterItem && fastFilterItem instanceof Map && null != (fastFilterItemMapKeySet = (fastFilterItemMap = (Map)fastFilterItem).keySet()) && fastFilterItemMapKeySet.contains(ADVANCEFILTER_KEY)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonplateResourse", "illegal_data_format")});
        }
    }

    public static EntityViewInfo getQuerySchemesEntityView(Context ctx, Map<String, Object> param) {
        String uipk = (String)param.get("uipk");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (!StringUtils.isEmpty((String)uipk)) {
            uipk = uipk.replace("$page", "");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.uipk", (Object)uipk));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("owner.id", (Object)userInfo.getId().toString()));
        String maskString = null;
        String category = (String)param.get("category");
        if (!StringUtils.isEmpty((String)category)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("category", (Object)category));
            maskString = "#0 and ((#1 and #2) or (#3 and #4))";
        } else {
            maskString = "#0 and ((#1 and #2) or #3)";
        }
        filterInfo.setMaskString(maskString);
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo defaultSortInfo = new SorterItemInfo("isDefault");
        defaultSortInfo.setSortType(SortType.DESCEND);
        sorters.add(defaultSortInfo);
        SorterItemInfo typeSoterInfo = new SorterItemInfo("type");
        typeSoterInfo.setSortType(SortType.DESCEND);
        sorters.add(typeSoterInfo);
        sorters.add(new SorterItemInfo("createTime"));
        viewInfo.setSorter(sorters);
        viewInfo.setSelector(CommonListQuerySolutionUtil.getSelectorItemCollection());
        return viewInfo;
    }

    public static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("isDefault"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("uiview.id"));
        sic.add(new SelectorItemInfo("uiview.uipk"));
        sic.add(new SelectorItemInfo("uiview.model"));
        sic.add(new SelectorItemInfo("uiview.type"));
        sic.add(new SelectorItemInfo("solutionId"));
        sic.add(new SelectorItemInfo("config"));
        sic.add(new SelectorItemInfo("category"));
        return sic;
    }

    public static void transExpFilter(Context ctx, ExpFilterConfigInfo model) throws SHRWebException {
        if (ExpTypeEnum.AdvanceFilterExp.equals((Object)model.getExpType()) && !StringUtils.isEmpty((String)model.getConfig()) && null != model.getUiview()) {
            HashMap configMap = JSONUtils.convertJsonToObject(ctx, model.getConfig());
            HashMap<String, Object> temp = new HashMap<String, Object>(1);
            temp.put(ADVANCEFILTER_KEY, configMap);
            CommonListQuerySolutionUtil.listFilterInfoToMapMultiLan(ctx, temp, model.getUiview());
            model.setConfig(JSONUtils.convertObjectToJson(ctx, temp.get(ADVANCEFILTER_KEY)));
        }
    }
}

