/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FileOperateUtil {
    private static Logger logger = Logger.getLogger(FileOperateUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure, boolean keepRoot) throws Exception {
        byte[] buf = new byte[10240];
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream in = null;){
                in = new FileInputStream(sourceFile);
                if (in != null) {
                    int len;
                    while ((len = in.read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                }
                zos.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure && keepRoot) {
                        FileOperateUtil.compress(file, zos, name + "/" + file.getName(), KeepDirStructure, true);
                        continue;
                    }
                    FileOperateUtil.compress(file, zos, file.getName(), KeepDirStructure, true);
                }
            }
        }
    }

    public static void compress(String sourceDir, String targetDir, String name, boolean KeepDirStructure) throws Exception {
        FileOutputStream out = null;
        ZipOutputStream zos = null;
        File sourceFile = new File(SHRCheck.checkFilePath((String)sourceDir));
        try {
            out = new FileOutputStream(new File(SHRCheck.checkFilePath((String)(targetDir + File.separatorChar + name + ".zip"))));
            zos = new ZipOutputStream(out);
            FileOperateUtil.compress(sourceFile, zos, sourceFile.getName(), KeepDirStructure, false);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                zos.close();
            }
            if (out != null) {
                out.close();
            }
            FileUtils.deleteDirectory((File)sourceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!dest.exists()) {
            dest.mkdir();
        }
        if (src.isDirectory()) {
            File[] files;
            File newFile = new File(dest, src.getName());
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                if (file.isFile()) {
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    try {
                        int len;
                        fis = new FileInputStream(file);
                        fos = new FileOutputStream(new File(newFile, file.getName()));
                        byte[] b = new byte[1024];
                        if (fis == null || fos == null) continue;
                        while ((len = fis.read(b)) != -1) {
                            fos.write(b, 0, len);
                        }
                        continue;
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {
                                logger.error((Object)"cleanup error", (Throwable)e);
                            }
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                logger.error((Object)"cleanup error", (Throwable)e);
                            }
                        }
                    }
                }
                if (!file.isDirectory()) continue;
                FileOperateUtil.copyFile(file, newFile);
            }
            return;
        }
        File dfile = new File(dest + File.separator + src.getName());
        if (!dfile.exists()) {
            dfile.createNewFile();
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dfile);
            byte[] b = new byte[1024];
            if (fis == null || fos == null) return;
            while ((len = fis.read(b)) != -1) {
                fos.write(b, 0, len);
            }
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
        }
    }

    public static void delFolder(String folderPath) {
        try {
            FileOperateUtil.delAllFile(folderPath);
            File myFilePath = new File(folderPath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            String tempFile = path + File.separatorChar + tempList[i];
            temp = path.endsWith("/") ? new File(path + tempList[i]) : new File(tempFile);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileOperateUtil.delAllFile(tempFile);
            FileOperateUtil.delFolder(tempFile);
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File bytesToFile(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            file = new File(filePath + fileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesByFile(File file) throws IOException {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        try {
            byte[] data;
            int n;
            fis = new FileInputStream(file);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            byte[] byArray = data = bos.toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            bos.close();
        }
    }

    public static void downloadSDK(String zipPath, File propFile, String targetConfigPath, HttpServletResponse response) throws SHRWebException {
        BufferedOutputStream bos = null;
        BufferedInputStream zipbis = null;
        FileInputStream downFis = null;
        ServletOutputStream outputStream = null;
        File jarFile = null;
        File down = null;
        try {
            File sourcezip = new File(zipPath + "shr_sso_client.zip");
            jarFile = new File(zipPath + "shr_sso_client.jar");
            if (!jarFile.exists()) {
                jarFile.createNewFile();
            }
            FileOperateUtil.prepareDownloadjar(sourcezip, jarFile, propFile, targetConfigPath);
            down = new File(zipPath + "temp.zip");
            if (!down.exists()) {
                down.createNewFile();
            }
            File requiredJars = new File(zipPath + "requiredLib.zip");
            File readmeDocx = new File(zipPath + "readme.docx");
            FileOperateUtil.packageZip(down, jarFile, requiredJars, readmeDocx);
            outputStream = response.getOutputStream();
            response.setContentType("application/x-download");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("s-HR-SDK.zip", "UTF-8"));
            bos = new BufferedOutputStream((OutputStream)outputStream);
            downFis = new FileInputStream(down);
            zipbis = new BufferedInputStream(downFis);
            FileOperateUtil.readAndWrite(zipbis, bos);
            bos.flush();
        }
        catch (IOException e) {
            try {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "download_fails"), e);
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeStream(new Closeable[]{zipbis, downFis, bos, outputStream});
                if (down != null) {
                    down.delete();
                }
                if (jarFile != null) {
                    jarFile.delete();
                }
                throw throwable;
            }
        }
        FileOperateUtil.closeStream(new Closeable[]{zipbis, downFis, bos, outputStream});
        if (down != null) {
            down.delete();
        }
        if (jarFile != null) {
            jarFile.delete();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void prepareDownloadjar(File sourcezip, File jarFile, File propFile, String configPath) throws SHRWebException {
        FileOutputStream jarFileFis = null;
        FileInputStream sourcezipFis = null;
        ZipOutputStream tempzos = null;
        ByteArrayOutputStream btos = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream btos1 = null;
        FileInputStream fis1 = null;
        BufferedInputStream bis1 = null;
        ZipInputStream zis = null;
        try {
            jarFileFis = new FileOutputStream(jarFile);
            tempzos = new ZipOutputStream(jarFileFis);
            sourcezipFis = new FileInputStream(sourcezip);
            zis = new ZipInputStream(sourcezipFis);
            ZipEntry zisEntry = null;
            while ((zisEntry = zis.getNextEntry()) != null) {
                ZipEntry zosEntry = new ZipEntry(zisEntry.getName());
                zosEntry.setComment(zisEntry.getComment());
                zosEntry.setExtra(zisEntry.getExtra());
                tempzos.putNextEntry(zosEntry);
                IOUtils.copy((InputStream)zis, (OutputStream)tempzos);
                tempzos.closeEntry();
            }
            ZipEntry ze = new ZipEntry(configPath);
            tempzos.putNextEntry(ze);
            btos = new ByteArrayOutputStream();
            fis = new FileInputStream(propFile);
            bis = new BufferedInputStream(fis);
            FileOperateUtil.readAndWrite(bis, btos);
            byte[] content = btos.toByteArray();
            tempzos.write(content, 0, content.length);
            if (!configPath.endsWith("LtpaToken.properties")) {
                File ltpaFile = new File(SHRSyssettingUtil.getLtpaTokenPath((String)"server1"));
                String ltpaTokenP = "com/kingdee/shr/sso/client/ltpa/LtpaToken.properties";
                ZipEntry ze1 = new ZipEntry(ltpaTokenP);
                tempzos.putNextEntry(ze1);
                btos1 = new ByteArrayOutputStream();
                fis1 = new FileInputStream(ltpaFile);
                bis1 = new BufferedInputStream(fis1);
                FileOperateUtil.readAndWrite(bis1, btos1);
                byte[] content1 = btos1.toByteArray();
                tempzos.write(content1, 0, content1.length);
            }
            tempzos.closeEntry();
        }
        catch (FileNotFoundException e) {
            try {
                throw new SHRWebException(e.getMessage(), e);
                catch (IOException e2) {
                    throw new SHRWebException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeStream(zis, sourcezipFis, bis, fis, btos, bis1, fis1, btos1, tempzos, jarFileFis);
                throw throwable;
            }
        }
        FileOperateUtil.closeStream(zis, sourcezipFis, bis, fis, btos, bis1, fis1, btos1, tempzos, jarFileFis);
    }

    private static void packageZip(File down, File jarFile, File requiredJars, File readmeDocx) throws ShrWebBizException {
        ZipOutputStream tempzos = null;
        FileOutputStream downFis = null;
        try {
            downFis = new FileOutputStream(down);
            tempzos = new ZipOutputStream(downFis);
            FileOperateUtil.packageZip(tempzos, "shr_sso_client.jar", jarFile);
            FileOperateUtil.packageZip(tempzos, "requiredLib.zip", requiredJars);
            FileOperateUtil.packageZip(tempzos, "readme.docx", readmeDocx);
            tempzos.closeEntry();
        }
        catch (IOException e) {
            try {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "zip_jar_fails"), e);
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeStream(tempzos, downFis);
                throw throwable;
            }
        }
        FileOperateUtil.closeStream(tempzos, downFis);
    }

    private static void packageZip(ZipOutputStream tempzos, String fileName, File file) throws ShrWebBizException {
        ZipEntry entry = new ZipEntry(fileName);
        try (ByteArrayOutputStream btos = new ByteArrayOutputStream();
             BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            tempzos.putNextEntry(entry);
            FileOperateUtil.readAndWrite(bis, btos);
            byte[] content = btos.toByteArray();
            tempzos.write(content, 0, content.length);
        }
        catch (FileNotFoundException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "target_jar_non_existent"), e);
        }
        catch (IOException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "zip_jar_fails"), e);
        }
    }

    public static void readAndWrite(InputStream input, OutputStream output) throws IOException {
        byte[] b = new byte[1024];
        int len = 0;
        while (-1 != (len = input.read(b, 0, 1024))) {
            output.write(b, 0, len);
        }
    }

    public static void closeStream(Closeable ... sList) {
        for (Closeable s : sList) {
            try {
                if (s == null) continue;
                s.close();
            }
            catch (IOException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyNewFileAndRename(String newPath, String oldPath, String newFileName) throws Exception {
        File result = new File(newPath + newFileName);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        FileInputStream input = new FileInputStream(oldPath);
        FileOutputStream out = new FileOutputStream(result);
        try {
            byte[] buffer = new byte[100];
            int hasRead = 0;
            while ((hasRead = input.read(buffer)) > 0) {
                out.write(buffer, 0, hasRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            input.close();
            out.close();
        }
    }

    public static void codeMove(String sourceVersion, String targetVersion, String path) {
        try {
            File f = new File(path);
            byte[] bytesByFile = FileOperateUtil.getBytesByFile(f);
            String fileFullNames = new String(bytesByFile);
            List<String> readLine = FileOperateUtil.readLine(fileFullNames);
            for (int i = 0; i < readLine.size(); ++i) {
                String p = readLine.get(i);
                File sourceFile = new File(sourceVersion + p);
                System.out.println("copy file :" + sourceVersion + p);
                File targetFile = new File(targetVersion + p);
                FileOperateUtil.copyFile(sourceFile, targetFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> readLine(String input) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }
}

