/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.permission.util.SHRPermissionParamUtil;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.WafUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.context.RenderContext;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class SHRPermissionWebUtils {
    private static Logger logger = Logger.getLogger(SHRPermissionWebUtils.class);
    private static final Map<String, String> REQUEST_SHR_UICODE_PERMISSION = new HashMap<String, String>();
    private static final Map<String, String> REFERER_UIPK_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> UIPK_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> REFERER_UIPK_METHOD_MAPPING = new HashMap<String, String>();

    public static Map<String, String> getReqeustShrUicodePermission() {
        return REQUEST_SHR_UICODE_PERMISSION;
    }

    public static boolean currentPageButtonHasFunctionPermission(Context ctx, RenderContext context, String componentName) {
        UIViewInfo uiViewInfo = (UIViewInfo)context.get("viewMeta");
        String uipk = uiViewInfo.getUipk();
        try {
            String currentRequestButtonPermItemUrl = SHRPermissionWebUtils.assembleCurrentRequestButtonPermItemUrl(uipk, componentName, null);
            PermItemInfo permItemInfo = SHRPermissionWebUtils.getPermisionInfoByUrl(ctx, currentRequestButtonPermItemUrl);
            if (null == permItemInfo) {
                return true;
            }
            return SHRPermissionWebUtils.hasFunctionPermission(ctx, permItemInfo);
        }
        catch (SHRWebException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasFunctionPermission(String uipk, String componentName) throws SHRWebException {
        return SHRPermissionWebUtils.hasFunctionPermission(SHRContext.getInstance().getContext(), uipk, componentName, null);
    }

    public static boolean hasFunctionPermission(Context ctx, String uipk, String componentName, String shruicode) throws SHRWebException {
        return SHRPermissionWebUtils.hasFunctionPermission(ctx, SHRPermissionWebUtils.assembleCurrentRequestButtonPermItemUrl(uipk, componentName, shruicode));
    }

    public static String assembleCurrentRequestButtonPermItemUrl(String uipk, String buttonName) {
        return SHRPermissionWebUtils.assembleCurrentRequestButtonPermItemUrl(uipk, buttonName, null);
    }

    public static String assembleCurrentRequestButtonPermItemUrl(String uipk, String buttonName, String shruicode) {
        String url = null;
        url = !StringUtils.isEmpty((String)shruicode) ? MessageFormat.format("/dynamic.do?method={0}#uri={1}&shruicode={2}", buttonName, uipk, shruicode) : MessageFormat.format("/dynamic.do?method={0}#uri={1}", buttonName, uipk);
        logger.info((Object)("[ SHRPermissionWebUtils.assembleCurrentRequestPermItemUrl url is " + url + " ]"));
        return url;
    }

    public static boolean hasFunctionPermission(String url) throws SHRWebException {
        return SHRPermissionWebUtils.hasFunctionPermission(SHRContext.getInstance().getContext(), url);
    }

    public static boolean hasFunctionPermission(Context ctx, String url) throws SHRWebException {
        PermItemInfo permItemInfo = SHRPermissionWebUtils.getPermisionInfoByUrl(ctx, url);
        return SHRPermissionWebUtils.hasFunctionPermission(ctx, permItemInfo);
    }

    public static boolean hasFunctionPermission(PermItemInfo permItemInfo) throws SHRWebException {
        return SHRPermissionWebUtils.hasFunctionPermission(SHRContext.getInstance().getContext(), permItemInfo);
    }

    public static boolean hasFunctionPermission(Context ctx, PermItemInfo permItemInfo) throws SHRWebException {
        if (permItemInfo != null && !StringUtils.isEmpty((String)permItemInfo.getName())) {
            try {
                String hrOrgId;
                String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
                Set bizOrgIdSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permItemInfo.getId().toString());
                boolean flag = false;
                Iterator iterator = bizOrgIdSet.iterator();
                while (iterator.hasNext() && !(flag = SHRPermissionWebUtils.hasFunctionPermission(ctx, hrOrgId = (String)iterator.next(), permItemInfo.getName()))) {
                }
                return flag;
            }
            catch (Exception e) {
                throw new SHRWebException(e.getMessage(), e);
            }
        }
        return true;
    }

    public static String getCurrentUserId() {
        return SHRPermissionWebUtils.getCurrentUserId(SHRContext.getInstance().getContext());
    }

    public static String getCurrentUserId(Context ctx) {
        return HRFilterUtils.getCurrentUserId((Context)ctx);
    }

    public static boolean hasFunctionPermission(Context ctx, String bizOrgId, String permItemName) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(bizOrgId), permItemName);
    }

    public static PermItemInfo getPermisionInfoByUrl(Context ctx, String url) throws SHRWebException {
        PermItemInfo permItemInfo = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)url);
        return permItemInfo;
    }

    public static OrgUnitInfo getOrgUnitInfoByPermItemInfo(Context ctx, PermItemInfo permItemInfo) {
        HROrgUnitInfo mainOrg = null;
        if (permItemInfo.getOrgRelation() != null && !permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            mainOrg = (OrgUnitInfo)ctx.get((Object)permItemInfo.getOrgRelation());
        }
        if (mainOrg == null) {
            mainOrg = ContextUtil.getCurrentHRUnit((Context)ctx);
        }
        return mainOrg;
    }

    public static String getCurrentRequestAdminOrgRangeSQL(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    public static Set<String> getCurrentRequestAdminOrgRangeIdSet(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    public static String getCurrentRequestHROrgRangeInSQL(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    public static String getCurrentRequestHROrgRangeInSQLWithBracket(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserHROrgRangeInSQLWithBracket((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    public static Set<String> getCurrentRequestHROrgRangeIdSet(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    public static String getCurrentRequestPermItemId(HttpServletRequest request) throws SHRWebException {
        Object _permItemId = request.getAttribute("permItemId");
        if (_permItemId != null) {
            return _permItemId.toString();
        }
        return null;
    }

    public static String getCurrentRequestPermItemIdByServiceID(HttpServletRequest request) throws SHRWebException {
        String serviceId = SHRPermissionWebUtils.getCurrentRequestServiceId(request);
        return SHRUserOrgPermissionApi.getPermItemIDByServiceID((String)serviceId);
    }

    public static String getCurrentRequestServiceId(HttpServletRequest request) {
        String serviceId = request.getParameter("serviceId");
        if (StringUtils.isEmpty((String)serviceId)) {
            String custom_params = request.getParameter("custom_params");
            try {
                HashMap custom_parms;
                if (!StringUtils.isEmpty((String)custom_params) && null != (custom_parms = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), custom_params)) && custom_parms.containsKey("serviceId")) {
                    serviceId = String.valueOf(custom_parms.get("serviceId"));
                }
            }
            catch (SHRWebException e) {
                e.printStackTrace();
            }
        }
        return serviceId;
    }

    public static String assemblePermissionURL(HttpServletRequest request) {
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        String method = WafUtils.getRequestAction(request);
        String module = request.getParameter("module");
        String shruicode = SHRPermissionWebUtils.getShrUiCode(request);
        return SHRPermissionWebUtils.doAssemblePermissionURL(request, SHRPermissionWebUtils.getServletPath(request), uipk, method, module, shruicode);
    }

    public static String getShrUiCode(HttpServletRequest request) {
        String custom_params;
        String shruicode = request.getParameter("shruicode");
        if (StringUtils.isEmpty((String)shruicode) && !StringUtils.isEmpty((String)(custom_params = request.getParameter("custom_params")))) {
            try {
                HashMap custom_paramsMap = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), custom_params);
                if (null != custom_paramsMap && !custom_paramsMap.isEmpty()) {
                    shruicode = (String)custom_paramsMap.get("shruicode");
                }
            }
            catch (SHRWebException e) {
                e.printStackTrace();
            }
        }
        return shruicode;
    }

    public static PermItemInfo getPermItemByReferer(Context ctx, String referer) {
        if (StringUtils.isEmpty((String)referer)) {
            return null;
        }
        String[] referers = referer.split("\\?");
        if (referers.length <= 1 || StringUtils.isEmpty((String)referers[1])) {
            return null;
        }
        String[] params = referers[1].split("&");
        String uipk = null;
        String shruicode = null;
        String module = null;
        String permItemId = null;
        String serviceId = null;
        String method = "initalize";
        for (String param : params) {
            if (StringUtils.isEmpty((String)param)) continue;
            String[] paramItems = param.split("=");
            if ("uipk".equals(paramItems[0]) && paramItems.length == 2) {
                uipk = SHRPermissionWebUtils.getRealUipk(paramItems[1]);
            }
            if ("module".equals(paramItems[0]) && paramItems.length == 2) {
                module = paramItems[1];
            }
            if ("shruicode".equals(paramItems[0]) && paramItems.length == 2 && SHRPermissionWebUtils.isValidateShruicode(paramItems[1])) {
                shruicode = paramItems[1];
            }
            if ("method".equals(paramItems[0]) && paramItems.length == 2 && !StringUtils.isEmpty((String)paramItems[1])) {
                method = paramItems[1];
            }
            if ("serviceId".equals(paramItems[0]) && paramItems.length == 2) {
                serviceId = paramItems[1];
            }
            if (!"permItemId".equals(paramItems[0]) || paramItems.length != 2) continue;
            permItemId = paramItems[1];
        }
        String url = SHRPermissionWebUtils.doAssemblePermissionURL(null, "/dynamic.do", uipk, method, module, shruicode);
        return SHRPermissionWebUtils.getCurrentPagePermItemByRequest0(ctx, url, "/dynamic.do", uipk, shruicode, module, permItemId, serviceId, false);
    }

    public static String doAssemblePermissionURL(String url, String uipk, String method, String module) {
        return SHRPermissionWebUtils.doAssemblePermissionURL(null, url, uipk, method, module, null);
    }

    public static String doAssemblePermissionURL(String url, String uipk, String method, String module, String shruicode) {
        return SHRPermissionWebUtils.doAssemblePermissionURL(null, url, uipk, method, module, shruicode);
    }

    public static String doAssemblePermissionURL(HttpServletRequest request, String url, String uipk, String method, String module, String shruicode) {
        StringBuffer permItemUrl = new StringBuffer(url);
        permItemUrl.append("?method=").append(method);
        if (!StringUtils.isEmpty((String)uipk)) {
            permItemUrl.append("#uri=").append(uipk);
        }
        if (!StringUtils.isEmpty((String)module)) {
            permItemUrl.append("&module=").append(module);
        }
        if (SHRPermissionWebUtils.isValidateShruicode(shruicode)) {
            permItemUrl.append("&shruicode=").append(shruicode);
            if (null != request) {
                request.setAttribute("shruicode", (Object)shruicode);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doAssemblePermissionURL shruicode = " + shruicode));
        }
        return permItemUrl.toString();
    }

    private static boolean isValidateShruicode(String shruicode) {
        if (!StringUtils.isEmpty((String)shruicode)) {
            StringBuffer s = new StringBuffer();
            String[] shruicode0 = shruicode.split("_");
            if (!StringUtils.isEmpty((String)shruicode0[0])) {
                s.append(shruicode0[0]).append("_");
            }
            if (shruicode0.length >= 2 && !StringUtils.isEmpty((String)shruicode0[1])) {
                s.append(shruicode0[1]).append("_");
            }
            if (shruicode0.length >= 3 && !StringUtils.isEmpty((String)shruicode0[2]) && shruicode0[2].length() <= 5) {
                if (REQUEST_SHR_UICODE_PERMISSION.containsKey(s.toString())) {
                    return true;
                }
                logger.info((Object)("doAssemblePermissionURL shruicode pre error, shruicode=" + SHRCheck.vaildLog((String)shruicode)));
            } else {
                logger.info((Object)("doAssemblePermissionURL shruicode function part length greater than 5, shruicode=" + SHRCheck.vaildLog((String)shruicode)));
            }
        }
        return false;
    }

    public static String getCurrentPagePermItemIdByRequest(HttpServletRequest request) {
        return SHRPermissionWebUtils.getCurrentPagePermItemIdByRequest(SHRContext.getInstance().getContext(), request);
    }

    public static String getCurrentPagePermItemIdByRequest(Context ctx, HttpServletRequest request) {
        String url = SHRPermissionWebUtils.assemblePermissionURL(request);
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        PermItemInfo permItemInfo = SHRPermissionWebUtils.getCurrentPagePermItemByRequest(ctx, request, url);
        if (null != permItemInfo) {
            return permItemInfo.getId().toString();
        }
        return null;
    }

    public static String getUipkByUrl(String url) {
        String uipk0;
        int endIndex;
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        int beginIndex = url.indexOf("uipk=");
        String uipk = null;
        if (beginIndex != -1 && (endIndex = (uipk = url.substring(beginIndex + 5)).indexOf("&")) != -1) {
            uipk = uipk.substring(0, endIndex);
        }
        if (!StringUtils.isEmpty((String)(uipk0 = SHRPermissionWebUtils.getRealUipk(uipk)))) {
            uipk0 = uipk0.replaceAll("\r|\n", "");
        }
        return uipk0;
    }

    public static String getRealUipk(String uipk) {
        if (StringUtils.isEmpty((String)uipk)) {
            return null;
        }
        if (uipk.indexOf("$") == -1) {
            return uipk;
        }
        return uipk.split("\\$")[0];
    }

    private static String getPermItemUrlBySpecLogic(HttpServletRequest request) {
        if ("POST".equals(request.getMethod())) {
            String key;
            String refererUipk = SHRPermissionWebUtils.getUipkByUrl(request.getHeader("Referer"));
            String method = request.getParameter("method");
            if (!StringUtils.isEmpty((String)refererUipk) && !StringUtils.isEmpty((String)method) && REFERER_UIPK_METHOD_MAPPING.containsKey(key = MessageFormat.format("{0}#{1}", refererUipk, method))) {
                return REFERER_UIPK_METHOD_MAPPING.get(key);
            }
            if (!StringUtils.isEmpty((String)refererUipk) && REFERER_UIPK_MAPPING.containsKey(refererUipk)) {
                return REFERER_UIPK_MAPPING.get(refererUipk);
            }
        }
        return null;
    }

    public static PermItemInfo getCurrentPagePermItemByRequest(Context ctx, HttpServletRequest request, String url) {
        return SHRPermissionWebUtils.getCurrentPagePermItemByRequest(ctx, request, url, false);
    }

    public static PermItemInfo getCurrentPagePermItemByRequest(Context ctx, HttpServletRequest request, String url, boolean isF7) {
        String url1 = SHRPermissionWebUtils.getPermItemUrlBySpecLogic(request);
        if (!StringUtils.isEmpty((String)url1)) {
            url = url1;
        }
        String uipk = request.getParameter("uipk");
        if (!StringUtils.isEmpty((String)(uipk = SHRPermissionWebUtils.getRealUipk(uipk))) && UIPK_MAPPING.containsKey(uipk)) {
            uipk = UIPK_MAPPING.get(uipk);
        }
        String serviceId = request.getParameter("serviceId");
        String permItemId = request.getParameter("permItemId");
        String module = request.getParameter("module");
        String shruicode = (String)request.getAttribute("shruicode");
        return SHRPermissionWebUtils.getCurrentPagePermItemByRequest0(ctx, url, SHRPermissionWebUtils.getServletPath(request), uipk, shruicode, module, permItemId, serviceId, isF7);
    }

    private static String getServletPath(HttpServletRequest request) {
        String path = request.getServletPath();
        if (!"/objectHistoryList.do".equals(path)) {
            path = "/dynamic.do";
        }
        return path;
    }

    private static PermItemInfo getCurrentPagePermItemByRequest0(Context ctx, String url, String servletPath, String uipk, String shruicode, String module, String permItemId, String serviceId, boolean isF7) {
        PermItemInfo currentRequestRealPermItemInfo = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)url);
        if (null != currentRequestRealPermItemInfo) {
            return currentRequestRealPermItemInfo;
        }
        currentRequestRealPermItemInfo = SHRPermissionWebUtils.getPermItemInfo(ctx, servletPath, uipk, "initalize", module, shruicode);
        if (null != currentRequestRealPermItemInfo) {
            return currentRequestRealPermItemInfo;
        }
        if (!StringUtils.isEmpty((String)shruicode)) {
            String url0 = url.substring(0, url.indexOf("&shruicode"));
            currentRequestRealPermItemInfo = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)url0);
            if (null != currentRequestRealPermItemInfo) {
                return currentRequestRealPermItemInfo;
            }
            currentRequestRealPermItemInfo = SHRPermissionWebUtils.getPermItemInfo(ctx, servletPath, uipk, "initalize", module, null);
            if (null != currentRequestRealPermItemInfo) {
                return currentRequestRealPermItemInfo;
            }
        }
        if (isF7 || !SHRPermissionParamUtil.isSHRPermissionVerificationWithWhiteList((Context)ctx)) {
            if (!StringUtils.isEmpty((String)permItemId) && null != (currentRequestRealPermItemInfo = SHRPermissionWebUtils.getPermItemInfoByPermItemId(ctx, permItemId))) {
                return currentRequestRealPermItemInfo;
            }
            if (!StringUtils.isEmpty((String)serviceId) && null != (currentRequestRealPermItemInfo = SHRUserOrgPermissionApi.getPermItemInfoByServiceID((Context)ctx, (String)serviceId))) {
                return currentRequestRealPermItemInfo;
            }
        }
        return null;
    }

    public static PermItemInfo getPermItemInfoByPermItemId(Context ctx, String permItemId) {
        if (!StringUtils.isEmpty((String)permItemId)) {
            try {
                BOSUuid.read((String)permItemId);
                return PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo((IObjectPK)new ObjectUuidPK(permItemId));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    public static String getCurrentPagePermItemId(String uipk, String method, String permItemId, String serviceId) {
        return SHRPermissionWebUtils.getCurrentPagePermItemId(SHRContext.getInstance().getContext(), uipk, method, permItemId, serviceId, null);
    }

    public static String getCurrentPagePermItemId(Context ctx, String uipk, String method, String permItemId, String serviceId, String shruicode) {
        return SHRPermissionWebUtils.getPermItemId(ctx, uipk, method, permItemId, serviceId, shruicode);
    }

    public static String getPermItemId(String uipk, String method, String permItemId, String serviceId) {
        return SHRPermissionWebUtils.getPermItemId(SHRContext.getInstance().getContext(), uipk, method, permItemId, serviceId, null);
    }

    public static String getPermItemId(Context ctx, String uipk, String method, String permItemId, String serviceId, String shruicode) {
        String _permItemId = SHRPermissionWebUtils.getPermItemIdByUipkAndMethod(ctx, uipk = SHRPermissionWebUtils.getRealUipk(uipk), method, shruicode);
        if (!StringUtils.isEmpty((String)_permItemId)) {
            return _permItemId;
        }
        if (!StringUtils.isEmpty((String)permItemId)) {
            return permItemId;
        }
        if (!StringUtils.isEmpty((String)serviceId)) {
            _permItemId = SHRUserOrgPermissionApi.getPermItemIDByServiceID((Context)ctx, (String)serviceId);
        }
        return _permItemId;
    }

    public static String getPermItemIdByUipkAndMethod(String uipk, String method) {
        return SHRPermissionWebUtils.getPermItemIdByUipkAndMethod(SHRContext.getInstance().getContext(), uipk, method, null);
    }

    public static String getPermItemIdByUipkAndMethod(Context ctx, String uipk, String method, String shruicode) {
        String permItemId0 = SHRPermissionWebUtils.getPermItemIdByUipkAndMethod0(ctx, uipk, method, shruicode);
        if (!StringUtils.isEmpty((String)permItemId0)) {
            return permItemId0;
        }
        permItemId0 = SHRPermissionWebUtils.getPermItemIdByUipkAndInitMethod(ctx, uipk, shruicode);
        if (!StringUtils.isEmpty((String)permItemId0)) {
            return permItemId0;
        }
        if (!StringUtils.isEmpty((String)shruicode)) {
            permItemId0 = SHRPermissionWebUtils.getPermItemIdByUipkAndMethod0(ctx, uipk, method, null);
            if (!StringUtils.isEmpty((String)permItemId0)) {
                return permItemId0;
            }
            permItemId0 = SHRPermissionWebUtils.getPermItemIdByUipkAndInitMethod(ctx, uipk, null);
            if (!StringUtils.isEmpty((String)permItemId0)) {
                return permItemId0;
            }
        }
        return null;
    }

    public static String getPermItemIdByUipkAndInitMethod(String uipk) {
        return SHRPermissionWebUtils.getPermItemIdByUipkAndInitMethod(SHRContext.getInstance().getContext(), uipk, null);
    }

    public static String getPermItemIdByUipkAndInitMethod(Context ctx, String uipk, String shruicode) {
        String method = "initalize";
        return SHRPermissionWebUtils.getPermItemIdByUipkAndMethod0(ctx, uipk, method, shruicode);
    }

    private static String getPermItemIdByUipkAndMethod0(Context ctx, String uipk, String method, String shruicode) {
        PermItemInfo permItemInfo = SHRPermissionWebUtils.getPermItemInfo(ctx, "/dynamic.do", uipk, method, null, shruicode);
        if (permItemInfo != null && permItemInfo.getId() != null) {
            return permItemInfo.getId().toString();
        }
        return null;
    }

    private static PermItemInfo getPermItemInfo(Context ctx, String url, String uipk, String method, String module, String shruicode) {
        String url0 = SHRPermissionWebUtils.doAssemblePermissionURL(null, url, uipk, method, module, shruicode);
        return PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)url0);
    }

    public static String getCurrentRequestUserHeadOfDepartmentAdminRangeSQL(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    public static Set<String> getCurrentRequestUserHeadOfDepartmentAdminRangeSet(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = SHRPermissionWebUtils.getCurrentUserId(ctx);
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSet((Context)ctx, (String)userId, (String)SHRPermissionWebUtils.getCurrentRequestPermItemId(request));
    }

    static {
        REFERER_UIPK_MAPPING.put("com.kingdee.shr.base.syssetting.app.ListFilterSolution.form", "/dynamic.do?method=initalize#uri=com.kingdee.shr.base.syssetting.app.UIView.form");
        REFERER_UIPK_MAPPING.put("com.kingdee.shr.base.syssetting.app.ListSetSolution.form", "/dynamic.do?method=initalize#uri=com.kingdee.shr.base.syssetting.app.UIView.form");
        REFERER_UIPK_MAPPING.put("com.kingdee.shr.base.permission.app.ExpFilterConfig.form", "/dynamic.do?method=initalize#uri=com.kingdee.shr.base.permission.app.ExpFilterConfig.list");
        REFERER_UIPK_METHOD_MAPPING.put("com.kingdee.shr.report.app.ReportDef.list#getPeriodYearList", "/dynamic.do?method=initalize#uri=com.kingdee.shr.report.app.ReportDef.list");
        REFERER_UIPK_METHOD_MAPPING.put("com.kingdee.shr.report.app.ReportDef.list#getPeriodMonthList", "/dynamic.do?method=initalize#uri=com.kingdee.shr.report.app.ReportDef.list");
        UIPK_MAPPING.put("com.kingdee.shr.formulaplatform.app.Formula.simulate", "com.kingdee.shr.formulaplatform.app.Formula");
        UIPK_MAPPING.put("com.kingdee.shr.formulaplatform.app.FormulaItem.formEdit.list", "com.kingdee.shr.formulaplatform.app.Formula");
        UIPK_MAPPING.put("com.kingdee.shr.formulaplatform.app.FormulaVar.formEdit.list", "com.kingdee.shr.formulaplatform.app.Formula");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_EMP_", "Full Application of Employees");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_PERF_", "Full Application of Performance");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_CMP_", "Full Application of Compensation");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_ATS_", "Full Application of Attendance");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_SSC_", "Full Application of HRSSC");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_SYS_", "Full Application of System Platform");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_ORG_", "Full Application of organization");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_REC_", "Full Application of Recruiting");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_TRAIN_", "Full Application of Training");
        REQUEST_SHR_UICODE_PERMISSION.put("AF_FM_", "Full Application of Formula Platform");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_EMP_", "Common Application of Employees");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_PERF_", "Common Application of Performance");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_CMP_", "Common Application of Compensation");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_ATS_", "Common Application of Attendance");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_SSC_", "Common Application of HRSSC");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_SYS_", "Common Application of System Platform");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_ORG_", "Common Application of organization");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_REC_", "Common Application of Recruiting");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_TRAIN_", "Common Application of Training");
        REQUEST_SHR_UICODE_PERMISSION.put("OF_FM_", "Common Application of Formula Platform");
    }
}

