/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.view.ListController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/objectHistoryInfoList"})
public class ObjectHistoryInfoListController
extends ListController {
    private static final Logger logger = Logger.getLogger(ObjectHistoryInfoListController.class);
    private static UIViewInfo finalViewInfo = new UIViewInfo();
    private static final String POSITION_EXT = "com.kingdee.eas.hr.org.app.PositionExtendHis";
    private static final String ADMIN_ORG_EXT = "com.kingdee.eas.hr.org.app.SHRAdminOrgUnitExtendHIS";

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = request.getParameter("billId");
        if (!StringUtils.isEmpty((String)billId)) {
            modelMap.put((Object)"uipk", (Object)request.getParameter("uipk"));
            modelMap.put((Object)"billId", (Object)URLEncoder.encode(billId));
        }
        return "/framework/objectHistoryInfoList";
    }

    @Override
    public String getListData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        try {
            UIViewInfo viewInfo;
            String billId = request.getParameter("billId");
            int rows = Integer.parseInt(request.getParameter("rows"));
            int page = Integer.parseInt(request.getParameter("page"));
            String uipk = request.getParameter("uipk");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            finalViewInfo = viewInfo = UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
            sic = UIViewUtil.assembleSelector(viewInfo);
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            sic.add(new SelectorItemInfo("lastUpdateUser.name"));
            sic.add(new SelectorItemInfo("lastUpdateUser.number"));
            sic.add(new SelectorItemInfo("lastUpdateUser.person.id"));
            sic.add(new SelectorItemInfo("lastUpdateUser.person.name"));
            sic.add(new SelectorItemInfo("lastUpdateUser.person.number"));
            sic.add(new SelectorItemInfo("lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.person.id"));
            sic.add(new SelectorItemInfo("creator.person.name"));
            sic.add(new SelectorItemInfo("creator.person.number"));
            sic.add(new SelectorItemInfo("creator.id"));
            entityViewInfo.setSelector(sic);
            try {
                SorterItemCollection sorters = new SorterItemCollection();
                sorters.getSorter().decode("order by EFFDT DESC");
                entityViewInfo.setSorter(sorters);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            ICoreBase iCoreBase = this.getBizinterface(request, billId);
            List historys = this.getObjectHistoryRecords(iCoreBase, billId, entityViewInfo, (page - 1) * rows, rows);
            GridDataEntity gridData = this.assembleGridData(historys, billId);
            int totalCount = this.getObjectHistoryRecordsCount(iCoreBase, billId, entityViewInfo);
            if (totalCount % rows == 0) {
                gridData.setTotal(totalCount / rows);
            } else {
                gridData.setTotal(totalCount / rows + 1);
            }
            gridData.setRecords(totalCount);
            gridData.setPage(page);
            JSONUtils.writeJson(response, gridData);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    private ICoreBase getBizinterface(HttpServletRequest request, String billId) throws SHRWebException {
        String uipk = request.getParameter("uipk");
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
        String view_model = uiViewInfo.getModel();
        ICoreBase iCoreBase = null;
        try {
            if (!StringUtils.isEmpty((String)view_model)) {
                iCoreBase = MetaDataUtil.getBizInterface(view_model);
            }
            if (iCoreBase == null) {
                iCoreBase = MetaDataUtil.getBizInterface(BOSUuid.read((String)billId).getType());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
        return iCoreBase;
    }

    private List getObjectHistoryRecords(ICoreBase iCoreBase, String billId, EntityViewInfo entityViewInfo, int start, int length) throws SHRWebException {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(billId);
            return iCoreBase.getAllHisVersionReturnCurrentPaging((IObjectPK)pk, entityViewInfo, start, length);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    private int getObjectHistoryRecordsCount(ICoreBase iCoreBase, String billId, EntityViewInfo entityViewInfo) throws SHRWebException {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(billId);
            return iCoreBase.getAllHistoryVersionCount((IObjectPK)pk, entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    private GridDataEntity assembleGridData(List historys, String billId) {
        GridDataEntity gridData = new GridDataEntity();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        EntityObjectInfo enetityInfo = MetaDataUtil.getEntityObject(billId);
        for (int i = 0; i < historys.size(); ++i) {
            if (i + 1 == historys.size()) {
                result.add(this.assembleGridDataItem(null, historys.get(i), billId, enetityInfo));
                continue;
            }
            result.add(this.assembleGridDataItem(historys.get(i + 1), historys.get(i), billId, enetityInfo));
        }
        gridData.setRows(result);
        return gridData;
    }

    private Map<String, Object> getExtendInfo(CoreBaseInfo coreBaseInfo, CoreBaseInfo coreBaseInfoBefore, String billId) {
        if (coreBaseInfo == null) {
            return null;
        }
        HashMap<String, CoreBaseInfo> extendMap = null;
        String entityName = null;
        CoreBaseInfo extendInfo = null;
        CoreBaseInfo extendBeforeInfo = null;
        if (coreBaseInfo instanceof PositionInfo) {
            entityName = POSITION_EXT;
        } else if (coreBaseInfo instanceof AdminOrgUnitInfo) {
            entityName = ADMIN_ORG_EXT;
        }
        try {
            if (entityName != null) {
                EntityViewInfo viewInfo = this.getEntityView(coreBaseInfo, billId);
                ICoreBase iCoreBase = MetaDataUtil.getBizInterface(entityName);
                extendInfo = iCoreBase.getCollection(viewInfo).get(0);
                if (coreBaseInfoBefore != null) {
                    EntityViewInfo viewBeforeInfo = this.getEntityView(coreBaseInfoBefore, billId);
                    extendBeforeInfo = iCoreBase.getCollection(viewBeforeInfo).get(0);
                }
                extendMap = new HashMap<String, CoreBaseInfo>();
                extendMap.put("extendInfo", extendInfo);
                extendMap.put("extendBeforeInfo", extendBeforeInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return extendMap;
    }

    private EntityViewInfo getEntityView(CoreBaseInfo coreBaseInfo, String billId) {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        EntityObjectInfo extendEntity = null;
        String paraString = null;
        if (coreBaseInfo instanceof PositionInfo) {
            paraString = "position";
            extendEntity = MetaDataUtil.getEntityObjectByEntityName(POSITION_EXT);
        } else if (coreBaseInfo instanceof AdminOrgUnitInfo) {
            extendEntity = MetaDataUtil.getEntityObjectByEntityName(ADMIN_ORG_EXT);
            paraString = "adminOrgUnit";
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        PropertyCollection properties = null;
        if (extendEntity != null) {
            properties = extendEntity.getProperties();
        }
        PropertyInfo propertyInfo = null;
        if (properties != null) {
            int size = properties.size();
            for (int i = 0; i < size; ++i) {
                propertyInfo = properties.get(i);
                if (!(propertyInfo instanceof LinkPropertyInfo) || propertyInfo.getName().equals(paraString)) continue;
                sic.add(new SelectorItemInfo(propertyInfo.getName() + ".name"));
            }
        }
        viewInfo.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo(paraString, (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", coreBaseInfo.get("EFFDT"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", coreBaseInfo.get("LEFFDT"), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private Map<String, Object> assembleGridDataItem(Object objBefore, Object obj, String billId, EntityObjectInfo enetityInfo) {
        UserInfo userInfo;
        HashMap<String, Object> item = new HashMap<String, Object>();
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)obj;
        CoreBaseInfo coreBaseInfoBefore = (CoreBaseInfo)objBefore;
        Map<String, Object> extendMap = this.getExtendInfo(coreBaseInfo, coreBaseInfoBefore, billId);
        CoreBaseInfo extendInfo = null;
        CoreBaseInfo extendBeforeInfo = null;
        EntityObjectInfo extendEntity = null;
        HashSet<String> extEntityProName = new HashSet<String>();
        if (extendMap != null) {
            extendInfo = (CoreBaseInfo)extendMap.get("extendInfo");
            extendBeforeInfo = (CoreBaseInfo)extendMap.get("extendBeforeInfo");
            if (extendInfo != null) {
                extendEntity = MetaDataUtil.getEntityObjectByBosType(extendInfo.getBOSType());
                PropertyCollection properties = extendEntity.getProperties();
                String propertyName = null;
                int size = properties.size();
                for (int i = 0; i < size; ++i) {
                    propertyName = properties.get(i).getName();
                    extEntityProName.add(propertyName.toLowerCase());
                }
                extEntityProName.remove(HistoryConstant.EFFDT.toLowerCase());
                extEntityProName.remove(HistoryConstant.LEFFDT.toLowerCase());
            }
        }
        item.put("id", coreBaseInfo.get(HistoryConstant.historyRelateID));
        item.put(HistoryConstant.EFFDT, coreBaseInfo.get(HistoryConstant.EFFDT) == null ? "" : DateTimeUtils.formatDate((Date)((Date)coreBaseInfo.get(HistoryConstant.EFFDT))));
        if (coreBaseInfo instanceof PositionInfo || coreBaseInfo instanceof AdminOrgUnitInfo) {
            item.put("lastUpdateTime", coreBaseInfo.get("createTime") == null ? "" : DateTimeUtils.formatDate((Date)((Date)coreBaseInfo.get("createTime"))));
            userInfo = (UserInfo)coreBaseInfo.get("creator");
            item.put("lastUpdateUser", userInfo.getPerson() != null ? userInfo.getPerson().getName() : userInfo.getName());
        } else {
            item.put("lastUpdateTime", coreBaseInfo.get("lastUpdateTime") == null ? "" : DateTimeUtils.formatDate((Date)((Date)coreBaseInfo.get("lastUpdateTime"))));
            userInfo = (UserInfo)coreBaseInfo.get("lastUpdateUser");
            item.put("lastUpdateUser", userInfo.getPerson() != null ? userInfo.getPerson().getName() : userInfo.getName());
        }
        ArrayList list = (ArrayList)finalViewInfo.getFields();
        String result = "";
        String resultBefore = "";
        if (coreBaseInfoBefore != null) {
            for (int i = 0; i < list.size(); ++i) {
                FieldInfo fieldInfo = (FieldInfo)list.get(i);
                String alias = fieldInfo.getAlias();
                String name = fieldInfo.getName();
                Object valueObj = null;
                Object valueBeforeObj = null;
                boolean isExtend = false;
                if (extEntityProName.contains(name.toLowerCase())) {
                    isExtend = true;
                    valueObj = extendInfo != null ? extendInfo.get(name) : null;
                    valueBeforeObj = extendBeforeInfo != null ? extendBeforeInfo.get(name) : null;
                } else if (name.indexOf("ext_") > 0 && extendInfo != null) {
                    isExtend = true;
                    name = name.substring(name.indexOf("ext_") + 4);
                    valueObj = extendInfo != null ? extendInfo.get(name) : null;
                    valueBeforeObj = extendBeforeInfo != null ? extendBeforeInfo.get(name) : null;
                } else {
                    valueObj = coreBaseInfo.get(name);
                    valueBeforeObj = coreBaseInfoBefore.get(name);
                }
                if (this.equalsObject(valueObj, valueBeforeObj)) continue;
                CoreBaseInfo currentInfo = coreBaseInfo;
                CoreBaseInfo beforeInfo = coreBaseInfoBefore;
                if (isExtend) {
                    currentInfo = extendInfo;
                    beforeInfo = extendBeforeInfo;
                    result = result + this.getAfterResult(name, alias, currentInfo, extendEntity);
                    resultBefore = resultBefore + this.getBeforeResult(name, alias, beforeInfo, extendEntity);
                    continue;
                }
                result = result + this.getAfterResult(name, alias, currentInfo, enetityInfo);
                resultBefore = resultBefore + this.getBeforeResult(name, alias, beforeInfo, enetityInfo);
            }
        }
        if (!result.equals("")) {
            if (result.endsWith("@")) {
                result = result.substring(0, result.length() - 1);
            }
            item.put("afterUpdate", result);
        }
        if (!resultBefore.equals("")) {
            if (resultBefore.endsWith("@")) {
                resultBefore = resultBefore.substring(0, resultBefore.length() - 1);
            }
            item.put("beforeUpdate", resultBefore);
        }
        Date leffdt = (Date)coreBaseInfo.get(HistoryConstant.LEFFDT);
        item.put("isNewest", HistoryUtil.getMaxDate().equals(leffdt));
        return item;
    }

    private String getEnumSourceName(String name, EntityObjectInfo enetityInfo) {
        OwnPropertyInfo info;
        String metadataRef = null;
        PropertyInfo propertyInfo = enetityInfo.getPropertyByNameRuntime(name);
        if (propertyInfo instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)(info = (OwnPropertyInfo)propertyInfo).getDataType())) {
            metadataRef = info.getMetaDataRef();
        }
        return metadataRef;
    }

    private Object getRealEnumValue(String metadataRef, Object val) {
        return com.kingdee.shr.base.syssetting.app.util.MetaDataUtil.findEnumByValue((String)metadataRef, (Object)val);
    }

    public String getAfterResult(String name, String alias, CoreBaseInfo coreBaseInfo, EntityObjectInfo enetityInfo) {
        String result = "";
        if (coreBaseInfo == null) {
            return "";
        }
        if (coreBaseInfo == null || coreBaseInfo.get(name) == null || coreBaseInfo.get(name).toString() == null) {
            result = result + "<span style = 'color: red;'>" + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "empty") + "\uff1b</span>@";
        } else if (coreBaseInfo.get(name).toString().equals("false")) {
            result = name.equals("isSealUp") ? result + "<span style = 'color: red;'>" + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "enable") + "\uff1b</span>@" : result + "<span style = 'color: red;'>" + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false") + "\uff1b</span>@";
        } else if (coreBaseInfo.get(name).toString().equals("true")) {
            result = name.equals("isSealUp") ? result + "<span style = 'color: red;'>" + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "seal") + "\uff1b</span>@" : result + "<span style = 'color: red;'>" + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "true") + "\uff1b</span>@";
        } else {
            Object value = coreBaseInfo.get(name);
            String metadataRef = this.getEnumSourceName(name, enetityInfo);
            if (!StringUtils.isEmpty((String)metadataRef)) {
                Object realValue = this.getRealEnumValue(metadataRef, value);
                result = result + "<span style = 'color: red;'>" + alias + "\uff1a" + realValue + "\uff1b</span>@";
            } else {
                value = this.otherSpecialToValue(value);
                result = result + "<span style = 'color: red;'>" + alias + "\uff1a" + value + "\uff1b</span>@";
            }
        }
        return result;
    }

    public String getBeforeResult(String name, String alias, CoreBaseInfo coreBaseInfo, EntityObjectInfo enetityInfo) {
        String result = "";
        if (coreBaseInfo == null || coreBaseInfo.get(name) == null) {
            result = result + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "empty") + "\uff1b@";
        } else if (null != coreBaseInfo.get(name).toString() && coreBaseInfo.get(name).toString().equals("false")) {
            result = name.equals("isSealUp") ? result + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "enable") + "\uff1b@" : result + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false") + "\uff1b@";
        } else if (null != coreBaseInfo.get(name).toString() && coreBaseInfo.get(name).toString().equals("true")) {
            result = name.equals("isSealUp") ? result + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "seal") + "\uff1b@" : result + alias + ":" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "true") + "\uff1b@";
        } else {
            Object value = coreBaseInfo.get(name);
            String metadataRef = this.getEnumSourceName(name, enetityInfo);
            if (!StringUtils.isEmpty((String)metadataRef)) {
                Object realValue = this.getRealEnumValue(metadataRef, value);
                result = result + alias + ":" + realValue + "\uff1b@";
            } else {
                value = this.otherSpecialToValue(value);
                result = result + alias + ":" + value + "\uff1b@";
            }
        }
        return result;
    }

    public Object otherSpecialToValue(Object value) {
        Object _value = value;
        Timestamp time = new Timestamp(0L);
        if (value.getClass().equals(time.getClass())) {
            _value = value.toString().substring(0, 10);
        }
        try {
            String strNum;
            if (value instanceof TreeBaseInfo) {
                TreeBaseInfo treeBaseInfo = (TreeBaseInfo)value;
                _value = !StringUtils.isEmpty((String)treeBaseInfo.getDisplayName()) && treeBaseInfo.getId() != null ? (null != (treeBaseInfo = (TreeBaseInfo)MetaDataUtil.getBizInterface(treeBaseInfo.getBOSType()).getValue((IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()))) ? treeBaseInfo.getDisplayName() : "") : "";
            } else if (value instanceof DataBaseInfo) {
                DataBaseInfo dataBaseInfo = (DataBaseInfo)value;
                if (!StringUtils.isEmpty((String)dataBaseInfo.getName()) && dataBaseInfo.getId() != null) {
                    if (null != (dataBaseInfo = (DataBaseInfo)MetaDataUtil.getBizInterface(dataBaseInfo.getBOSType()).getValue((IObjectPK)new ObjectUuidPK(dataBaseInfo.getId())))) {
                        _value = dataBaseInfo.getName();
                    }
                } else {
                    _value = "";
                }
            } else if (value != null && value instanceof Number && (strNum = value.toString()).indexOf(".") > 0) {
                strNum = strNum.replaceAll("0+?$", "");
                strNum = strNum.replaceAll("[.]$", "");
                _value = strNum;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            _value = "";
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            _value = "";
        }
        return _value;
    }

    public boolean equalsObject(Object obj, Object obj2) {
        if (obj == null || obj2 == null) {
            return obj == null && obj2 == null;
        }
        if (obj.getClass().toString().equals("class java.lang.Boolean")) {
            return obj.toString().equals(obj2.toString());
        }
        return obj.equals(obj2);
    }

    @Override
    protected String getEditUrl(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        return null;
    }

    @Override
    protected String getViewUrl(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    protected IMetaDataPK getQueryPK() throws SHRWebException, ShrWebBizException {
        return null;
    }
}

