/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter;

import com.alibaba.fastjson.JSON;
import com.kingdee.shr.base.syssetting.web.filter.XSSRequestWrapper;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class XSSFilter
implements Filter {
    private static Logger logger = Logger.getLogger(XSSFilter.class);
    private String uipkAndHandlerWhiteList = "";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.uipkAndHandlerWhiteList = filterConfig.getInitParameter("uipkAndHandlerWhiteList");
        logger.debug((Object)" SQLInjectionFilter init success ");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isBreakFilter(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            try {
                filterChain.doFilter((ServletRequest)new XSSRequestWrapper((HttpServletRequest)servletRequest), servletResponse);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                logger.error((Object)e.getMessage());
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("result", "error");
                resultMap.put("summary", e.getMessage());
                resultMap.put("detailInfo", "");
                HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
                httpResponse.setStatus(200);
                httpResponse.setContentType("application/json;charset=UTF-8");
                httpResponse.getWriter().write(JSON.toJSONString(resultMap));
            }
        }
    }

    private boolean isBreakFilter(ServletRequest servletRequest) {
        if (!StringUtils.isEmpty((String)this.uipkAndHandlerWhiteList)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String uipk = httpServletRequest.getParameter("uipk");
            String handler = httpServletRequest.getParameter("handler");
            if (!StringUtils.isEmpty((String)handler) && this.uipkAndHandlerWhiteList.contains(handler)) {
                return true;
            }
            if (!StringUtils.isEmpty((String)uipk) && this.uipkAndHandlerWhiteList.contains(uipk)) {
                return true;
            }
        }
        return false;
    }
}

