/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.shr.base.permission.field.form.IShrFieldPermForm;
import com.kingdee.shr.base.permission.field.form.ShrFieldPermForm;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.NumberRuleHelper;
import com.kingdee.shr.base.syssetting.web.controller.DataGridController;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.ExportHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.WebHistoryUtil;
import com.kingdee.shr.base.syssetting.web.handler.CoreHandler;
import com.kingdee.shr.base.syssetting.web.handler.IEditHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.support.defaultvalue.DefaultValueService;
import com.kingdee.shr.base.syssetting.web.support.fieldrule.FieldRuleHelper;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class EditHandler
extends CoreHandler
implements IEditHandler {
    private static Logger logger = Logger.getLogger(EditHandler.class);
    protected DataGridController dataGrid = new DataGridController();
    protected IShrFieldPermForm shrFieldPerm = null;

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String operateStatus = this.getOperateStatus(request, modelMap);
        if (!StringUtils.isEmpty((String)operateStatus)) {
            if ("ADDNEW".equalsIgnoreCase(operateStatus)) {
                return this.addNewAction(request, response, modelMap);
            }
            if ("EDIT".equalsIgnoreCase(operateStatus)) {
                return this.editAction(request, response, modelMap);
            }
            if ("VIEW".equalsIgnoreCase(operateStatus) || "readonly".equalsIgnoreCase(operateStatus)) {
                return this.viewAction(request, response, modelMap);
            }
        }
        return this.viewAction(request, response, modelMap);
    }

    @Override
    public String viewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        request.setAttribute("operateState", (Object)"VIEW");
        this.initModel(request, response, modelMap);
        this.beforeRender(request, response, modelMap);
        return this.getViewName(request);
    }

    @Override
    public String editAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        request.setAttribute("operateState", (Object)"EDIT");
        this.initModel(request, response, modelMap);
        this.beforeRender(request, response, modelMap);
        return this.getViewName(request);
    }

    @Override
    public String changeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String view = this.editAction(request, response, modelMap);
        this.setChangeInfo(modelMap);
        request.setAttribute("historyOperateState", (Object)"change");
        return view;
    }

    private void setChangeInfo(ModelMap modelMap) {
        CoreBaseInfo model = (CoreBaseInfo)modelMap.get((Object)"model");
        model.put(HistoryConstant.EFFDT, (Object)new Date());
    }

    @Override
    public String reviseAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String view = this.editAction(request, response, modelMap);
        request.setAttribute("historyOperateState", (Object)"revise");
        return view;
    }

    @Override
    public String reviseHistoryAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String view = this.editAction(request, response, modelMap);
        request.setAttribute("historyOperateState", (Object)"reviseHistory");
        return view;
    }

    @Override
    protected void beforeRender(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CoreBaseInfo model = (CoreBaseInfo)modelMap.get((Object)"model");
        String entityName = this.getUIViewInfo(request).getEntityName();
        boolean isNeedHistory = MetaDataUtil.isNeedHistory(this.getUIViewInfo(request).getEntityName());
        Date modelEFFDT = null;
        modelEFFDT = isNeedHistory && WebHistoryUtil.isHistoryVersion(request) ? (Date)model.get(HistoryConstant.EFFDT) : new Date();
        modelMap.put((Object)"modelEFFDT", (Object)modelEFFDT);
        String operateState = this.getOperateStatus(request, modelMap);
        boolean tagReadonly = isNeedHistory && WebHistoryUtil.isHistoryVersion(request) || !"VIEW".equalsIgnoreCase(operateState);
        modelMap.put((Object)"tagReadonly", (Object)String.valueOf(tagReadonly));
        if (model != null) {
            model.put("_entityName", (Object)entityName);
        }
        if ("ADDNEW".equals(operateState) || "EDIT".equals(operateState)) {
            this.initCodingRule(request, modelMap, model);
        }
        super.beforeRender(request, response, modelMap);
        this.doFieldPermFilter(this.shrFieldPerm, operateState, model);
    }

    @Override
    protected String getBreadcrumbValue(HttpServletRequest request, ModelMap modelMap) throws SHRWebException {
        if ("ADDNEW".equalsIgnoreCase(this.getOperateStatus(request, modelMap))) {
            return SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "create");
        }
        if ("viewTitle".equalsIgnoreCase(request.getParameter("breadcrumbType"))) {
            return super.getBreadcrumbValue(request, modelMap);
        }
        String value = null;
        CoreBaseInfo model = (CoreBaseInfo)modelMap.get((Object)"model");
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        boolean isNeedHistory = MetaDataUtil.isNeedHistory(uiViewInfo.getEntityName());
        if (isNeedHistory && WebHistoryUtil.isHistoryVersion(request)) {
            Date date = (Date)model.get(HistoryConstant.EFFDT);
            value = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        } else {
            Object obj;
            String fieldName = null;
            if (uiViewInfo.getBreadcrumb() != null) {
                fieldName = uiViewInfo.getBreadcrumb().getFieldName();
            }
            if (StringUtils.isEmpty(fieldName)) {
                fieldName = "name";
            }
            if ((obj = DynamicUtil.getObjectPropertyValue(model, fieldName)) instanceof String) {
                value = (String)obj;
            } else if (obj != null) {
                value = obj.toString();
            }
        }
        if (value == null) {
            value = super.getBreadcrumbValue(request, modelMap);
        }
        return value;
    }

    private void initCodingRule(HttpServletRequest request, ModelMap modelMap, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        if (coreBaseInfo == null) {
            return;
        }
        boolean numberCanEdit = false;
        String codingRuleHrOrgUnit = MetaDataUtil.getHrOrgUnitLinkPropertyInfoName(this.getUIViewInfo(request).getEntityName());
        if (!UIViewUtil.isContainHrOrgUnit(this.getUIViewInfo(request), codingRuleHrOrgUnit)) {
            codingRuleHrOrgUnit = null;
        }
        if (coreBaseInfo.get("numberFieldCanEdit") != null) {
            numberCanEdit = (Boolean)coreBaseInfo.get("numberFieldCanEdit");
        }
        String operateState = this.getOperateStatus(request, modelMap);
        String codingNumberField = null;
        if ("EDIT".equals(operateState)) {
            String orgId = null;
            CoreBaseInfo tempOrg = null;
            Object tempObject = null;
            if (!StringUtils.isEmpty((String)codingRuleHrOrgUnit)) {
                tempObject = coreBaseInfo.get(codingRuleHrOrgUnit);
            }
            if (tempObject instanceof CoreBaseInfo) {
                tempOrg = (CoreBaseInfo)tempObject;
                orgId = tempOrg.getId().toString();
            } else {
                orgId = this.getMainOrgId();
            }
            numberCanEdit = this.bizNumberCanEdit(this.getContext(), coreBaseInfo, orgId);
        }
        Map initData = (Map)request.getAttribute("view_initData");
        codingNumberField = SHRCodingRuleApi.getCodingRuleProperty((String)coreBaseInfo.getBOSType().toString());
        initData.put("codingRulePropertyName", codingNumberField);
        initData.put("numberFieldCanEdit", numberCanEdit);
        initData.put("codingRuleHrOrgUnit", codingRuleHrOrgUnit);
    }

    protected boolean bizNumberCanEdit(Context ctx, CoreBaseInfo coreBaseInfo, String orgId) {
        return !NumberRuleHelper.hasCodingRule((IObjectValue)coreBaseInfo, orgId);
    }

    public String getCodingRuleByHrOrgUnitAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Class modelClass = this.getModelType(request);
        CoreBaseInfo model = (CoreBaseInfo)MetaDataUtil.newInstance(modelClass, this.getUIViewInfo(request).getEntityName());
        String hrOrgUnit = request.getParameter("codingRuleHrOrgUnit");
        SHRCodingRule shrCodingRule = this.getCodingRuleByHrOrgUnit(request, model, hrOrgUnit, modelMap);
        JSONUtils.writeJson(response, shrCodingRule);
        return null;
    }

    protected SHRCodingRule getCodingRuleByHrOrgUnit(HttpServletRequest request, CoreBaseInfo model, String mainOrgID, ModelMap modelMap) throws SHRWebException {
        IObjectValue numberFromModel = this.getAutoNumberFromModel((IObjectValue)model);
        SHRCodingRule shrCodingRule = NumberRuleHelper.getCodingNumber(numberFromModel, mainOrgID);
        return shrCodingRule;
    }

    @Override
    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        super.setInitData(request, response, modelMap, initData);
        initData.put("fieldRule", FieldRuleHelper.getConvertFieldRuleInitData(this.getContext(), this.getUIViewInfo(request).getUipk()));
        initData.put("createNewEntryModelByServer", this.createNewEntryModelByServer());
        Map<String, String> map = UIViewUtil.getObjectCollectionFields(this.getUIViewInfo(request));
        initData.put("objectCollectionTypeFields", map.keySet());
        initData.put("objectCollectionTypeFullNames", map);
    }

    protected CoreBaseInfo initModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.shrFieldPerm = this.fieldPermInit(request);
        FieldRuleHelper.initFieldRule(this.getContext(), this.getUIViewInfo(request).getUipk());
        CoreBaseInfo model = null;
        if (request.getAttribute("InitDataObject") != null) {
            model = (CoreBaseInfo)request.getAttribute("InitDataObject");
        } else {
            String billId = this.getBillId(request);
            if (!StringUtils.isEmpty((String)billId)) {
                logger.info((Object)("start get data:" + System.currentTimeMillis()));
                model = this.getModelValue(request, billId);
                logger.info((Object)("end get data:" + System.currentTimeMillis()));
            } else {
                model = this.createNewModel(request, response, modelMap);
            }
        }
        this.afterInitModel(request, response, model);
        modelMap.addAttribute("model", (Object)model);
        if (model != null) {
            if (model.getId() != null) {
                modelMap.addAttribute("billId", (Object)URLEncoder.encode(model.getId().toString()));
            }
            try {
                SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                model.put("attachmentID", (Object)("attachment_" + random.nextInt(1000) + System.currentTimeMillis()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SHRWebException(e.getMessage(), e);
            }
        }
        return model;
    }

    protected List<FieldInfo> getUIViewFieldsForMultiLan(HttpServletRequest request) throws SHRWebException {
        return this.getUIViewInfo(request).getFields();
    }

    protected final void initMutilLan(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }

    @Override
    protected String getBillId(HttpServletRequest request) throws SHRWebException {
        String modelId = request.getParameter(HistoryConstant.historyRelateID);
        if (StringUtils.isEmpty((String)modelId)) {
            modelId = request.getParameter("modelID");
        }
        if (StringUtils.isEmpty((String)modelId)) {
            modelId = super.getBillId(request);
        }
        return modelId;
    }

    protected void afterInitModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo coreBaseInfo) throws SHRWebException {
    }

    public String addNewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        request.setAttribute("operateState", (Object)"ADDNEW");
        this.shrFieldPerm = this.fieldPermInit(request);
        FieldRuleHelper.initFieldRule(this.getContext(), this.getUIViewInfo(request).getUipk());
        CoreBaseInfo model = this.createNewModel(request, response, modelMap);
        modelMap.addAttribute("model", (Object)model);
        this.beforeRender(request, response, modelMap);
        return this.getViewName(request);
    }

    @Override
    public String saveAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
            this.beforeSave(request, response, model);
            this.doFieldPermFilterSave(request, model);
            IObjectPK objectPK = this.runSaveData(request, response, model);
            model.setId(BOSUuid.read((String)objectPK.toString()));
            this.afterSave(request, response, model);
            this.saveAttachment(request, response, model);
            Object responseData = this.generateResponseDataAfterSave(request, response, model);
            this.writeSuccessData(responseData);
        }
        catch (SQLAccessException e) {
            if (e.getCause() instanceof DataLimitExceedException) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "field_too_long"), e);
            }
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (SHRWebException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return null;
    }

    protected Object generateResponseDataAfterSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        return model.getId().toString();
    }

    protected void beforeSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        this.verifyModel(request, response, model);
    }

    @Override
    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        this.verifyModel(request, response, model);
    }

    protected IObjectPK runSaveData(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws Exception {
        IObjectPK pk = null;
        String historyOperateState = request.getParameter("historyOperateState");
        if ("change".equals(historyOperateState)) {
            pk = this.runSave(request, response, model);
        } else if ("revise".equals(historyOperateState)) {
            pk = new ObjectUuidPK(model.getId().toString());
            this.runRevise(request, response, model, pk);
        } else if ("reviseHistory".equals(historyOperateState)) {
            pk = new ObjectUuidPK(request.getParameter("historyRelateID"));
            this.runRevisionHistory(request, response, model, pk);
        } else {
            pk = this.runSave(request, response, model);
        }
        return pk;
    }

    protected IObjectPK runSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws Exception {
        return this.getBizInterface(request).save(model);
    }

    protected IObjectPK runRevise(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model, IObjectPK pk) throws Exception {
        this.getBizInterface(request).revise(pk, model);
        return pk;
    }

    protected IObjectPK runRevisionHistory(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model, IObjectPK pk) throws Exception {
        this.getBizInterface(request).revisionHistory(pk, model);
        return pk;
    }

    protected void afterSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }

    @Override
    protected void afterSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }

    protected void verifyModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }

    public CoreBaseInfo getModelValue(HttpServletRequest request, String modelID) throws SHRWebException {
        CoreBaseInfo model = null;
        try {
            model = WebHistoryUtil.isHistoryVersion(request) ? this.getHistoryVersionValue(request, modelID) : this.getValue(request, modelID);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message.contains("MissingRecord")) {
                String isShrBill = request.getParameter("isShrBill");
                String pureWFBillUrl = request.getParameter("pureWFBillUrl");
                if ("true".equals(isShrBill) && "true".equals(pureWFBillUrl)) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_delete_tips"), e);
                }
            }
            throw new SHRWebException(e);
        }
        this.checkDataPermission(request, model);
        return model;
    }

    protected CoreBaseInfo getHistoryVersionValue(HttpServletRequest request, String modelID) throws SHRWebException {
        try {
            return this.getBizInterface(request).getHistoryVersion((IObjectPK)new ObjectUuidPK(modelID), this.getSelectors(request));
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    protected CoreBaseInfo createNewModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Class modelClass = this.getModelType(request);
        if (modelClass != null) {
            try {
                modelClass.asSubclass(CoreBaseInfo.class);
                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)MetaDataUtil.newInstance(modelClass, this.getUIViewInfo(request).getEntityName());
                this.setFieldDefaultValueToNewModel(request, coreBaseInfo);
                this.setAutoNumber((IObjectValue)coreBaseInfo, this.getMainOrgId(), modelMap);
                this.afterCreateNewModel(request, response, coreBaseInfo);
                SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                coreBaseInfo.put("attachmentID", (Object)("attachment_" + (int)(random.nextDouble() * 1000.0 + 1.0)));
                return coreBaseInfo;
            }
            catch (SHRWebException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SHRWebException(e.getMessage(), e);
            }
        }
        return null;
    }

    private void setFieldDefaultValueToNewModel(HttpServletRequest request, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        DefaultValueService.setDefalutValueToCoreBaseInfo(this.getUIViewInfo(request), coreBaseInfo);
    }

    protected void afterCreateNewModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo coreBaseInfo) throws SHRWebException {
    }

    protected Class getModelType() throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfo();
        if (viewInfo == null) {
            return null;
        }
        return MetaDataUtil.getObjectValueClass(viewInfo.getEntityName());
    }

    protected Class getModelType(HttpServletRequest request) throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfo(request);
        if (viewInfo == null) {
            return null;
        }
        return MetaDataUtil.getObjectValueClass(viewInfo.getEntityName());
    }

    protected boolean createNewEntryModelByServer() {
        return false;
    }

    public void createNewEntryModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.writeSuccessData(this.createNewEntryModel(request, response, modelMap));
    }

    protected CoreBaseInfo createNewEntryModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return null;
    }

    protected void setAutoNumber(IObjectValue model, String mainOrgID, ModelMap modelMap) throws SHRWebException {
        IObjectValue numberFromModel = this.getAutoNumberFromModel(model);
        NumberRuleHelper.codingNumber(model, numberFromModel, mainOrgID);
    }

    protected IObjectValue getAutoNumberFromModel(IObjectValue model) throws SHRWebException {
        return model;
    }

    public String exportToExcelEntryAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String fullName;
        UIViewInfo currentUIViewInfo;
        String billRelateField;
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        if (uiViewInfo != null) {
            if (uiViewInfo.getQuery() != null) {
                request.setAttribute("query", (Object)uiViewInfo.getQuery());
            } else {
                request.setAttribute("view_model", (Object)uiViewInfo.getModel());
            }
            if (!StringUtils.isEmpty((String)uiViewInfo.getViewTitle())) {
                request.setAttribute("title", (Object)uiViewInfo.getViewTitle());
            }
        }
        if ((billRelateField = request.getParameter("componentID")) != null && !StringUtils.isEmpty((String)billRelateField) && (currentUIViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request)) != null && (fullName = MetaDataUtil.getEntryEntityName(currentUIViewInfo.getModel(), billRelateField)) != null && !StringUtils.isEmpty((String)fullName)) {
            request.setAttribute("view_model", (Object)fullName);
        }
        ExportHelper helper = new ExportHelper();
        Map<String, Object> excelConfig = this.initExportExcelConfig(request, helper);
        List listData = null;
        String dataString = request.getParameter("datas");
        if (!StringUtils.isEmpty((String)dataString)) {
            listData = (List)JSONUtils.convertJsonToObject(this.getContext(), dataString, List.class);
            this.afterGetExportData(request, response, listData);
            helper.fillData(excelConfig, listData);
        } else {
            this.setFilterBySelectedData(request, modelMap);
            long start = 0L;
            long end = 0L;
            String isAll = request.getParameter("isAll");
            if ("true".equals(isAll)) {
                this.exportAllToExcel(request, response, modelMap, helper, excelConfig);
            } else {
                if (logger.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                }
                if (this.isUserNewExportQueryAll()) {
                    modelMap.put((Object)"isUserNewExportQueryAll", (Object)true);
                }
                GridDataEntity gridDataEntity = this.dataGrid.getEntityEditGridData(request, modelMap);
                if (logger.isDebugEnabled()) {
                    end = System.currentTimeMillis();
                    logger.debug((Object)MessageFormat.format("handler: {0}, get list data, cost: {1}", this.getClass().getName(), end - start));
                }
                listData = gridDataEntity.getRows();
                this.afterGetExportData(request, response, listData);
                helper.fillData0(excelConfig, listData);
            }
        }
        String fileName = "";
        fileName = excelConfig.get("isMuti") != null ? helper.writeExcelToFileAndCompress(excelConfig) : helper.writeExcelToFile(request, excelConfig);
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        if (this.isRequestJSON(request)) {
            this.writeSuccessData(fileName);
            return null;
        }
        modelMap.clear();
        try {
            fileName = WebUtil.convertFileNameForDownload(request, fileName);
            return "redirect:" + fileName;
        }
        catch (UnsupportedEncodingException e) {
            throw new SHRWebException(e);
        }
    }

    protected void exportAllToExcel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, ExportHelper helper, Map<String, Object> excelConfig) throws SHRWebException {
        int columnsSize;
        int pageRow;
        long start = 0L;
        long end = 0L;
        int page = 1;
        int rows = 8000;
        UIViewInfo uv = this.getUIViewInfo(request);
        if ("dynamicList".equals(uv.getType()) && (pageRow = 100000 / (columnsSize = ((List)excelConfig.get("columnModel")).size())) < rows) {
            rows = pageRow;
        }
        List listData = null;
        ArrayList<Map<String, Object>> listDataAll = new ArrayList<Map<String, Object>>();
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        Map<String, Boolean> userData = new HashMap<String, Comparable<Boolean>>();
        userData.put("isExportAllToExcelCount", true);
        userData.put("rows", (Boolean)((Object)Integer.valueOf(rows)));
        userData.put("page", (Boolean)((Object)Integer.valueOf(page)));
        boolean isOrderForExportAll = true;
        try {
            String p = ParamManager.getParamValue((Context)SHRContext.getInstance().getContext(), null, (String)"sHRSupportExportOrder");
            if (!"true".equals(p)) {
                isOrderForExportAll = false;
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        userData.put("sHRSupportExportOrder", isOrderForExportAll);
        request.setAttribute("_userData_", userData);
        GridDataEntity gridDataEntity0 = this.dataGrid.getEntityEditGridDataAll(request, modelMap);
        userData = (Map)gridDataEntity0.getUserdata();
        userData.put("isExportAllToExcelCount", false);
        userData.put("isLastTime", false);
        userData.put("sHRSupportExportOrder", isOrderForExportAll);
        long totalCount = gridDataEntity0.getRecords();
        if (logger.isDebugEnabled()) {
            end = System.currentTimeMillis();
            logger.debug((Object)MessageFormat.format("handler: {0}, gridDataEntity , cost: {1}", this.getClass().getName(), end - start));
        }
        if (totalCount <= 0L) {
            helper.fillData0(excelConfig, null);
            return;
        }
        if (totalCount > 1000000L) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "max_over"));
        }
        int fetchTimes = (int)(totalCount / (long)rows) + 1;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("handler: {0},totalCount:{1} fetchTimes:{2},per count: {3}", this.getClass().getName(), totalCount, fetchTimes, rows));
        }
        GridDataEntity gridDataEntity = null;
        for (int i = 0; i < fetchTimes; ++i) {
            if (logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            userData.put("rows", (Boolean)((Object)Integer.valueOf(rows)));
            userData.put("page", (Boolean)((Object)Integer.valueOf(page++)));
            if (i == fetchTimes - 1) {
                userData.put("isLastTime", true);
            }
            request.setAttribute("_userData_", userData);
            gridDataEntity = this.dataGrid.getEntityEditGridDataAll(request, modelMap);
            listData = gridDataEntity.getRows();
            if (logger.isDebugEnabled()) {
                end = System.currentTimeMillis();
                logger.debug((Object)MessageFormat.format("handler: {0}, fetchTime\uff1a{1} , getGridRequestData cost: {2}", this.getClass().getName(), i, end - start));
                start = System.currentTimeMillis();
            }
            listDataAll.addAll(listData);
            listData = null;
            gridDataEntity = null;
        }
        this.afterGetExportData(request, response, listDataAll);
        if (logger.isDebugEnabled()) {
            end = System.currentTimeMillis();
            logger.debug((Object)MessageFormat.format("handler: {0} ,afterGetExportData cost: {1}", this.getClass().getName(), end - start));
            start = System.currentTimeMillis();
        }
        helper.fillData0(excelConfig, listDataAll);
        if (logger.isDebugEnabled()) {
            end = System.currentTimeMillis();
            logger.debug((Object)MessageFormat.format("handler: {0} ,fillData0 cost: {2}", this.getClass().getName(), end - start));
        }
    }

    protected void afterGetExportData(HttpServletRequest request, HttpServletResponse response, List listData) throws SHRWebException {
    }

    protected Map<String, Object> initExportExcelConfig(HttpServletRequest request, ExportHelper helper) throws SHRWebException {
        Map<String, Object> params = helper.assembleHandleParam(request);
        return helper.createExcel(request, params);
    }

    protected final void setFilterBySelectedData(HttpServletRequest request, ModelMap modelMap) {
        String fieldName_key = request.getParameter("fieldName_key");
        if (StringUtils.isEmpty((String)fieldName_key)) {
            return;
        }
        String selectedData = request.getParameter("selectedData");
        StringBuilder sb = new StringBuilder();
        sb.append(fieldName_key);
        sb.append("  in (");
        sb.append("'");
        sb.append(selectedData.replace(",", "','"));
        sb.append("'");
        sb.append(")");
        modelMap.put((Object)"filter", (Object)sb.toString());
    }

    protected boolean isUserNewExportQueryAll() {
        return true;
    }

    protected final boolean isRequestJSON(HttpServletRequest request) {
        String value = request.getHeader("Accept");
        return value != null && value.contains("application/json");
    }

    protected IShrFieldPermForm fieldPermInit(HttpServletRequest request) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        SelectorItemCollection selector = this.getSelectors(request);
        UIViewInfo uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        ShrFieldPermForm shrFieldPerm = new ShrFieldPermForm(ctx, selector, uiViewInfo.getEntityName(), uiViewInfo.isHasEditGrid());
        try {
            selector = shrFieldPerm.addNeedSelect();
            request.setAttribute("request_selector", (Object)new Object[]{super.getUipk(request), selector});
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        return shrFieldPerm;
    }

    protected CoreBaseInfo doFieldPermFilter(IShrFieldPermForm shrFieldPerm, Object operateState, CoreBaseInfo model) throws SHRWebException {
        if (null != shrFieldPerm) {
            try {
                if (null != operateState) {
                    if (operateState.equals("VIEW")) {
                        shrFieldPerm.filterForView(model);
                    } else if (operateState.equals("EDIT")) {
                        shrFieldPerm.filterForEdit(model);
                    } else if (operateState.equals("ADDNEW")) {
                        shrFieldPerm.filterForEdit(model);
                    }
                } else {
                    String method_name = new Exception().getStackTrace()[2].getMethodName();
                    if (method_name.startsWith("edit")) {
                        shrFieldPerm.filterForEdit(model);
                    } else if (method_name.startsWith("addNew")) {
                        shrFieldPerm.filterForEdit(model);
                    } else {
                        shrFieldPerm.filterForView(model);
                    }
                }
            }
            catch (EASBizException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
        }
        return model;
    }

    protected final boolean checkIsShrWfButNoPermitemPermission(HttpServletRequest request) {
        return ShrCheckDataPermissionUtil.checkIsShrWfButNoPermitemPermission(request);
    }

    @Override
    protected void checkDataPermission(HttpServletRequest request, Object obj) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.hasPermissionRuleConfig(request)) {
            return;
        }
        if (this.checkIsShrWfButNoPermitemPermission(request)) {
            return;
        }
        this.checkBizDataPermission(request, obj);
    }

    protected void checkBizDataPermission(HttpServletRequest request, Object obj) throws SHRWebException {
        CoreBaseInfo model;
        PermItemInfo permItemInfo = this.getCurrentRequestPermItem(request);
        if (null != permItemInfo && OrgType.HRO.equals((Object)permItemInfo.getOrgRelation()) && (model = (CoreBaseInfo)obj) instanceof HRBillBaseInfo) {
            HRBillBaseInfo hbb = (HRBillBaseInfo)model;
            if (null == hbb.getHrOrgUnit() || null == hbb.getHrOrgUnit().getId()) {
                return;
            }
            this.checkHROrgUnitDataPermission(request, hbb.getHrOrgUnit().getId().toString());
        }
    }

    public String getFieldCascadeResultAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String paramJson = request.getParameter("param");
        CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
        if (StringUtils.isEmpty((String)paramJson)) {
            return null;
        }
        HashMap param = JSONUtils.convertJsonToObject(this.getContext(), paramJson);
        try {
            Object obj = FieldRuleHelper.getLinkFieldResult(this.getContext(), param, (IObjectValue)model);
            if (null != obj) {
                JSONUtils.writeJson(response, obj);
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        return null;
    }
}

