/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.handler.ISingleRowHandler;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class SingleRowHandler
extends EditHandler
implements ISingleRowHandler {
    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return this.initalizeDataAction(request, response, modelMap);
    }

    @Override
    public String initalizeDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Map params = DynamicUtil.getRequestParameters(request);
        params.put("method", "view");
        String realBillId = this.getSingleRecordId(request);
        if (!StringUtils.isEmpty((String)realBillId)) {
            params.put("billId", realBillId);
        } else {
            params.remove("billId");
            request.setAttribute("InitDataObject", (Object)this.createNewModel(request, response, modelMap));
        }
        String url = DynamicUtil.assembleUrl("/dynamic.do", params);
        return "forward:" + url;
    }

    public String getSingleRecordId(HttpServletRequest request) throws SHRWebException {
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        String relatedFieldId = this.getRelatedFieldId(request, uiViewInfo);
        String relatedField = uiViewInfo.getRelatedField();
        if (relatedField.equalsIgnoreCase("id")) {
            return relatedFieldId;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(relatedField, (Object)relatedFieldId));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        entityViewInfo.setSelector(sic);
        try {
            String view_model = uiViewInfo.getModel();
            CoreBaseCollection collection = MetaDataUtil.getBizInterface(view_model).getCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                CoreBaseInfo info = collection.get(0);
                return info.getId().toString();
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return null;
    }

    protected String getRelatedFieldId(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        String relatedField = uiViewInfo.getRelatedField();
        if (StringUtils.isEmpty((String)relatedField)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "not_set_relatedfield"));
        }
        String relatedFieldId = (String)request.getAttribute("relatedFieldId");
        if (StringUtils.isEmpty((String)relatedFieldId)) {
            relatedFieldId = request.getParameter("relatedFieldId");
        }
        if (StringUtils.isEmpty((String)relatedFieldId)) {
            relatedFieldId = this.getBillId(request);
        }
        return relatedFieldId;
    }

    @Override
    protected CoreBaseInfo createNewModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CoreBaseInfo coreBaseInfo = super.createNewModel(request, response, modelMap);
        this.setRelatedFieldValue(request, coreBaseInfo);
        return coreBaseInfo;
    }

    private void setRelatedFieldValue(HttpServletRequest request, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        String relatedFieldId = request.getParameter("relatedFieldId");
        if (StringUtils.isEmpty((String)relatedFieldId)) {
            return;
        }
        try {
            ICoreBase iCoreBase = MetaDataUtil.getBizInterface(BOSUuid.read((String)relatedFieldId).getType());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CoreBaseInfo info = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(relatedFieldId), sic);
            UIViewInfo uiViewInfo = this.getUIViewInfo(request);
            String relatedField = uiViewInfo.getRelatedField();
            String[] strs = relatedField.split("\\.");
            coreBaseInfo.put(strs[0], (Object)info);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (UuidException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }
}

