/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.plugin;

import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class PluginUtil {
    public static Object invokePluginMethod(List<Object> plugins, String methodName, String suffix, Object ... args) throws SHRWebException {
        if (plugins != null && plugins.size() > 0) {
            Method method = null;
            if (!StringUtils.isEmpty((String)suffix)) {
                methodName = methodName + suffix;
            }
            for (Object plugin : plugins) {
                method = PluginUtil.getPluginMethod(plugin, methodName, args);
                if (method == null) continue;
                try {
                    return PluginUtil.invokeMethod(plugin, method, args);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof SHRWebException) {
                        throw (SHRWebException)e.getTargetException();
                    }
                    throw new SHRWebException(e.getTargetException());
                }
                catch (Exception e) {
                    throw new SHRWebException(e);
                }
            }
        }
        return null;
    }

    public static Method getPluginMethod(Object object, String methodName, Object ... args) {
        Method[] clsMethods;
        for (Method m : clsMethods = object.getClass().getMethods()) {
            Class<?>[] paramsType = null;
            if (!m.getName().equalsIgnoreCase(methodName) || (paramsType = m.getParameterTypes()).length != args.length) continue;
            for (int i = 0; i < paramsType.length; ++i) {
                if (paramsType[i].equals(args[i].getClass())) {
                    return m;
                }
                if (args[i] == null || !paramsType[i].isInstance(args[i])) continue;
                return m;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, Method method, Object ... args) throws Exception {
        return method.invoke(obj, args);
    }
}

