/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class SHRLogUtils {
    public static Map<String, Map<String, String>> getButtonLogConfig(HttpServletRequest request) {
        HashMap<String, Map<String, String>> buttonLogConfigMap;
        block9: {
            buttonLogConfigMap = new HashMap<String, Map<String, String>>();
            String uipk = request.getParameter("uipk");
            if (StringUtils.isEmpty((String)uipk)) {
                uipk = request.getParameter("pUipk");
            }
            if (!StringUtils.isEmpty((String)uipk)) {
                try {
                    UIViewInfo uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
                    if (null == uiViewInfo) {
                        return buttonLogConfigMap;
                    }
                    String content = uiViewInfo.getContent();
                    if (StringUtils.isEmpty((String)content)) {
                        return buttonLogConfigMap;
                    }
                    Element rootElement = null;
                    Document doc = XMLUtil.parseXML(content);
                    rootElement = doc.getRootElement();
                    Element elementToolbar = XMLUtil.getElement(rootElement, "toolbar");
                    if (elementToolbar == null) break block9;
                    List children = elementToolbar.getChildren();
                    Map<String, String> logObjMap = null;
                    for (Element el : children) {
                        if (el.getChildren().size() > 0) {
                            List elements = el.getChildren();
                            for (Element elChild : elements) {
                                String eChildName = elChild.getName();
                                if (eChildName == null || !eChildName.equalsIgnoreCase("button")) continue;
                                SHRLogUtils.assembleLogObjMap(request, elChild, buttonLogConfigMap, logObjMap, uiViewInfo);
                            }
                            continue;
                        }
                        SHRLogUtils.assembleLogObjMap(request, el, buttonLogConfigMap, logObjMap, uiViewInfo);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return buttonLogConfigMap;
    }

    private static void assembleLogObjMap(HttpServletRequest request, Element e, Map<String, Map<String, String>> buttonLogConfigMap, Map<String, String> logObjMap, UIViewInfo uiViewInfo) {
        String actionName = "";
        Attribute buttonCaption = e.getAttribute("caption");
        Attribute buttonName = e.getAttribute("name");
        Attribute buttonLogEnble = e.getAttribute("logenable");
        String method = request.getParameter("method");
        Context ctx = SHRContext.getInstance().getContext();
        HashMap valueMap = new HashMap();
        if (null == buttonLogEnble || "true".equalsIgnoreCase(buttonLogEnble.getValue())) {
            String buttonCaptionAlias;
            if (buttonName != null) {
                actionName = buttonName.getValue();
            }
            String string = buttonCaptionAlias = buttonCaption != null ? buttonCaption.getValue() : actionName;
            if ("save".equalsIgnoreCase(method)) {
                try {
                    valueMap = JSONUtils.convertJsonToObject(ctx, request.getParameter("model"));
                }
                catch (SHRWebException e1) {
                    e1.printStackTrace();
                }
                String id = (String)valueMap.get("id");
                buttonCaptionAlias = StringUtils.isEmpty((String)id) ? SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "addnew") : SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "edit");
            } else if ("submit".equalsIgnoreCase(method)) {
                try {
                    valueMap = JSONUtils.convertJsonToObject(ctx, request.getParameter("model"));
                }
                catch (SHRWebException e1) {
                    e1.printStackTrace();
                }
            } else if ("disable".equalsIgnoreCase(method) || "enable".equalsIgnoreCase(method)) {
                String billId = request.getParameter("billId");
                try {
                    CoreBaseInfo info = MetaDataUtil.getBizInterface(uiViewInfo.getEntityName()).getValue((IObjectPK)new ObjectUuidPK(billId), SHRLogUtils.getSelectors(uiViewInfo));
                    valueMap.put("name", (String)info.get("name"));
                    valueMap.put("number", (String)info.get("number"));
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                catch (SHRWebException e1) {
                    e1.printStackTrace();
                }
            } else if ("delete".equalsIgnoreCase(method)) {
                String logModelStr = request.getParameter("logModel");
                if (logModelStr != null) {
                    List list = (List)JSONUtils.convertJsonToObject(ctx, logModelStr, List.class);
                    List<FieldInfo> fields = uiViewInfo.getFields();
                    StringBuffer names = new StringBuffer();
                    StringBuffer numbers = new StringBuffer();
                    for (int i = 0; i < list.size(); ++i) {
                        LinkedTreeMap object = (LinkedTreeMap)list.get(i);
                        if (object.get((Object)"name") != null) {
                            names.append((String)object.get((Object)"name")).append(",");
                        }
                        if (object.get((Object)"number") == null) continue;
                        numbers.append((String)object.get((Object)"number")).append(",");
                    }
                    if (names.length() > 0) {
                        valueMap.put("name", names.toString());
                    }
                    if (numbers.length() > 0) {
                        valueMap.put("number", numbers.toString());
                    }
                }
            } else if ("print".equalsIgnoreCase(method)) {
                buttonCaptionAlias = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "print");
            } else {
                if ("edit".equalsIgnoreCase(method)) {
                    return;
                }
                if (buttonLogConfigMap.containsKey("exportCurrent") && "exportCurrent".equals(actionName)) {
                    return;
                }
            }
            logObjMap = new HashMap<String, String>();
            logObjMap.put("functionName", SHRLogUtils.assembleLogFunctionName(uiViewInfo));
            logObjMap.put("operate", SHRLogUtils.assembleLogOperate(uiViewInfo, buttonCaptionAlias, valueMap));
            logObjMap.put("operateObj", SHRLogUtils.assembleLogOperateObj(uiViewInfo, buttonCaptionAlias));
            buttonLogConfigMap.put(actionName, logObjMap);
        }
    }

    private static HashMap<String, String> assembleLogOperateObjInfo(String str) {
        String[] array;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (String s : array = str.split(",")) {
            String[] value = s.split(":");
            if (!value[0].substring(1, value[0].length() - 1).equals("id") && !value[0].substring(1, value[0].length() - 1).equals("name") && !value[0].substring(1, value[0].length() - 1).equals("number")) continue;
            valueMap.put(value[0].substring(1, value[0].length() - 1), value[1]);
        }
        return valueMap;
    }

    public static String assembleLogFunctionName(UIViewInfo uiViewInfo) {
        return MessageFormat.format("{0}", uiViewInfo.getPageTitle());
    }

    protected static SelectorItemCollection getSelectors(UIViewInfo uiViewInfo) throws SHRWebException {
        SelectorItemCollection sic = null;
        if (uiViewInfo != null && (sic = uiViewInfo.getSelectors()) == null) {
            sic = UIViewUtil.assembleSelector(uiViewInfo);
            uiViewInfo.setSelectors(sic);
        }
        return sic;
    }

    public static String assembleLogOperateObj(UIViewInfo uiViewInfo, String buttonCaptionAlias) {
        return MessageFormat.format("{0} {1}", uiViewInfo.getViewTitle(), buttonCaptionAlias);
    }

    public static String assembleLogOperate(UIViewInfo uiViewInfo, String buttonCaptionAlias, Map<String, Object> valueMap) {
        if (valueMap.get("name") != null) {
            buttonCaptionAlias = buttonCaptionAlias + "  " + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "name") + ": ";
            buttonCaptionAlias = valueMap.get("name") instanceof String ? buttonCaptionAlias + valueMap.get("name") : buttonCaptionAlias + valueMap.get("name").toString();
        }
        if (valueMap.get("number") != null) {
            buttonCaptionAlias = buttonCaptionAlias + "  " + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "number") + ": " + valueMap.get("number");
        }
        return MessageFormat.format("{0} {1}", uiViewInfo.getViewTitle(), buttonCaptionAlias);
    }

    public static void writeLog(HttpServletRequest request) {
        try {
            IObjectPK pk = SHRLogUtils.doWriteLog(request);
            if (null != pk) {
                LogUtil.afterLog((Context)SHRContext.getInstance().getContext(), (IObjectPK)pk);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IObjectPK doWriteLog(HttpServletRequest request) {
        Map<String, Map<String, String>> logConfig;
        String method = request.getParameter("method");
        String isAllExport = request.getParameter("isAll");
        if (StringUtils.isEmpty((String)isAllExport) && "exportToExcel".equals(method)) {
            method = "exportCurrent";
        }
        if (!StringUtils.isEmpty((String)method) && method.startsWith("import")) {
            method = "showImportPage";
        }
        if ((logConfig = SHRLogUtils.getButtonLogConfig(request)) != null && logConfig.containsKey(method)) {
            Map<String, String> buttonConfig = logConfig.get(method);
            HashMap<String, Object> logParmamObj = SHRLogUtils.assembleLogParamObj(buttonConfig);
            try {
                AppLogFactory.getRemoteInstance().writeLog(logParmamObj);
                return new ObjectUuidPK(BOSUuid.read((String)logParmamObj.get("FID").toString()));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static HashMap<String, Object> assembleLogParamObj(Map<String, String> map) {
        HashMap<String, Object> logDatas = new HashMap<String, Object>();
        String fMethodDescriptionL2 = "";
        if (!StringUtils.isEmpty((String)map.get("operate"))) {
            fMethodDescriptionL2 = map.get("operate").length() > 255 ? map.get("operate").substring(0, 255) : map.get("operate");
        }
        LogServerUtil.setLogInfo(null, (Context)SHRContext.getInstance().getContext(), logDatas);
        logDatas.put("FIsSuccessed", "0");
        logDatas.put("FItemName", "manual_default_logitem");
        logDatas.put("FMethodDescription_L2", fMethodDescriptionL2);
        logDatas.put("FEntityAlias_L2", map.get("functionName"));
        logDatas.put("FInstanceNo", map.get("operateObj"));
        logDatas.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        return logDatas;
    }

    public static IObjectPK doWriteCustomerLog(HttpServletRequest request, String operate, String functionName, String operateObj) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("operate", operate);
        map.put("functionName", functionName);
        map.put("operateObj", operateObj);
        HashMap<String, Object> logParmamObj = SHRLogUtils.assembleLogParamObj(map);
        IObjectPK pk = SHRLogUtils.doWriteLog0(request, logParmamObj);
        if (null != pk) {
            LogUtil.afterLog((Context)SHRContext.getInstance().getContext(), (IObjectPK)pk);
        }
        return pk;
    }

    public static IObjectPK doWriteLog0(HttpServletRequest request, HashMap<String, Object> logParmamObj) {
        try {
            AppLogFactory.getRemoteInstance().writeLog(logParmamObj);
            return new ObjectUuidPK(BOSUuid.read((String)logParmamObj.get("FID").toString()));
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IObjectPK beforeWriteLog(HttpServletRequest request) {
        IObjectPK pk = null;
        try {
            pk = SHRLogUtils.doWriteLog(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pk;
    }

    public static void afterWriteLog(IObjectPK pk) {
        if (null != pk) {
            LogUtil.afterLog((Context)SHRContext.getInstance().getContext(), (IObjectPK)pk);
        }
    }
}

