/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.eas.applet.autoupdate.DownloadTraceInfo;
import com.kingdee.eas.webutil.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class DownloadTraceUtil {
    public static void storeTraceInfo(DownloadTraceInfo traceInfo) {
        Properties prop = DownloadTraceUtil.toProp(traceInfo);
        DownloadTraceUtil.modifyDownLoadFiles(traceInfo.getBaseDir(), traceInfo.getTraceFileName(), prop);
    }

    public static Properties toProp(DownloadTraceInfo traceInfo) {
        Properties properties = new Properties();
        properties.setProperty("downloadCompleted", new Boolean(traceInfo.isDownloadCompleted()).toString());
        properties.setProperty("jnlpVersionFiles", traceInfo.getJnlpVersionFiles());
        properties.setProperty("jnlpVersion", traceInfo.getJnlpVersion());
        properties.setProperty("ondemandjnlpversion", traceInfo.getOndemandjnlpversion());
        properties.setProperty("fulljnlpversion", traceInfo.getFulljnlpversion());
        return properties;
    }

    public static DownloadTraceInfo load(File baseDir, String updateTraceFileName, String jnlpFileBinded) {
        ConsoleLogger.info("load " + baseDir + "," + updateTraceFileName);
        File updatePropertiesFile = new File(baseDir, updateTraceFileName);
        Properties properties = null;
        properties = !updatePropertiesFile.exists() ? DownloadTraceUtil.createDefaultClientUpdateTraceFile(baseDir, updateTraceFileName, jnlpFileBinded) : DownloadTraceUtil.readUpdatePropertiesFile(baseDir, updateTraceFileName);
        DownloadTraceInfo info = DownloadTraceUtil.toTraceInfo(baseDir, updateTraceFileName, properties);
        return info;
    }

    public static DownloadTraceInfo toTraceInfo(File baseDir, String updateTraceFileName, Properties properties) {
        String jnlpVersionFiles = properties.getProperty("jnlpVersionFiles", "eas.jnlp");
        String jnlpVersion = properties.getProperty("jnlpVersion", "5.1.0.0");
        Object object = properties.get("downloadCompleted");
        boolean downloadCompleted = new Boolean((String)object);
        String ondemandjnlpversion = properties.getProperty("ondemandjnlpversion", new Long(0L).toString());
        String fulljnlpversion = properties.getProperty("fulljnlpversion", new Long(0L).toString());
        DownloadTraceInfo info = new DownloadTraceInfo(baseDir, updateTraceFileName, downloadCompleted);
        info.setFulljnlpversion(fulljnlpversion);
        info.setOndemandjnlpversion(ondemandjnlpversion);
        info.setJnlpVersionFiles(jnlpVersionFiles);
        info.setJnlpVersion(jnlpVersion);
        return info;
    }

    public static int getJnlpVersionFilesCount(String jnlpVersionFiles) {
        String[] jnlpVersionFileArray = jnlpVersionFiles.split(",");
        return jnlpVersionFileArray.length;
    }

    public static String getLastestSysVersion(String jnlpVersionFiles) {
        if (jnlpVersionFiles == null) {
            return "";
        }
        String[] tempArray = String.valueOf(jnlpVersionFiles).trim().split(",");
        return tempArray[tempArray.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void modifyDownLoadFiles(File baseDir, String updateTraceFileName, String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try {
            File updateFile = new File(baseDir, updateTraceFileName);
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(updateFile);
            properties.load(inputStream);
            inputStream.close();
            File file = updateFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.put(key, value);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readUpdatePropertiesFile(File baseDir, String updateTraceFileName) {
        File updatePropertiesFile = new File(baseDir, updateTraceFileName);
        Properties properties = new Properties();
        if (updatePropertiesFile.exists()) {
            try {
                FileInputStream inputStream = null;
                File file = updatePropertiesFile;
                synchronized (file) {
                    inputStream = new FileInputStream(updatePropertiesFile);
                }
                properties.load(inputStream);
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void modifyDownLoadFiles(File baseDir, String updateTraceFileName, Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        try {
            File updateFile = new File(baseDir, updateTraceFileName);
            if (!updateFile.exists()) {
                updateFile.createNewFile();
            }
            File file = updateFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Properties createDefaultClientUpdateTraceFile(File baseDir, String updateTraceFileName, String jnlpFileBinded) {
        File defaultClientUpdateTraceFile = new File(baseDir, updateTraceFileName);
        Properties properties = new Properties();
        if (defaultClientUpdateTraceFile.exists()) {
            defaultClientUpdateTraceFile.delete();
        }
        if (jnlpFileBinded == null || "" == jnlpFileBinded) {
            jnlpFileBinded = "eas.jnlp";
        }
        try {
            defaultClientUpdateTraceFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(defaultClientUpdateTraceFile);
            properties.setProperty("downloadCompleted", "false");
            properties.setProperty("jnlpVersionFiles", jnlpFileBinded);
            properties.setProperty("jnlpVersion", "5.1.0.0");
            properties.setProperty("ondemandjnlpversion", new Long(0L).toString());
            properties.setProperty("fulljnlpversion", new Long(0L).toString());
            properties.store(outputStream, null);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String refactorJnlpVersionFilesValue(String jnlpVersionFiles, String serverJnlpName) {
        String result = "";
        if (jnlpVersionFiles == null) {
            result = serverJnlpName;
        } else if (serverJnlpName == null) {
            result = jnlpVersionFiles;
        } else {
            String separator = ",";
            String valueOfJnlpFilesAttribute = separator + jnlpVersionFiles.trim() + separator;
            valueOfJnlpFilesAttribute = valueOfJnlpFilesAttribute.replaceAll(separator + serverJnlpName + separator, separator);
            result = valueOfJnlpFilesAttribute.substring(1);
            result = result + serverJnlpName;
        }
        return result;
    }
}

