/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.httpdownload.util;

import com.kingdee.eas.applet.httpdownload.util.DebugLogger;
import com.kingdee.eas.applet.httpdownload.util.NamedRunnable;
import com.kingdee.eas.applet.httpdownload.util.ObjectFIFO;

public class ThreadPoolWorker {
    private static int nextWorkerID = 0;
    private ObjectFIFO idleWorkers;
    private int workerID;
    private ObjectFIFO handoffBox;
    private Thread internalThread;
    private volatile boolean noStopRequested;

    public ThreadPoolWorker(ObjectFIFO idleWorkers) {
        this.idleWorkers = idleWorkers;
        this.workerID = ThreadPoolWorker.getNextWorkerID();
        this.handoffBox = new ObjectFIFO(1);
        this.noStopRequested = true;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    ThreadPoolWorker.this.runWork();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        this.internalThread = new Thread(r);
        this.internalThread.setName("ThreadPoolWorker[" + this.workerID + "] internal Thread");
        this.internalThread.start();
    }

    public static synchronized int getNextWorkerID() {
        int id = nextWorkerID++;
        return id;
    }

    public void process(Runnable target) throws InterruptedException {
        this.handoffBox.add(target);
    }

    private void runWork() {
        while (this.noStopRequested) {
            try {
                this.idleWorkers.add(this);
                NamedRunnable r = (NamedRunnable)this.handoffBox.remove();
                this.runIt(r);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIt(NamedRunnable r) {
        try {
            DebugLogger.getDebugLogger().info("WorkerThread[" + this.workerID + "], starting [" + r.getName() + "]....");
            r.run();
            DebugLogger.getDebugLogger().info("WorkerThread[" + this.workerID + "], [" + r.getName() + "]finished!");
        }
        catch (Exception runex) {
            System.err.println("Uncaught exception fell through from run()");
            runex.printStackTrace();
        }
        finally {
            Thread.interrupted();
        }
    }

    public void stopRequest() {
        DebugLogger.getDebugLogger().info("WorkerThread[" + this.workerID + "], stopRequest() received.");
        this.noStopRequested = false;
        this.internalThread.interrupt();
    }

    public boolean isAlive() {
        return this.internalThread.isAlive();
    }
}

