/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate;

import com.kingdee.bos.autoupdate.LogException;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public final class Logger {
    private static final int INFO = 1;
    private static final int DEBUG = 2;
    private static final int ERROR = 3;
    private static Logger logger;
    private static final String KD_AUTOUPDATE_LOG = "autoupdate.log";
    private PrintStream ps = null;
    private static File fileLog;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Logger getInstance() {
        if (logger == null) {
            try {
                logger = new Logger();
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
        return logger;
    }

    private Logger() throws LogException {
        this.openStream();
    }

    private void openStream() throws LogException {
        try {
            this.ps = new PrintStream(new FileOutputStream(fileLog, true));
        }
        catch (FileNotFoundException fnfe) {
            throw new LogException(fnfe);
        }
    }

    public static File getLogFile() {
        return fileLog;
    }

    public void info(Object o) {
        this.output(1, o);
    }

    public void debug(Object o) {
        this.output(2, o);
    }

    public void error(Object o) {
        this.output(3, o);
    }

    private void output(int type, Object o) {
        if (o == null) {
            return;
        }
        this.ps.print("[" + DateFormat.getDateTimeInstance().format(new Date()) + "] ");
        if (1 == type) {
            this.ps.print("INFO: ");
        } else if (3 == type) {
            this.ps.print("ERROR: ");
        } else if (2 == type && ConfigInfo.isDebug) {
            this.ps.print("DEBUG: ");
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unsupported type[" + type + "]"));
            }
            return;
        }
        if (o instanceof Throwable) {
            ((Throwable)o).printStackTrace(this.ps);
        } else {
            this.ps.print(o);
        }
        if (!(o instanceof String)) {
            this.ps.println();
        } else {
            String tmp = (String)o;
            if (tmp.lastIndexOf(10) < 0) {
                this.ps.println();
            }
        }
        this.ps.flush();
    }

    static {
        $assertionsDisabled = !Logger.class.desiredAssertionStatus();
        logger = null;
        fileLog = ConfigManager.getConfigFile(KD_AUTOUPDATE_LOG);
    }
}

