/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.cache;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.Logger;
import com.kingdee.bos.autoupdate.cache.CacheEntryInfo;
import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.cache.CacheUpdateListener;
import com.kingdee.bos.autoupdate.cache.JNLPCacheEntryInfo;
import com.kingdee.bos.autoupdate.cache.LocalCachedEntryManager;
import com.kingdee.bos.autoupdate.dl.RSDownloader;
import com.kingdee.bos.autoupdate.dl.RSDownloaderFactory;
import com.kingdee.bos.autoupdate.jnl.JARInfo;
import com.kingdee.bos.autoupdate.jnl.JNLParser;
import com.kingdee.bos.autoupdate.jnl.JREInfo;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.NativeLibInfo;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.autoupdate.jnl.ResourceCollection;
import com.kingdee.bos.autoupdate.jnl.ResourceInfo;
import com.kingdee.bos.autoupdate.util.FileUtil;
import com.kingdee.bos.autoupdate.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CacheUpdater {
    private final URL jnlp;
    private final File baseDir;
    private final List _listeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CacheUpdater(String jnlpUrl, String localPath) throws CacheException {
        if (!($assertionsDisabled || jnlpUrl != null && localPath != null)) {
            throw new AssertionError();
        }
        try {
            this.jnlp = URLUtil.getURL(null, jnlpUrl);
        }
        catch (MalformedURLException mle) {
            throw new CacheException("Invalidate url " + jnlpUrl, mle);
        }
        this.baseDir = new File(localPath);
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        if (!this.baseDir.isDirectory()) {
            throw new CacheException("Invalidate localPath[" + localPath + "]");
        }
    }

    public CacheUpdater(URL jnlp, File baseDir) {
        this.jnlp = jnlp;
        this.baseDir = baseDir;
    }

    public CacheState getCacheState() throws CacheException {
        return new CacheStateImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(CacheUpdateListener dListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(dListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheUpdateListener[] getUpdateListeners() {
        List list = this._listeners;
        synchronized (list) {
            return this._listeners.toArray(new CacheUpdateListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(CacheUpdateListener dListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(dListener);
        }
    }

    public synchronized LaunchInfo update() throws JNLPException {
        CacheState cacheState = this.getCacheState();
        URL codebase = cacheState.getCodebase();
        if (cacheState.isNeedUpdate()) {
            int i;
            int len;
            Iterator it;
            CacheUpdateListener[] listeners = this.getUpdateListeners();
            if (cacheState.isLocalNoCache()) {
                // empty if block
            }
            if (cacheState.isJnlpModified()) {
                it = cacheState.getDeletedResources().iterator();
                CacheEntryInfo entry = null;
                File localFile = null;
                while (it.hasNext()) {
                    entry = (CacheEntryInfo)it.next();
                    localFile = new File(this.baseDir, URLUtil.getRelativePath(cacheState.getCodebase(), entry.getHref()));
                    localFile.delete();
                    len = listeners.length;
                    for (i = 0; i < len; ++i) {
                        listeners[i].deleteResource(entry.getHref(), localFile);
                    }
                    Logger.getInstance().info("Delete cached file: " + localFile.toString());
                }
            }
            it = cacheState.getUpdatedResources().iterator();
            ArrayList<URL> urls = new ArrayList<URL>();
            while (it.hasNext()) {
                urls.add(((CacheEntryInfo)it.next()).getHref());
            }
            RSDownloader downloader = RSDownloaderFactory.getRSDownloader(this.jnlp.getProtocol());
            downloader.download(cacheState.getCodebase(), this.toURLs(urls), this.baseDir);
            len = listeners.length;
            for (i = 0; i < len; ++i) {
                listeners[i].updateResource(this.toURLs(urls), this.toFiles(urls, codebase));
            }
            LocalCachedEntryManager.store(this.baseDir, cacheState.getServerCacheEntryInfo());
        }
        File jnlpFile = new File(this.baseDir, URLUtil.getRelativePath(cacheState.getCodebase(), this.jnlp));
        return JNLParser.parse(jnlpFile);
    }

    private URL[] toURLs(List list) {
        return list.toArray(new URL[0]);
    }

    private File[] toFiles(List list, URL codebase) {
        URL[] aUrl = this.toURLs(list);
        File[] files = new File[aUrl.length];
        for (int i = 0; i < aUrl.length; ++i) {
            files[i] = new File(this.baseDir, URLUtil.getRelativePath(codebase, aUrl[i]));
        }
        return files;
    }

    private void clearLocalCache() {
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
            return;
        }
        FileUtil.deleteFiles(this.baseDir, false);
    }

    static {
        $assertionsDisabled = !CacheUpdater.class.desiredAssertionStatus();
    }

    class CacheStateImpl
    implements CacheState {
        private boolean isJnlpModified;
        private boolean isLocalNoCache;
        private boolean isNeedUpdate;
        private final List dirtyResources = new ArrayList();
        private final List deletedResources = new ArrayList();
        private final RSDownloader downloader;
        private JNLPCacheEntryInfo serverCache = null;
        private JNLPCacheEntryInfo localCache = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        CacheStateImpl() throws CacheException {
            this.downloader = RSDownloaderFactory.getRSDownloader(CacheUpdater.this.jnlp.getProtocol());
            this.localCache = LocalCachedEntryManager.load(CacheUpdater.this.baseDir);
            if (this.localCache == null) {
                this.isNeedUpdate = true;
                this.isLocalNoCache = true;
                this.fetchAllResources();
            } else {
                try {
                    if (!CacheUpdater.this.jnlp.toString().equalsIgnoreCase(this.localCache.getHref().toString())) {
                        System.out.println("serverJNLP: " + CacheUpdater.this.jnlp);
                        System.out.println("localJNLP: " + this.localCache.getHref());
                        this.isNeedUpdate = true;
                        this.isJnlpModified = true;
                        this.fetchAllResources();
                        return;
                    }
                    long jnlpLastModified = this.downloader.lastModified(this.localCache.getHref());
                    if (jnlpLastModified != this.localCache.lastModified()) {
                        this.isNeedUpdate = true;
                        this.isJnlpModified = true;
                        this.fetchAllResources();
                        this.dirtyResources.clear();
                        this.compare(this.localCache, this.serverCache);
                    } else {
                        List localCacheEntries = this.localCache.getCacheEntries();
                        int localCacheEntriesCount = localCacheEntries.size();
                        long[] localFilesLastModified = new long[localCacheEntriesCount];
                        long[] serverFilesLastModified = null;
                        URL[] localFilesURL = new URL[localCacheEntriesCount];
                        CacheEntryInfo localRS = null;
                        int i = 0;
                        Iterator it = localCacheEntries.iterator();
                        while (it.hasNext()) {
                            localRS = (CacheEntryInfo)it.next();
                            localFilesLastModified[i] = localRS.lastModified();
                            localFilesURL[i] = localRS.getHref();
                            ++i;
                        }
                        serverFilesLastModified = this.downloader.lastModified(localFilesURL);
                        this.serverCache = this.deepCopy(this.localCache);
                        for (i = 0; i < localCacheEntriesCount; ++i) {
                            if (localFilesLastModified[i] == serverFilesLastModified[i]) continue;
                            this.isNeedUpdate = true;
                            this.dirtyResources.add(localCacheEntries.get(i));
                            ((CacheEntryInfo)this.serverCache.getCacheEntries().get(i)).setLastModified(serverFilesLastModified[i]);
                        }
                    }
                }
                catch (MalformedURLException mle) {
                    throw new CacheException(mle);
                }
                catch (IOException ioe) {
                    throw new CacheException(ioe);
                }
            }
        }

        public File getBaseDir() {
            return CacheUpdater.this.baseDir;
        }

        public URL getCodebase() {
            return this.getServerCacheEntryInfo().getCodebase();
        }

        public List getUpdatedResources() {
            return this.dirtyResources;
        }

        public boolean isJnlpModified() {
            return this.isJnlpModified;
        }

        public boolean isLocalNoCache() {
            return this.isLocalNoCache;
        }

        public boolean isNeedUpdate() {
            return this.isNeedUpdate;
        }

        public JNLPCacheEntryInfo getLocalCacheEntryInfo() {
            return this.localCache;
        }

        public JNLPCacheEntryInfo getServerCacheEntryInfo() {
            return this.serverCache;
        }

        private void fetchAllResources() throws CacheException {
            try {
                InputStream is = this.downloader.getContent(CacheUpdater.this.jnlp);
                LaunchInfo launch = JNLParser.parse(is);
                long jnlpLastModified = this.downloader.lastModified(CacheUpdater.this.jnlp);
                this.serverCache = new JNLPCacheEntryInfo(launch.getCodebase(), launch.getHref(), jnlpLastModified);
                ArrayList<JNLPCacheEntryInfo> urls = new ArrayList<JNLPCacheEntryInfo>();
                urls.add(this.serverCache);
                this.dirtyResources.add(this.serverCache);
                ResourceCollection resources = launch.getResources();
                this.fillResource(this.serverCache, resources, urls);
            }
            catch (IOException ioe) {
                throw new CacheException(ioe);
            }
            catch (ParseException pe) {
                throw new CacheException(pe);
            }
        }

        private void fillResource(JNLPCacheEntryInfo cache, ResourceCollection resources, List urls) throws IOException {
            ResourceInfo[] res = resources.getResources();
            CacheEntryInfo cacheEntry = null;
            for (int i = 0; i < res.length; ++i) {
                if (res[i] instanceof JARInfo || res[i] instanceof NativeLibInfo) {
                    cacheEntry = new CacheEntryInfo(res[i].getHref(), this.downloader.lastModified(res[i].getHref()));
                    cache.addCacheEntry(cacheEntry);
                    this.dirtyResources.add(cacheEntry);
                    continue;
                }
                if (!(res[i] instanceof JREInfo)) continue;
            }
        }

        private void compare(JNLPCacheEntryInfo localCache, JNLPCacheEntryInfo serverCache) {
            if (!($assertionsDisabled || localCache != null && serverCache != null)) {
                throw new AssertionError();
            }
            Map localResources = this.getCacheInfos(localCache);
            this.checkResource(localResources, serverCache);
            Iterator<Object> it = serverCache.getCacheEntries().iterator();
            CacheEntryInfo entry = null;
            while (it.hasNext()) {
                entry = (CacheEntryInfo)it.next();
                this.checkResource(localResources, entry);
            }
            if (!localResources.isEmpty()) {
                it = localResources.entrySet().iterator();
                while (it.hasNext()) {
                    this.deletedResources.add(((Map.Entry)it.next()).getValue());
                }
            }
        }

        private void checkResource(Map entries, CacheEntryInfo serverEntry) {
            String href = URLUtil.getRelativePath(this.serverCache.getCodebase(), serverEntry.getHref());
            CacheEntryInfo entry = null;
            if (entries.containsKey(href)) {
                entry = (CacheEntryInfo)entries.get(href);
                if (entry.lastModified() != serverEntry.lastModified()) {
                    this.dirtyResources.add(entry);
                }
                entries.remove(href);
            } else {
                this.dirtyResources.add(serverEntry);
            }
        }

        private JNLPCacheEntryInfo deepCopy(JNLPCacheEntryInfo cache) {
            if (!$assertionsDisabled && cache == null) {
                throw new AssertionError();
            }
            JNLPCacheEntryInfo tmp = new JNLPCacheEntryInfo(cache.getCodebase(), cache.getHref(), cache.lastModified());
            Iterator it = cache.getCacheEntries().iterator();
            CacheEntryInfo entry = null;
            while (it.hasNext()) {
                entry = (CacheEntryInfo)it.next();
                tmp.addCacheEntry(new CacheEntryInfo(entry.getHref(), entry.lastModified()));
            }
            return tmp;
        }

        public List getDeletedResources() {
            return this.deletedResources;
        }

        private Map getCacheInfos(JNLPCacheEntryInfo cacheEntry) {
            HashMap<String, CacheEntryInfo> map = new HashMap<String, CacheEntryInfo>();
            map.put(URLUtil.getRelativePath(cacheEntry.getCodebase(), cacheEntry.getHref()), cacheEntry);
            Iterator it = cacheEntry.getCacheEntries().iterator();
            CacheEntryInfo entry = null;
            while (it.hasNext()) {
                entry = (CacheEntryInfo)it.next();
                map.put(URLUtil.getRelativePath(cacheEntry.getCodebase(), entry.getHref()), entry);
            }
            return map;
        }

        static {
            $assertionsDisabled = !(class$com$kingdee$bos$autoupdate$cache$CacheUpdater == null ? (class$com$kingdee$bos$autoupdate$cache$CacheUpdater = CacheUpdater.class$("com.kingdee.bos.autoupdate.cache.CacheUpdater")) : class$com$kingdee$bos$autoupdate$cache$CacheUpdater).desiredAssertionStatus();
        }
    }

    static interface CacheState {
        public boolean isLocalNoCache();

        public boolean isNeedUpdate();

        public boolean isJnlpModified();

        public List getUpdatedResources();

        public List getDeletedResources();

        public URL getCodebase();

        public File getBaseDir();

        public JNLPCacheEntryInfo getLocalCacheEntryInfo();

        public JNLPCacheEntryInfo getServerCacheEntryInfo();
    }
}

