/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.cache;

import com.kingdee.bos.autoupdate.cache.CacheEntryInfo;
import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.cache.CacheUpdater;
import com.kingdee.bos.autoupdate.cache.JNLPCacheEntryInfo;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.bos.autoupdate.xml.INode;
import com.kingdee.bos.autoupdate.xml.NodeFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import nanoxml.XMLParseException;

public final class LocalCachedEntryManager {
    static final String CACHED_ENTRIES_FILE = "kdjnlp.entries";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JNLPCacheEntryInfo load(File baseDir) throws CacheException {
        JNLPCacheEntryInfo jNLPCacheEntryInfo;
        File file = new File(baseDir, CACHED_ENTRIES_FILE);
        if (!file.exists()) {
            return null;
        }
        BufferedInputStream bos = null;
        try {
            try {
                bos = new BufferedInputStream(new FileInputStream(file));
                jNLPCacheEntryInfo = LocalCachedEntryManager.innerLoad(bos);
                Object var5_6 = null;
            }
            catch (IOException ioe) {
                throw new CacheException(ioe);
            }
            catch (XMLParseException pe) {
                throw new CacheException(pe);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (bos == null) throw throwable;
                bos.close();
                throw throwable;
            }
            catch (Exception ignore) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ignore) {
            // empty catch block
            return jNLPCacheEntryInfo;
        }
        if (bos == null) return jNLPCacheEntryInfo;
        bos.close();
        return jNLPCacheEntryInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void store(File baseDir, JNLPCacheEntryInfo cache) throws CacheException {
        INode root = NodeFactory.createNode("localCache");
        root.setAttribute("codebase", cache.getCodebase().toString());
        root.setAttribute("href", URLUtil.getRelativePath(cache.getCodebase(), cache.getHref()).toString());
        root.setAttribute("lastModified", new Long(cache.lastModified()).toString());
        CacheEntryInfo entry = null;
        INode entryNode = null;
        Iterator it = cache.getCacheEntries().iterator();
        while (it.hasNext()) {
            entry = (CacheEntryInfo)it.next();
            entryNode = NodeFactory.createNode("resource");
            entryNode.setAttribute("href", URLUtil.getRelativePath(cache.getCodebase(), entry.getHref()).toString());
            entryNode.setAttribute("lastModified", new Long(entry.lastModified()).toString());
            root.addChild(entryNode);
        }
        OutputStreamWriter writer = null;
        try {
            try {
                File file = new File(baseDir, CACHED_ENTRIES_FILE);
                writer = new FileWriter(file);
                root.write(writer);
                writer.flush();
            }
            catch (IOException ioe) {
                throw new CacheException(ioe);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        if (writer == null) return;
        writer.close();
        return;
    }

    static JNLPCacheEntryInfo innerLoad(InputStream fis) throws CacheException {
        try {
            INode root = NodeFactory.build(fis);
            if (root == null) {
                throw new CacheException("Invalidate kdjnlp.entries file");
            }
            if (!$assertionsDisabled && !"localCache".equals(root.getNodeName())) {
                throw new AssertionError();
            }
            JNLPCacheEntryInfo entry = LocalCachedEntryManager.buildJnlpCacheEntry(root);
            LocalCachedEntryManager.buildResources(root, entry);
            return entry;
        }
        catch (IOException ioe) {
            throw new CacheException("Invalidate kdjnlp.entries file", ioe);
        }
    }

    private static JNLPCacheEntryInfo buildJnlpCacheEntry(INode root) throws CacheException {
        try {
            String codebase = root.getAttribute("codebase");
            String href = root.getAttribute("href");
            String lastModified = root.getAttribute("lastModified");
            if (!($assertionsDisabled || href != null && lastModified != null && codebase != null)) {
                throw new AssertionError();
            }
            URL codebaseURL = URLUtil.getURL(null, codebase);
            return new JNLPCacheEntryInfo(codebaseURL, URLUtil.getURL(codebaseURL, href), Long.parseLong(lastModified));
        }
        catch (MalformedURLException urle) {
            throw new CacheException("Invalidate url", urle);
        }
    }

    private static void buildResources(INode root, JNLPCacheEntryInfo cache) throws CacheException {
        INode[] resources = root.getChildNodes();
        int len = resources.length;
        for (int i = 0; i < len; ++i) {
            cache.addCacheEntry(LocalCachedEntryManager.buildResource(resources[i], cache.getCodebase()));
        }
    }

    private static CacheEntryInfo buildResource(INode resource, URL codebase) throws CacheException {
        try {
            String href = resource.getAttribute("href");
            String lastModified = resource.getAttribute("lastModified");
            if (!($assertionsDisabled || href != null && lastModified != null)) {
                throw new AssertionError();
            }
            return new CacheEntryInfo(URLUtil.getURL(codebase, href), Long.parseLong(lastModified));
        }
        catch (MalformedURLException mle) {
            throw new CacheException(mle);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0 || args[0] == null || args[0] == null) {
            System.out.println("LocalCacheEntryManager ");
            System.out.println("\tparam  jnlpUrl");
            System.out.println("\tparam  localPath");
            return;
        }
        String jnlpPath = args[0];
        String localPath = args[1];
        CacheUpdater updater = new CacheUpdater(jnlpPath, localPath);
        CacheUpdater.CacheState cacheState = updater.getCacheState();
        LocalCachedEntryManager.store(new File(localPath), cacheState.getServerCacheEntryInfo());
    }

    static {
        $assertionsDisabled = !LocalCachedEntryManager.class.desiredAssertionStatus();
    }
}

