/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.dl;

import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.dl.RSDownloadListener;
import com.kingdee.bos.autoupdate.dl.RSDownloader;
import com.kingdee.bos.autoupdate.util.URLUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRSDownloader
implements RSDownloader {
    protected final List _listeners = new ArrayList(5);
    protected static final int BUF_SIZE = 8192;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractRSDownloader() {
    }

    public void download(URL codebase, URL serverURL, File rootPath) throws DownloadException {
        this.download(codebase, new URL[]{serverURL}, rootPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRSDownloadListener(RSDownloadListener dListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(dListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RSDownloadListener[] getRSDownloadListeners() {
        List list = this._listeners;
        synchronized (list) {
            return this._listeners.toArray(new RSDownloadListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRSDownloadListener(RSDownloadListener dListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(dListener);
        }
    }

    protected void download(URL url, long length, InputStream input, OutputStream output) throws IOException {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError((Object)"url cannot be null!");
        }
        if (!$assertionsDisabled && length <= 0L) {
            throw new AssertionError((Object)"file length must great than 0");
        }
        if (!($assertionsDisabled || output != null && input != null)) {
            throw new AssertionError((Object)"input and output stream cannot be null!");
        }
        int read = 0;
        long totalRead = 0L;
        byte[] cache = new byte[8192];
        this.notifyListeners(url, length, 0L);
        while ((read = input.read(cache)) != -1) {
            output.write(cache, 0, read);
            this.notifyListeners(url, length, totalRead += (long)read);
        }
    }

    /*
     * Loose catch block
     */
    public void download(URL codebase, URL[] serverURLs, File rootPath) throws DownloadException {
        if (codebase == null || serverURLs == null || rootPath == null) {
            throw new NullPointerException("the parameter cannot be null!");
        }
        URL resource = null;
        File localFile = null;
        BufferedOutputStream output = null;
        InputStream input = null;
        int len = serverURLs.length;
        for (int i = 0; i < len; ++i) {
            resource = serverURLs[i];
            localFile = this.getLocalFile(codebase, resource, rootPath);
            File tmp = localFile.getParentFile();
            if (tmp != null) {
                tmp.mkdirs();
            }
            output = new BufferedOutputStream(new FileOutputStream(localFile));
            input = this.getContent(resource);
            this.download(resource, this.getContentLength(resource), input, output);
            output.flush();
            Object var13_11 = null;
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (input == null) continue;
                input.close();
            }
            catch (Exception ignore) {}
            continue;
            {
                catch (FileNotFoundException fnfe) {
                    if (localFile != null) {
                        localFile.delete();
                    }
                    throw new DownloadException(fnfe);
                }
                catch (IOException ioe) {
                    if (localFile != null) {
                        localFile.delete();
                    }
                    throw new DownloadException(ioe);
                }
            }
            catch (Throwable throwable) {
                var13_11 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void download(URL codebase, URL resource, InputStream input, File rootPath) throws DownloadException {
        File localFile = null;
        FilterOutputStream output = null;
        try {
            localFile = this.getLocalFile(codebase, resource, rootPath);
            File tmp = localFile.getParentFile();
            if (tmp != null) {
                tmp.mkdirs();
            }
            output = new BufferedOutputStream(new FileOutputStream(localFile));
            this.download(resource, this.getContentLength(resource), input, output);
        }
        catch (FileNotFoundException fnfe) {
            localFile.delete();
            throw new DownloadException(fnfe);
        }
        catch (IOException ioe) {
            localFile.delete();
            throw new DownloadException(ioe);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ignore) {}
            try {
                input.close();
            }
            catch (Exception ignore) {}
        }
    }

    private File getLocalFile(URL codebase, URL resource, File localFile) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        String relativePath = this.getRelativePath(codebase, resource);
        return new File(localFile, relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(URL url, long length, long totalRead) {
        RSDownloadListener[] listeners = this.getRSDownloadListeners();
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            RSDownloadListener rSDownloadListener = listeners[i];
            synchronized (rSDownloadListener) {
                if (totalRead == 0L) {
                    listeners[i].beginDownload(url);
                    listeners[i].downloadProgress(url, length, totalRead);
                } else if (totalRead == length) {
                    listeners[i].downloadProgress(url, length, totalRead);
                    listeners[i].finishDownload(url);
                } else {
                    listeners[i].downloadProgress(url, length, totalRead);
                }
                continue;
            }
        }
    }

    public long[] lastModified(URL[] urls) throws IOException {
        if (!$assertionsDisabled && urls == null) {
            throw new AssertionError();
        }
        long[] filesLastModified = new long[urls.length];
        int len = urls.length;
        for (int i = 0; i < len; ++i) {
            filesLastModified[i] = this.lastModified(urls[i]);
        }
        return filesLastModified;
    }

    protected String getRelativePath(URL codebase, URL resource) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        String codebasePath = codebase.getPath();
        String resourcePath = resource.getPath();
        if (codebasePath.length() == 0) {
            return resourcePath;
        }
        if (resourcePath.startsWith(codebasePath)) {
            return resourcePath.substring(codebasePath.length());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("invalidate codebase[" + codebasePath + "] and resource[" + resourcePath + "]"));
        }
        return null;
    }

    protected String URL2Path(URL url) {
        return URLUtil.getPathFromURL(url);
    }

    static {
        $assertionsDisabled = !AbstractRSDownloader.class.desiredAssertionStatus();
    }
}

