/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.dl;

import com.kingdee.bos.autoupdate.config.ConfigException;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import com.kingdee.bos.autoupdate.dl.AbstractRSDownloader;
import com.kingdee.bos.autoupdate.util.BASE64Encoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class RSDownloaderHttpImpl
extends AbstractRSDownloader {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent(URL url) throws IOException {
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        cn = this.getConnection(url);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new HttpInputStream(cn.getInputStream(), (HttpURLConnection)cn));
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength(URL url) throws IOException {
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        try {
            cn = this.getConnection(url);
            long l = cn.getContentLength();
            return l;
        }
        finally {
            if (cn instanceof HttpURLConnection) {
                try {
                    ((HttpURLConnection)cn).disconnect();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified(URL url) throws IOException {
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        try {
            cn = this.getConnection(url);
            long l = cn.getLastModified();
            return l;
        }
        finally {
            if (cn instanceof HttpURLConnection) {
                try {
                    ((HttpURLConnection)cn).disconnect();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    private URLConnection getConnection(URL url) throws IOException {
        try {
            URLConnection uc = url.openConnection();
            this.addToRequestProperty(uc, "pragma", "no-cache");
            ConfigInfo configInfo = ConfigManager.load();
            if (configInfo.isNeedProxy()) {
                if (!$assertionsDisabled && configInfo.getProxyPort() <= 0) {
                    throw new AssertionError();
                }
                Properties properties = System.getProperties();
                properties.put("http.proxyHost", configInfo.getProxyServerUrl());
                properties.put("http.proxyPort", new Integer(configInfo.getProxyPort()).toString());
                uc.setRequestProperty("Proxy-Authorization", this.encodeUserNameAndPassword(configInfo.getProxyUserName(), configInfo.getProxyPassword()));
            }
            if (configInfo.isNeedBaseAuth()) {
                uc.setRequestProperty("Authorization", this.encodeUserNameAndPassword(configInfo.getBaseAuthUserName(), configInfo.getBaseAuthPassword()));
            }
            return uc;
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            throw new IOException("Invalidate Config! " + ce.getMessage());
        }
    }

    private String encodeUserNameAndPassword(String userName, String password) {
        return "Basic " + BASE64Encoder.base64Encode(userName + ":" + password);
    }

    private void addToRequestProperty(URLConnection conn, String key, String value) {
        String curvalue = conn.getRequestProperty(key);
        curvalue = curvalue == null || curvalue.trim().length() == 0 ? value : curvalue + "," + value;
        conn.setRequestProperty(key, curvalue);
    }

    static {
        $assertionsDisabled = !RSDownloaderHttpImpl.class.desiredAssertionStatus();
    }

    private static class HttpInputStream
    extends InputStream {
        private final InputStream is;
        private final HttpURLConnection httpCn;

        public HttpInputStream(InputStream is, HttpURLConnection httpCn) {
            this.is = is;
            this.httpCn = httpCn;
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            try {
                this.httpCn.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean equals(Object arg0) {
            return this.is.equals(arg0);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        public void mark(int arg0) {
            this.is.mark(arg0);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] arg0) throws IOException {
            return this.is.read(arg0);
        }

        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.is.read(arg0, arg1, arg2);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long arg0) throws IOException {
            return this.is.skip(arg0);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

