/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.ui;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.Launch;
import com.kingdee.bos.autoupdate.ResourceManager;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import com.kingdee.bos.autoupdate.ui.ConfigDialog;
import com.kingdee.bos.autoupdate.ui.Console;
import com.kingdee.bos.autoupdate.ui.ExceptionHandler;
import com.kingdee.bos.autoupdate.ui.InvalidInputException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class Main {
    private static final String MAIN_FRAME_TITLE = "MAIN_FRAME_TITLE";
    private static final String MAIN_FRAME_JNLP_URL = "MAIN_FRAME_JNLP_URL";
    private static final String MAIN_FRAME_LOCAL_PATH_URL = "MAIN_FRAME_LOCAL_PATH_URL";
    private static final String MAIN_FRAME_CONFIG = "MAIN_FRAME_CONFIG";
    private static final String MAIN_FRAME_OK = "MAIN_FRAME_OK";
    private static final String MAIN_FRAME_CANCEL = "MAIN_FRAME_CANCEL";
    JFrame mainFrame = new JFrame();
    JLabel jlbServerUrl = new JLabel();
    JTextField tfServerUrl = new JTextField();
    JLabel jlbLocalUrl = new JLabel();
    JTextField tfLocalUrl = new JTextField();
    JButton jbConfig = new JButton();
    JButton jbOk = new JButton();
    JButton jbCancel = new JButton();
    final JDialog dialog;
    static final Console console = new Console();

    public Main() {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.jbInit();
        this.dialog = new ConfigDialog(this.mainFrame, true);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation(d.width / 2 - this.mainFrame.getWidth() / 2, d.height / 2 - this.mainFrame.getHeight() / 2);
        try {
            ConfigInfo info = ConfigManager.load();
            this.tfServerUrl.setText(info.getLastJnlpUrl());
            this.tfLocalUrl.setText(info.getLastLocalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        console.show();
    }

    private void jbInit() {
        this.mainFrame.getContentPane().setLayout(null);
        this.jlbServerUrl.setText(ResourceManager.getString(MAIN_FRAME_JNLP_URL));
        this.jlbServerUrl.setBounds(new Rectangle(10, 10, 120, 15));
        this.tfServerUrl.setText("");
        this.tfServerUrl.setBounds(new Rectangle(135, 7, 250, 22));
        this.tfLocalUrl.setText("");
        this.jlbLocalUrl.setText(ResourceManager.getString(MAIN_FRAME_LOCAL_PATH_URL));
        this.jlbLocalUrl.setBounds(new Rectangle(10, 40, 120, 15));
        this.tfLocalUrl.setBounds(new Rectangle(135, 37, 250, 22));
        this.jbConfig.setText(ResourceManager.getString(MAIN_FRAME_CONFIG));
        this.jbConfig.setBounds(new Rectangle(135, 67, 80, 22));
        this.jbConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.mainFrame.hide();
                Main.this.dialog.show();
            }
        });
        this.jbOk.setText(ResourceManager.getString(MAIN_FRAME_OK));
        this.jbOk.setBounds(new Rectangle(220, 67, 80, 22));
        this.jbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String jnlpUrl = Main.this.tfServerUrl.getText().trim();
                    String localPath = Main.this.tfLocalUrl.getText().trim();
                    if (jnlpUrl.length() == 0 || localPath.length() == 0) {
                        throw new InvalidInputException("jnlpUrl or localPath cannoe be null!");
                    }
                    try {
                        ConfigInfo configInfo = ConfigManager.load();
                        configInfo.setLastJnlpUrl(jnlpUrl);
                        configInfo.setLastLocalPath(localPath);
                        ConfigManager.store(configInfo);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    Launch.launch(jnlpUrl, localPath);
                    System.exit(0);
                }
                catch (JNLPException le) {
                    ExceptionHandler.handle(le);
                }
            }
        });
        this.jbCancel.setText(ResourceManager.getString(MAIN_FRAME_CANCEL));
        this.jbCancel.setBounds(new Rectangle(305, 67, 80, 22));
        this.jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.mainFrame.getContentPane().add((Component)this.tfServerUrl, null);
        this.mainFrame.getContentPane().add((Component)this.tfLocalUrl, null);
        this.mainFrame.getContentPane().add((Component)this.jlbServerUrl, null);
        this.mainFrame.getContentPane().add((Component)this.jlbLocalUrl, null);
        this.mainFrame.getContentPane().add((Component)this.jbConfig, null);
        this.mainFrame.getContentPane().add((Component)this.jbOk, null);
        this.mainFrame.getContentPane().add((Component)this.jbCancel, null);
        this.mainFrame.setSize(405, 125);
        this.mainFrame.setTitle(ResourceManager.getString(MAIN_FRAME_TITLE));
        this.mainFrame.addWindowListener(new WL());
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.mainFrame.setVisible(true);
    }

    static class WL
    extends WindowAdapter {
        WL() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

