/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ksql.shell;

import com.kingdee.bos.ksql.shell.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    private String driverName;
    private String dbType;
    private String originalURL;

    public synchronized java.sql.Connection connect(String url, Properties info) throws SQLException {
        if (!url.startsWith("jdbc:ksql:")) {
            return null;
        }
        this.parseURL(url);
        try {
            Class.forName(this.driverName);
            java.sql.Connection cn = DriverManager.getConnection(this.originalURL, info);
            Connection connection = new Connection(cn, this.dbType);
            return connection;
        }
        catch (ClassNotFoundException ce) {
            throw new SQLException(String.valueOf(String.valueOf(new StringBuffer("Class ").append(this.driverName).append(" Not Found"))));
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:ksql");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private void parseURL(String url) throws SQLException {
        StringTokenizer st = new StringTokenizer(url, ":");
        String str = st.nextToken();
        if (!str.equalsIgnoreCase("jdbc")) {
            throw new SQLException("invalid url");
        }
        str = st.nextToken();
        if (!str.equalsIgnoreCase("ksql")) {
            throw new SQLException("invalid url");
        }
        this.driverName = st.nextToken();
        str = st.nextToken();
        this.dbType = str.substring(str.indexOf(61) + 1);
        if (this.dbType == null) {
            throw new SQLException("you must set dbtype");
        }
        if (!(this.dbType.equalsIgnoreCase("oracle") || this.dbType.equalsIgnoreCase("db2") || this.dbType.equalsIgnoreCase("mssqlserver"))) {
            throw new SQLException(String.valueOf(String.valueOf(new StringBuffer("invalid dbtype[").append(this.dbType).append("]"))));
        }
        if (this.dbType.equalsIgnoreCase("mssqlserver")) {
            this.dbType = "sqlserver";
        }
        this.originalURL = st.nextToken(" ").substring(1);
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

