/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialIndicator;
import com.kingdee.bos.ctrl.swing.dial.DialNeedle;
import com.kingdee.bos.ctrl.swing.dial.DialPan;
import com.kingdee.bos.ctrl.swing.dial.DialScale;
import com.kingdee.bos.ctrl.swing.dial.DialTitle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicDial
extends JComponent {
    protected static final int DEFAULTSIZE = 1;
    protected List needles;
    protected List scales;
    protected DialPan pan;
    protected List indicators;
    protected DialTitle title;
    protected transient ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$0;

    public BasicDial() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(133, 90));
    }

    public void setValue(int index, Object value) {
        DialNeedle ndl = this.getNeedle(index);
        if (ndl != null) {
            ndl.setValue(value);
            this.fireStateChanged();
            this.repaint();
        }
    }

    public Object getValue(int index) {
        Object ret = null;
        DialNeedle ndl = this.getNeedle(index);
        if (ndl != null) {
            ret = ndl.getValue();
        }
        return ret;
    }

    public void setValue(Object key, Object value) {
        DialNeedle ndl = this.getNeedle(key);
        if (ndl != null) {
            ndl.setValue(value);
            this.fireStateChanged();
            this.repaint();
        }
    }

    public Object getValue(Object key) {
        Object ret = null;
        DialNeedle ndl = this.getNeedle(key);
        if (ndl != null) {
            ret = ndl.getValue();
        }
        return ret;
    }

    public void setValue(Object value) {
        this.setValue(0, value);
    }

    public Object getValue() {
        return this.getValue(0);
    }

    public void addNeedle(DialNeedle needle, Object key) {
        NeedleItem item = new NeedleItem(key, needle);
        if (this.needles == null) {
            this.needles = new ArrayList(1);
        }
        this.needles.add(item);
    }

    public void removeNeedle(Object key) {
        this.removeElement(key, this.needles);
    }

    public void removeNeedle(int index) {
        this.removeElement(index, this.needles);
    }

    public DialNeedle getNeedle(Object key) {
        NeedleItem item = (NeedleItem)this.getElement(key, this.needles);
        if (item != null) {
            return item.needle;
        }
        return null;
    }

    public DialNeedle getNeedle(int index) {
        NeedleItem item = (NeedleItem)this.getElement(index, this.needles);
        if (item != null) {
            return item.needle;
        }
        return null;
    }

    public int getNeedlesCount() {
        return this.getElementsCount(this.needles);
    }

    public void addScale(DialScale scale, Object key) {
        ScaleItem item = new ScaleItem(key, scale);
        if (this.scales == null) {
            this.scales = new ArrayList(1);
        }
        this.scales.add(item);
    }

    public void removeScale(Object key) {
        this.removeElement(key, this.scales);
    }

    public void removeScale(int index) {
        this.removeElement(index, this.scales);
    }

    public DialScale getScale(Object key) {
        ScaleItem item = (ScaleItem)this.getElement(key, this.scales);
        if (item != null) {
            return item.scale;
        }
        return null;
    }

    public DialScale getScale(int index) {
        ScaleItem item = (ScaleItem)this.getElement(index, this.scales);
        if (item != null) {
            return item.scale;
        }
        return null;
    }

    public int getScalesCount() {
        return this.getElementsCount(this.scales);
    }

    public void addIndicator(DialIndicator indicator, Object key) {
        indicator.install(this);
        IndicatorItem item = new IndicatorItem(key, indicator);
        if (this.indicators == null) {
            this.indicators = new ArrayList(1);
        }
        this.indicators.add(item);
    }

    public void removeIndicator(Object key) {
        DialIndicator indr = this.getIndicator(key);
        if (indr != null) {
            indr.dismiss();
            this.removeElement(key, this.indicators);
        }
    }

    public void removeIndicator(int index) {
        DialIndicator indr = this.getIndicator(index);
        if (indr != null) {
            indr.dismiss();
            this.removeElement(index, this.indicators);
        }
    }

    public DialIndicator getIndicator(Object key) {
        IndicatorItem item = (IndicatorItem)this.getElement(key, this.indicators);
        if (item != null) {
            return item.indicator;
        }
        return null;
    }

    public DialIndicator getIndicator(int index) {
        IndicatorItem item = (IndicatorItem)this.getElement(index, this.indicators);
        if (item != null) {
            return item.indicator;
        }
        return null;
    }

    public int getIndicatorsCount() {
        return this.getElementsCount(this.indicators);
    }

    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, width, height);
        }
        Insets ins = this.getInsets();
        Rectangle area = new Rectangle(ins.top, ins.left, width -= ins.left + ins.right, height -= ins.top + ins.bottom);
        if (this.pan != null) {
            this.pan.draw(g, area, this);
        }
        ScaleItem si = null;
        IndicatorItem ii = null;
        NeedleItem ni = null;
        if (this.scales != null) {
            i = 0;
            while (i < this.scales.size()) {
                si = (ScaleItem)this.scales.get(i);
                si.scale.draw(g, area, this);
                ++i;
            }
        }
        if (this.indicators != null) {
            i = 0;
            while (i < this.indicators.size()) {
                ii = (IndicatorItem)this.indicators.get(i);
                ii.indicator.draw(g, area, this);
                ++i;
            }
        }
        if (this.needles != null) {
            i = 0;
            while (i < this.needles.size()) {
                ni = (NeedleItem)this.needles.get(i);
                ni.needle.draw(g, area, this);
                ++i;
            }
        }
        this.drawTitle(g2);
    }

    protected void drawTitle(Graphics2D g2) {
        this.setToolTipText(this.generateToolTip());
        AffineTransform oldTrans = g2.getTransform();
        DialTitle ttl = this.getTitle();
        if (ttl != null) {
            Point pt = this.getTitle().getLocation();
            g2.translate(pt.x, pt.y);
            ttl.paint(g2);
            g2.setTransform(oldTrans);
        }
    }

    protected String generateToolTip() {
        StringBuffer tip = new StringBuffer();
        Format ft = null;
        Object val = null;
        int count = this.getNeedlesCount();
        int i = 0;
        while (i < count) {
            DialNeedle ndl = this.getNeedle(i);
            DialScale scl = ndl.getScale();
            if (scl != null) {
                tip.append(scl.getCaption());
                tip.append(":");
                val = ndl.getValue();
                ft = scl.getTickLabelFormat();
                if (ft != null) {
                    tip.append(ft.format(val));
                } else {
                    tip.append(val.toString());
                }
                tip.append(" ");
            }
            ++i;
        }
        return tip.toString();
    }

    private int indexOf(Object key, List list) {
        int index = -1;
        QueuedItem item = null;
        int i = 0;
        while (i < list.size()) {
            item = (QueuedItem)list.get(i);
            if (item.key.equals(key)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    protected void removeElement(Object key, List list) {
        if (list == null) {
            return;
        }
        int i = this.indexOf(key, list);
        if (i < 0) {
            return;
        }
        list.remove(i);
    }

    protected void removeElement(int index, List list) {
        if (list == null) {
            return;
        }
        list.remove(index);
    }

    protected Object getElement(Object key, List list) {
        if (list == null) {
            return null;
        }
        int i = this.indexOf(key, list);
        if (i < 0) {
            return null;
        }
        return this.needles.get(i);
    }

    protected Object getElement(int index, List list) {
        if (list == null) {
            return null;
        }
        return list.get(index);
    }

    protected int getElementsCount(List elems) {
        if (elems != null) {
            return elems.size();
        }
        return 0;
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public ChangeListener[] getChangeListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public DialPan getPan() {
        return this.pan;
    }

    public void setPan(DialPan p) {
        this.pan = p;
    }

    public DialTitle getTitle() {
        return this.title;
    }

    public void setTitle(DialTitle t) {
        if (this.title != null) {
            this.remove(this.title);
        }
        if (t != null) {
            this.title = t;
            this.add(t);
        }
    }

    public BufferedImage createBufferedImage() {
        int width = this.getSize().width;
        int height = this.getSize().height;
        BufferedImage image = null;
        if (width > 0 && height > 0) {
            image = new BufferedImage(width, height, 2);
            Graphics2D g2 = image.createGraphics();
            if (!this.isOpaque()) {
                Color old = g2.getColor();
                g2.setColor(new Color(255, 255, 255, 0));
                g2.fillRect(0, 0, width, height);
                g2.setColor(old);
            }
            this.paint(g2);
            g2.dispose();
        }
        return image;
    }

    protected abstract class QueuedItem {
        public Object key;

        protected QueuedItem() {
        }

        public String toString() {
            String str = this.key + "(" + this.getClass() + ")";
            return str;
        }
    }

    protected class NeedleItem
    extends QueuedItem {
        public DialNeedle needle;

        public NeedleItem(Object k, DialNeedle n) {
            this.key = k;
            this.needle = n;
        }
    }

    protected class ScaleItem
    extends QueuedItem {
        public DialScale scale;

        public ScaleItem(Object k, DialScale s) {
            this.key = k;
            this.scale = s;
        }
    }

    protected class IndicatorItem
    extends QueuedItem {
        public DialIndicator indicator;

        public IndicatorItem(Object k, DialIndicator indic) {
            this.key = k;
            this.indicator = indic;
        }
    }
}

