/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.BasicDial;
import com.kingdee.bos.ctrl.swing.dial.DialIndicator;
import com.kingdee.bos.ctrl.swing.dial.DialNeedle;
import com.kingdee.bos.ctrl.swing.dial.DialPan;
import com.kingdee.bos.ctrl.swing.dial.DialScale;
import com.kingdee.bos.ctrl.swing.dial.DialTitle;
import com.kingdee.bos.ctrl.swing.dial.ImageDial;
import com.kingdee.bos.ctrl.swing.dial.ImageNeedle;
import com.kingdee.bos.ctrl.swing.dial.ImagePan;
import com.kingdee.bos.ctrl.swing.dial.ImageScale;
import com.kingdee.bos.ctrl.swing.dial.KpiDial;
import com.kingdee.bos.ctrl.swing.dial.KpiNeedle;
import com.kingdee.bos.ctrl.swing.dial.KpiPan;
import com.kingdee.bos.ctrl.swing.dial.KpiRange;
import com.kingdee.bos.ctrl.swing.dial.KpiScale;
import com.kingdee.bos.ctrl.swing.dial.KpiTitle;
import com.kingdee.bos.ctrl.swing.dial.resource.DialResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Map;

public class DialFactory {
    private static final String DEFAULTKEY = "0";
    private static final String KPIDIAL_PAN_NAME = "kpidial_pan.gif";
    private static final String KPIDIAL_TOPPAN_NAME = "kpidial_toppan.gif";
    private static final String KPIDIAL_NEEDLE_NAME = "kpidial_needle.gif";

    public static BasicDial createSimpleDial(KpiRange range, String title) {
        BasicDial dial = DialFactory.createKpiDial(range, null, null, null, title);
        ((KpiScale)dial.getScale(0)).setDefaultPaint(DialResourceManager.getKpiScaleNormalColor(""));
        return dial;
    }

    public static BasicDial createKpiDial(KpiRange range, KpiRange normal, KpiRange warning, KpiRange critical, String title) {
        KpiPan bottomPan = new KpiPan();
        KpiNeedle ndl = new KpiNeedle();
        DecimalFormat ft = new DecimalFormat("###'%'");
        KpiScale scl = new KpiScale(null, 0, 0, 180);
        scl.setTicksPaint(Color.GRAY);
        scl.setTickLabelPaint(Color.WHITE);
        scl.setTickLabelFormat(ft);
        scl.setTotalRange(range);
        scl.setNormalRange(normal);
        scl.setWarningRange(warning);
        scl.setCriticalRange(critical);
        scl.setNormalPaint(DialResourceManager.getKpiScaleNormalColor(""));
        scl.setWarningPaint(DialResourceManager.getKpiScaleWarningColor(""));
        scl.setCriticalPaint(DialResourceManager.getKpiScaleCriticalColor(""));
        KpiTitle ttl = new KpiTitle(title);
        ndl.setScale(scl);
        KpiDial dial = new KpiDial();
        dial.addNeedle(ndl, DEFAULTKEY);
        dial.addScale(scl, DEFAULTKEY);
        dial.setPan(bottomPan);
        dial.setTitle(ttl);
        dial.setSize(dial.getPreferredSize());
        return dial;
    }

    public static BasicDial createImageDial(KpiRange range, KpiRange normal, KpiRange warning, KpiRange critical, String title) {
        BufferedImage img = DialResourceManager.getImage(KPIDIAL_PAN_NAME);
        ImagePan bottomPan = new ImagePan(img);
        Dimension size = new Dimension(img.getWidth(), img.getHeight());
        img = DialResourceManager.getImage(KPIDIAL_TOPPAN_NAME);
        ImagePan topPan = new ImagePan(img);
        img = DialResourceManager.getImage(KPIDIAL_NEEDLE_NAME);
        ImageNeedle ndl = new ImageNeedle(DialResourceManager.getPanAxle(""), DialResourceManager.getNeedleRadius(""));
        ndl.setAxleOnMe(DialResourceManager.getNeedleAxle(""));
        ndl.setImage(img);
        DecimalFormat ft = new DecimalFormat("###'%'");
        ImageScale scl = new ImageScale(DialResourceManager.getPanAxle(""), DialResourceManager.getScaleOuterRadius(""), DialResourceManager.getScaleStartAngle(""), DialResourceManager.getScaleArc(""));
        scl.setTickLength(DialResourceManager.getScaleOuterRadius("") - DialResourceManager.getScaleInnerRadius(""));
        scl.setTicksPaint(Color.GRAY);
        scl.setTickLabelPaint(Color.WHITE);
        scl.setTickLabelFormat(ft);
        scl.setMinimumValue(new Double(range.getLowerBound()));
        scl.setMaximumValue(new Double(range.getUpperBound()));
        scl.setNormalRange(normal);
        scl.setWarningRange(warning);
        scl.setCriticalRange(critical);
        scl.setNormalPaint(DialResourceManager.getKpiScaleNormalColor(""));
        scl.setWarningPaint(DialResourceManager.getKpiScaleWarningColor(""));
        scl.setCriticalPaint(DialResourceManager.getKpiScaleCriticalColor(""));
        DialTitle ttl = new DialTitle(title, DialResourceManager.getTitleRect(""));
        ndl.setScale(scl);
        ImageDial dial = new ImageDial();
        dial.addNeedle(ndl, DEFAULTKEY);
        dial.addScale(scl, DEFAULTKEY);
        dial.setPan(bottomPan);
        dial.setTopPan(topPan);
        dial.setTopPanRect(DialResourceManager.getTopPanRect(""));
        dial.setPreferredSize(size);
        dial.setSize(size);
        dial.setTitle(ttl);
        return dial;
    }

    public static BasicDial createComplexDial(Object[][] needles, Object[][] scales, Map needleToScale, Object[][] indicators, DialPan pan, String title) {
        DialScale scl;
        DialNeedle ndl;
        Object key;
        int i = 0;
        while (i < needles.length) {
            key = needles[i][0];
            ndl = (DialNeedle)needles[i][1];
            key = needleToScale.get(key);
            scl = DialFactory.getScale(scales, key);
            ndl.setScale(scl);
            ++i;
        }
        BasicDial dial = new BasicDial();
        int i2 = 0;
        while (i2 < needles.length) {
            key = needles[i2][0];
            ndl = (DialNeedle)needles[i2][1];
            dial.addNeedle(ndl, key);
            ++i2;
        }
        i2 = 0;
        while (i2 < scales.length) {
            key = scales[i2][0];
            scl = (DialScale)scales[i2][1];
            dial.addScale(scl, key);
            ++i2;
        }
        i2 = 0;
        while (i2 < indicators.length) {
            key = indicators[i2][0];
            DialIndicator ind = (DialIndicator)indicators[i2][1];
            dial.addIndicator(ind, key);
            ++i2;
        }
        dial.setPan(pan);
        dial.setPreferredSize(new Dimension(200, 200));
        DialTitle t = new DialTitle(title, 0, 170, 100, 19);
        dial.setTitle(t);
        return dial;
    }

    private static DialScale getScale(Object[][] scales, Object key) {
        if (key == null) {
            return null;
        }
        DialScale scl = null;
        int i = 0;
        while (i < scales.length) {
            if (key.equals(scales[i][0])) {
                scl = (DialScale)scales[i][1];
            }
            ++i;
        }
        return scl;
    }
}

