/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialGraduateFormula;

public class DialGraduator {
    protected double vminimum;
    protected double u;
    protected DialGraduateFormula formula = this.createFormula();

    protected DialGraduateFormula createFormula() {
        return new DialGraduateLinearFormula();
    }

    public double getAngle(Object value) {
        double logicPos = 0.0;
        logicPos = value == null ? this.vminimum : this.formula.getLogicPosition(value);
        return this.getAngleBy(logicPos);
    }

    public void setParameters(Object vmin, Object vmax, double as) {
        this.vminimum = this.formula.getLogicPosition(vmin);
        double vmaximum = this.formula.getLogicPosition(vmax);
        this.u = vmaximum == this.vminimum ? 0.0 : as / (vmaximum - this.vminimum);
    }

    protected double getAngleBy(double logicval) {
        return (logicval - this.vminimum) * this.u;
    }

    public static class DialGraduateLinearFormula
    implements DialGraduateFormula {
        public double getLogicPosition(Object value) {
            if (value instanceof Number) {
                Number num = (Number)value;
                return num.doubleValue();
            }
            System.out.println("warning: value is not a Number!");
            return 0.0;
        }
    }

    public static class DialGraduateLogFormula
    implements DialGraduateFormula {
        public double getLogicPosition(Object value) {
            if (value instanceof Number) {
                Number num = (Number)value;
                return StrictMath.log(num.doubleValue());
            }
            System.out.println("warning: value is not a Number!");
            return 0.0;
        }
    }
}

