/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.ButtonModel;
import com.kingdee.bos.web.anole.controls.KDAbstractButton;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ButtonGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector buttons = new Vector();
    protected ButtonModel selection = null;
    protected String name = String.valueOf(System.currentTimeMillis());

    public void add(KDAbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.addElement(b);
        if (b.isSelected()) {
            if (this.selection == null) {
                this.selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }

    public void remove(KDAbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.removeElement(b);
        if (b.getModel() == this.selection) {
            this.selection = null;
        }
        b.getModel().setGroup(null);
    }

    public Enumeration getElements() {
        return this.buttons.elements();
    }

    public ButtonModel getSelection() {
        return this.selection;
    }

    public void setSelected(ButtonModel m, boolean b) {
        if (b && m != null && m != this.selection) {
            ButtonModel oldSelection = this.selection;
            this.selection = m;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            m.setSelected(true);
        }
    }

    public boolean isSelected(ButtonModel m) {
        return m == this.selection;
    }

    public int getButtonCount() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.size();
    }

    public String getName() {
        return this.name;
    }
}

