/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.Document;
import com.kingdee.bos.web.anole.controls.KDTextComponent;
import com.kingdee.bos.web.anole.controls.PlainDocument;
import com.kingdee.bos.web.anole.plaf.TextUI;

public class KDTextArea
extends KDTextComponent {
    private static final String uiClassID = "TextAreaUI";
    private static final int DEFAULT_ROWS = 5;
    private static final int DEFALUT_COLS = 10;
    private int rows;
    private int columns;
    private int columnWidth;
    private int rowHeight;
    private boolean wrap;
    private boolean word;

    public KDTextArea() {
        this(null, null, 5, 10);
    }

    public KDTextArea(String text) {
        this(null, text, 0, 0);
    }

    public KDTextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public KDTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public KDTextArea(Document doc) {
        this(doc, null, 0, 0);
    }

    public KDTextArea(Document doc, String text, int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        if (doc == null) {
            doc = this.createDefaultModel();
        }
        this.setDocument(doc);
        if (text != null) {
            this.setText(text);
        }
        if (rows < 0) {
            rows = 1;
        }
        if (columns < 0) {
            columns = 1;
        }
    }

    public int getLength() {
        return this.getColumns();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (columns != oldVal) {
            this.columns = columns;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        int oldVal = this.columns;
        if (rows < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (rows != oldVal) {
            this.rows = rows;
        }
    }

    public boolean getLineWrap() {
        return this.wrap;
    }

    public void setLineWrap(boolean wrap) {
        boolean old = this.wrap;
        this.wrap = wrap;
        this.firePropertyChange("lineWrap", old, wrap);
    }

    public boolean getWrapStyleWord() {
        return this.word;
    }

    public void setWrapStyleWord(boolean word) {
        boolean old = this.word;
        this.word = word;
        this.firePropertyChange("wrapStyleWord", old, word);
    }

    public void updateUI() {
        this.setUI((TextUI)this.UIManager.getUI(this));
    }
}

