/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.event;

import com.kingdee.bos.web.anole.controls.KDWindow;
import java.util.EventObject;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class WindowEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int WINDOW_FIRST = 200;
    public static final int WINDOW_OPENED = 200;
    public static final int WINDOW_CLOSING = 201;
    public static final int WINDOW_CLOSED = 202;
    public static final int WINDOW_ICONIFIED = 203;
    public static final int WINDOW_DEICONIFIED = 204;
    public static final int WINDOW_ACTIVATED = 205;
    public static final int WINDOW_DEACTIVATED = 206;
    public static final int WINDOW_GAINED_FOCUS = 207;
    public static final int WINDOW_LOST_FOCUS = 208;
    public static final int WINDOW_STATE_CHANGED = 209;
    public static final int WINDOW_LAST = 209;
    private transient KDWindow opposite;
    private int oldState;
    private int newState;
    private int id;

    public WindowEvent(KDWindow source, int id, KDWindow opposite, int oldState, int newState) {
        super(source);
        this.opposite = opposite;
        this.oldState = oldState;
        this.newState = newState;
    }

    public WindowEvent(KDWindow source, int id, KDWindow opposite) {
        this(source, id, opposite, 0, 0);
    }

    public WindowEvent(KDWindow source, int id, int oldState, int newState) {
        this(source, id, null, oldState, newState);
    }

    public WindowEvent(KDWindow source, int id) {
        this(source, id, null, 0, 0);
    }

    public KDWindow getWindow() {
        return this.source instanceof KDWindow ? (KDWindow)this.source : null;
    }

    public KDWindow getOppositeWindow() {
        if (this.opposite == null) {
            return null;
        }
        return SunToolkit.targetToAppContext(this.opposite) == AppContext.getAppContext() ? this.opposite : null;
    }

    public int getOldState() {
        return this.oldState;
    }

    public int getNewState() {
        return this.newState;
    }

    public String paramString() {
        String typeStr;
        switch (this.id) {
            case 200: {
                typeStr = "WINDOW_OPENED";
                break;
            }
            case 201: {
                typeStr = "WINDOW_CLOSING";
                break;
            }
            case 202: {
                typeStr = "WINDOW_CLOSED";
                break;
            }
            case 203: {
                typeStr = "WINDOW_ICONIFIED";
                break;
            }
            case 204: {
                typeStr = "WINDOW_DEICONIFIED";
                break;
            }
            case 205: {
                typeStr = "WINDOW_ACTIVATED";
                break;
            }
            case 206: {
                typeStr = "WINDOW_DEACTIVATED";
                break;
            }
            case 207: {
                typeStr = "WINDOW_GAINED_FOCUS";
                break;
            }
            case 208: {
                typeStr = "WINDOW_LOST_FOCUS";
                break;
            }
            case 209: {
                typeStr = "WINDOW_STATE_CHANGED";
                break;
            }
            default: {
                typeStr = "unknown type";
            }
        }
        return String.valueOf(typeStr) + ",opposite=" + this.getOppositeWindow() + ",oldState=" + this.oldState + ",newState=" + this.newState;
    }
}

