/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.layout;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.KDContainer;
import com.kingdee.bos.web.anole.layout.LayoutManager;
import com.kingdee.bos.web.anole.layout.data.GridData;
import com.kingdee.bos.web.anole.layout.render.GridLayoutRenderFactory;
import com.kingdee.bos.web.anole.layout.render.ILayoutRender;
import com.kingdee.bos.web.anole.style.Dimension;

public class GridLayout
implements LayoutManager {
    private int hgap;
    private int vgap;
    private int rows;
    private int cols;
    protected KDContainer container;

    public GridLayout() {
        this(1, 1, 0, 0);
    }

    public GridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public GridLayout(int rows, int cols, int hgap, int vgap) {
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, KDComponent comp) {
    }

    public void removeLayoutComponent(KDComponent comp) {
    }

    public Dimension preferredLayoutSize(KDContainer parent) {
        return null;
    }

    public Dimension minimumLayoutSize(KDContainer parent) {
        return null;
    }

    public void layoutContainer(KDContainer parent) {
        this.container = parent;
        int icount = parent.getComponentCount();
        if (icount > 0) {
            int index = 0;
            KDComponent[] comps = parent.getComponents();
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    KDComponent c = comps[index];
                    GridData gd = new GridData();
                    gd.setRows(i);
                    gd.setColumns(j);
                    c.setLayoutData(gd);
                    if (++index >= icount) {
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ILayoutRender getRender() {
        return GridLayoutRenderFactory.getGridLayoutRender(this.container.getAppInstance().getBrowserCaps());
    }
}

