/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.output;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OutputElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NONE_CLOSE = 0;
    public static final int USE_FULL_CLOSE = 1;
    public static final int USE_PART_CLOSE = 2;
    private String name = null;
    private String text = null;
    private String id = null;
    private Map attributes = null;
    private List contents = null;
    private boolean whitespaceRelevant = false;
    private boolean sticky = false;
    private int closingTagRequired = 1;

    public OutputElement() {
        this("NewElement", 0);
    }

    public OutputElement(String name) {
        this(name, 1);
    }

    public OutputElement(String name, int closingTagRequired) {
        this.name = name;
        this.closingTagRequired = closingTagRequired;
    }

    public void add(OutputElement element) {
        if (this.contents == null) {
            this.contents = new ArrayList();
        }
        this.contents.add(element);
    }

    public void add(int index, OutputElement element) {
        if (this.contents == null) {
            this.contents = new ArrayList();
        }
        this.contents.add(index, element);
    }

    public void addAttribute(String attr) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attr, null);
    }

    public void addAttribute(String attr, int value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attr, Integer.toString(value));
    }

    public void addAttribute(String attr, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attr, value);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OutputElement getElement(int index) {
        OutputElement e = null;
        if (this.contents != null && index < this.contents.size()) {
            e = (OutputElement)this.contents.get(index);
        }
        return e;
    }

    public int getChildrenCount() {
        if (this.contents == null) {
            return 0;
        }
        return this.contents.size();
    }

    public OutputElement[] getElements() {
        OutputElement[] arrE = null;
        if (this.contents != null && this.contents.size() > 0) {
            arrE = new OutputElement[this.contents.size()];
            int i = 0;
            while (i < this.contents.size()) {
                arrE[i] = (OutputElement)this.contents.get(i);
                ++i;
            }
        }
        return arrE;
    }

    public void setClosingTagRequired(int closingTagRequired) {
        this.closingTagRequired = closingTagRequired;
    }

    public void render(PrintWriter pw) {
        this.pRender(pw);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void pRender(PrintWriter pw) {
        this.printHeader(pw);
        this.printBody(pw);
        this.printFooter(pw);
    }

    private void printHeader(PrintWriter pw) {
        if (this.name != null && !this.name.equals("NewElement") && !this.name.equals("")) {
            pw.print("<" + this.name);
            if (this.attributes != null && !this.attributes.isEmpty()) {
                Iterator s = this.attributes.keySet().iterator();
                String strKey = "";
                String strValue = "";
                while (s.hasNext()) {
                    strKey = (String)s.next();
                    Object o = this.attributes.get(strKey);
                    if (o != null) {
                        strValue = (String)o;
                        pw.print(" " + strKey + "=\"" + strValue + "\"");
                        continue;
                    }
                    pw.print(" " + strKey);
                }
            }
            if (this.closingTagRequired == 2) {
                pw.print("/>\n");
            } else {
                pw.print(">\n");
            }
        }
    }

    private void printBody(PrintWriter pw) {
        this.printText(pw);
        this.printChildren(pw);
    }

    private void printFooter(PrintWriter pw) {
        if (this.closingTagRequired == 1) {
            pw.println("</" + this.name + ">\n");
        }
    }

    private void printText(PrintWriter pw) {
        if (this.text != null) {
            pw.print(this.text);
        }
    }

    private void printChildren(PrintWriter pw) {
        if (this.contents != null && !this.contents.isEmpty()) {
            OutputElement e = null;
            int icount = this.contents.size();
            int i = 0;
            while (i < icount) {
                e = this.getElement(i);
                e.render(pw);
                ++i;
            }
        }
    }
}

