/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.plaf.html;

import com.kingdee.bos.web.anole.controls.KDButton;
import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.image.ImageIcon;
import com.kingdee.bos.web.anole.output.OutputElement;
import com.kingdee.bos.web.anole.plaf.ButtonUI;
import java.beans.PropertyChangeEvent;

public class HtmlButtonUI
extends ButtonUI {
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void paint(KDComponent c) {
        super.paint(c);
        KDButton btn = (KDButton)c;
        OutputElement element = null;
        switch (btn.getButtonStyle()) {
            case 0: {
                element = this.CommonButtonRender(btn);
                break;
            }
            case 1: {
                element = this.LinkButtonRender(btn);
            }
        }
        this.renderChildren(btn, element);
        this.parentElement.add(element);
    }

    protected OutputElement LinkButtonRender(KDButton btn) {
        OutputElement element = new OutputElement("a");
        element.addAttribute("name", btn.getIdentifier());
        element.addAttribute("id", btn.getIdentifier());
        element.addAttribute("align", this.convertAlign(btn.getHorizontalAlignment()));
        element.addAttribute("href", "#");
        this.estimateHasEvent(btn, element);
        element.setText(btn.getText());
        return element;
    }

    protected OutputElement CommonButtonRender(KDButton btn) {
        OutputElement element = new OutputElement("input", 0);
        element.addAttribute("name", btn.getIdentifier());
        element.addAttribute("id", btn.getIdentifier());
        element.addAttribute("align", this.convertAlign(btn.getHorizontalAlignment()));
        this.estimateEnabled(btn, element);
        this.estimateHasEvent(btn, element);
        if (btn.getIcon() != null) {
            ImageIcon icon = (ImageIcon)btn.getIcon();
            element.addAttribute("alt", btn.getText());
            element.addAttribute("src", String.valueOf(icon.getDescription()) + "." + "kdpng");
            element.addAttribute("width", icon.getIconWidth());
            element.addAttribute("height", icon.getIconHeight());
        } else {
            element.addAttribute("type", "button");
            element.addAttribute("value", btn.getText());
        }
        return element;
    }

    protected void estimateDefaultButton(KDButton btn, OutputElement element) {
        if (btn.isDefaultButton()) {
            element.addAttribute("type", "submit");
        } else {
            element.addAttribute("type", "button");
        }
    }
}

