/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.plaf.wml;

import com.kingdee.bos.web.anole.controls.KDButton;
import com.kingdee.bos.web.anole.controls.KDComboBox;
import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.KDFrame;
import com.kingdee.bos.web.anole.controls.KDLabel;
import com.kingdee.bos.web.anole.controls.KDList;
import com.kingdee.bos.web.anole.controls.KDRadioButton;
import com.kingdee.bos.web.anole.controls.KDRootPane;
import com.kingdee.bos.web.anole.controls.KDTextComponent;
import com.kingdee.bos.web.anole.controls.KDToggleButton;
import com.kingdee.bos.web.anole.output.OutputElement;
import com.kingdee.bos.web.anole.plaf.RootPaneUI;
import com.kingdee.bos.web.anole.utils.GroupList;
import java.util.ArrayList;
import java.util.Iterator;

public class WmlRootPaneUI
extends RootPaneUI {
    private GroupList arrValuableComps = new GroupList();
    private ArrayList arrButtonComps = new ArrayList();

    public void paint(KDComponent c) {
        super.paint(c);
        KDRootPane rootPane = (KDRootPane)c;
        KDFrame frame = (KDFrame)rootPane.getParent();
        OutputElement element = new OutputElement("card");
        element.addAttribute("id", "main");
        element.addAttribute("title", frame.getTitle());
        this.preLoadControls(rootPane);
        this.addEnterForwardEvent(element, frame);
        this.addDoElement(frame, element);
        element.add(this.createContentPane(rootPane));
        this.parentElement.add(element);
        this.addPostCard(frame, this.parentElement);
    }

    private OutputElement createContentPane(KDRootPane rootPane) {
        KDComponent contentPane = (KDComponent)rootPane.getContentPane();
        OutputElement contentE = new OutputElement("p");
        contentPane.getLayout().layoutContainer(contentPane);
        this.renderChildren(contentPane, contentE);
        return contentE;
    }

    private void addEnterForwardEvent(OutputElement body, KDFrame w) {
        OutputElement eForward = new OutputElement("onevent");
        eForward.addAttribute("type", "onenterforward");
        OutputElement eRefresh = new OutputElement("refresh");
        String[] keys = this.arrValuableComps.getKeys();
        int iLength = keys.length;
        int i = 0;
        while (i < iLength) {
            String key = keys[i];
            String value = "";
            Object[] comps = this.arrValuableComps.getValues(key);
            if (comps.length > 1) {
                int n = 0;
                while (n < comps.length) {
                    KDComponent comp = (KDComponent)comps[n];
                    if (comp instanceof KDToggleButton) {
                        ((KDToggleButton)comp).getModel().isSelected();
                        value = String.valueOf(n + 1);
                        break;
                    }
                    ++n;
                }
            } else {
                KDComponent comp = (KDComponent)comps[0];
                if (comp instanceof KDTextComponent) {
                    value = ((KDTextComponent)comp).getText();
                } else if (comp instanceof KDList) {
                    value = String.valueOf(((KDList)comp).getSelectedIndex() + 1);
                } else if (comp instanceof KDComboBox) {
                    value = String.valueOf(((KDComboBox)comp).getSelectedIndex() + 1);
                }
            }
            OutputElement eVar = new OutputElement("setvar", 2);
            eVar.addAttribute("name", key);
            eVar.addAttribute("value", value);
            eRefresh.add(eVar);
            ++i;
        }
        eForward.add(eRefresh);
        body.add(eForward);
    }

    private void addDoElement(KDFrame frame, OutputElement body) {
        ArrayList arrButton = this.arrButtonComps;
        int iButtonLength = arrButton.size();
        if (iButtonLength > 0) {
            KDButton btn1 = (KDButton)arrButton.get(0);
            OutputElement eDo1 = this.createDoElement("accept", btn1.getText(), btn1.getIdentifier(), 1001, btn1.getText());
            body.add(eDo1);
            if (iButtonLength > 1) {
                KDButton btn2 = (KDButton)arrButton.get(1);
                OutputElement eDo2 = this.createDoElement("options", btn2.getText(), btn2.getIdentifier(), 1001, btn2.getText());
                body.add(eDo2);
            }
        }
    }

    private OutputElement createDoElement(String sType, String sLabel, String sTarget, int iEvent, String sValue) {
        OutputElement eDo = new OutputElement("do");
        eDo.addAttribute("type", sType);
        eDo.addAttribute("label", sLabel);
        OutputElement eGo = new OutputElement("go");
        eGo.addAttribute("href", "#postArea");
        OutputElement eVar1 = this.createSetvarElement("kdsvt", sTarget);
        OutputElement eVar2 = this.createSetvarElement("kdsva", sValue);
        OutputElement eVar3 = this.createSetvarElement("kdsve", String.valueOf(iEvent));
        eGo.add(eVar1);
        eGo.add(eVar2);
        eGo.add(eVar3);
        eDo.add(eGo);
        return eDo;
    }

    private OutputElement createSetvarElement(String sName, String sValue) {
        OutputElement eVar = new OutputElement("setvar", 2);
        eVar.addAttribute("name", sName);
        eVar.addAttribute("value", sValue);
        return eVar;
    }

    private void addPostCard(KDFrame frame, OutputElement doc) {
        OutputElement ePostCard = new OutputElement("card");
        ePostCard.addAttribute("id", "postArea");
        OutputElement eForward = new OutputElement("onevent");
        eForward.addAttribute("type", "onenterforward");
        OutputElement eGo = this.createGoElement(frame);
        String[] keys = this.arrValuableComps.getKeys();
        int ikeyCount = keys.length;
        int i = 0;
        while (i < ikeyCount) {
            OutputElement eComponent = this.createPostfieldElement(keys[i], "$(" + keys[i] + ")");
            eGo.add(eComponent);
            ++i;
        }
        eForward.add(eGo);
        ePostCard.add(eForward);
        OutputElement eBackward = new OutputElement("onevent");
        eBackward.addAttribute("type", "onenterbackward");
        OutputElement ePrev = new OutputElement("prev", 2);
        eBackward.add(ePrev);
        ePostCard.add(eBackward);
        doc.add(ePostCard);
    }

    private void preLoadControls(KDRootPane rootPane) {
        Iterator items = rootPane.getContentPane().getChildrenMap().values().iterator();
        while (items.hasNext()) {
            KDComponent comp = (KDComponent)items.next();
            if (!(comp instanceof KDLabel) && !(comp instanceof KDButton)) {
                String strName = comp.getIdentifier();
                if (comp instanceof KDToggleButton && ((KDToggleButton)comp).getModel().getGroup() != null) {
                    strName = ((KDRadioButton)comp).getModel().getGroup().getName();
                }
                this.arrValuableComps.add(strName, comp);
            }
            if (!(comp instanceof KDButton)) continue;
            this.arrButtonComps.add(comp);
        }
    }

    private OutputElement createPostfieldElement(String sName, String sValue) {
        OutputElement ePost = new OutputElement("postfield", 2);
        ePost.addAttribute("name", sName);
        ePost.addAttribute("value", sValue);
        return ePost;
    }

    private OutputElement createGoElement(KDFrame w) {
        OutputElement eGo = new OutputElement("go");
        eGo.addAttribute("method", "post");
        eGo.addAttribute("href", w.getAppInstance().getName());
        OutputElement eTarget = this.createPostfieldElement("__EVENTTARGET", "$(kdsvt)");
        OutputElement eAction = this.createPostfieldElement("__EVENTTYPE", "$(kdsve)");
        OutputElement eArguments = this.createPostfieldElement("__EVENTARGUMENT", "$(kdsva)");
        OutputElement eCurWin = this.createPostfieldElement("__EVENTCURWIN", w.getIdentifier());
        eGo.add(eTarget);
        eGo.add(eAction);
        eGo.add(eArguments);
        eGo.add(eCurWin);
        return eGo;
    }
}

