/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.controls.KDContainer;
import com.kingdee.bos.web.anole.controls.KDFrame;
import com.kingdee.bos.web.anole.controls.KDWindow;
import com.kingdee.bos.web.anole.output.OutputDocument;
import com.kingdee.bos.web.anole.output.OutputElement;
import com.kingdee.bos.web.anole.plaf.UIManager;
import com.kingdee.bos.web.anole.runtime.HttpBrowserCapabilities;
import com.kingdee.bos.web.anole.runtime.ReportFrame;
import com.kingdee.bos.web.anole.runtime.RequestOptions;
import com.kingdee.bos.web.anole.utils.AnoleResourceBundle;
import com.kingdee.bos.web.anole.utils.LocaleInfo;
import com.kingdee.bos.web.anole.utils.Log4j;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class Application {
    public static final String DEFALUT_SCOPE = "all";
    public static final String SCOPE_ALL = "all";
    public static final String SCOPE_IE = "ie";
    public static final String SCOPE_POCKETIE = "pocketie";
    public static final String SCOPE_WAP12 = "wap12";
    private String scope = "all";
    private UIManager uiMgr = null;
    private HttpBrowserCapabilities browserCaps = null;
    private Map attributes = null;
    private Map windows = null;
    private PropertyChangeSupport propertyChangeSupport = null;
    private KDFrame mainWin = null;
    private String defaultwin = null;
    private RequestOptions requestOptions = null;
    private String name = null;
    private HttpServletResponse response;
    private LocaleInfo localeInfo;
    private boolean windowChanged = false;
    private Logger logger = Log4j.getInstance();
    private List arrNewWins = null;
    private Stack orderStack = null;
    private ResourceBundle myResources = AnoleResourceBundle.getInstance();

    public Application() {
        this.uiMgr = new UIManager();
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public UIManager getUIManager() {
        return this.uiMgr;
    }

    public HttpBrowserCapabilities getBrowserCaps() {
        return this.browserCaps;
    }

    public String getScope() {
        return this.scope;
    }

    public Object getAttribute(String key) {
        Object attribute = null;
        if (this.attributes != null) {
            attribute = this.attributes.get(key);
        }
        return attribute;
    }

    void setBrowserCaps(HttpBrowserCapabilities browserCaps) {
        this.browserCaps = browserCaps;
    }

    void setLocaleInfo(LocaleInfo info) {
        this.localeInfo = info;
    }

    public LocaleInfo getLocaleInfo() {
        return this.localeInfo;
    }

    void setScope(String scope) {
        this.scope = scope;
    }

    public void setWindowChanged(boolean windowChanged) {
        this.windowChanged = windowChanged;
    }

    void setDefaultWindow(String defaultWin) {
        this.defaultwin = defaultWin;
    }

    RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    public HttpSession getSession() {
        return this.requestOptions.getRequest().getSession(true);
    }

    public void setRequestOptions(RequestOptions opt) {
        this.requestOptions = opt;
        this.locateCurrentWindow();
    }

    public final void addWindow(KDWindow w) {
        if (this.windows == null) {
            this.windows = new HashMap();
        }
        if (this.arrNewWins == null) {
            this.arrNewWins = new ArrayList();
        }
        if (this.orderStack == null) {
            this.orderStack = new Stack();
        }
        if (w == null || this.windows.containsKey(w.getIdentifier())) {
            return;
        }
        w.setAppInstance(this);
        if (w.getWidth() == -1) {
            w.setWidth(10);
        }
        if (w.getHeight() == -1) {
            w.setHeight(10);
        }
        this.windows.put(w.getIdentifier(), w);
        this.arrNewWins.add(w);
        this.orderStack.push(w);
        this.windowChanged = true;
    }

    public final void update() {
        this.mainWin.updateContent(this.requestOptions);
    }

    public final void fireEvent() {
        this.windowChanged = false;
        this.arrNewWins.clear();
        this.mainWin.fireWindowOpened();
        this.mainWin.requestHandle(this.requestOptions);
    }

    public final void updateWindow(KDFrame w) {
        if (this.windows.containsKey(w.getIdentifier())) {
            this.windows.put(w.getIdentifier(), w);
        }
    }

    final void doInit() {
        KDFrame w = this.getDefaultWindow();
        this.addWindow(w);
        this.mainWin = w;
    }

    private KDFrame getDefaultWindow() {
        KDFrame w = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = null;
            try {
                c = cl.loadClass(this.defaultwin);
            }
            catch (Exception e) {
                c = this.getClass().getClassLoader().loadClass(this.defaultwin);
            }
            w = (KDFrame)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)(String.valueOf(this.myResources.getString("winclassnotfound")) + this.defaultwin));
            w = new ReportFrame(ReportFrame.ERROR_CODE_601);
        }
        catch (InstantiationException e) {
            this.logger.error((Object)e.toString());
            w = new ReportFrame(ReportFrame.ERROR_CODE_UNKOWN);
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)e.toString());
            w = new ReportFrame(ReportFrame.ERROR_CODE_UNKOWN);
        }
        catch (Throwable e) {
            this.logger.error((Object)e.toString());
        }
        return w;
    }

    public void render(HttpServletResponse response) throws IOException {
        response.setLocale(new Locale(this.getLocaleInfo().getLanguage()));
        response.setContentType(this.getBrowserCaps().getPreferredRenderingMime());
        if (this.windowChanged) {
            this.dealWindowChanged(response);
        }
        this.mainWin.paint(null);
        OutputDocument doc = this.mainWin.getUI().getDocument();
        doc.render(response.getWriter());
    }

    public final void doExit() {
        while (!this.windows.isEmpty()) {
            this.removeWindow((KDFrame)this.windows.values().iterator().next());
        }
        this.exit();
    }

    public final void doValidation() {
        Iterator it = this.windows.values().iterator();
        while (it.hasNext()) {
            this.doValidation((KDFrame)it.next());
        }
    }

    public void exit() {
    }

    public KDWindow[] getWindows() {
        return this.windows.values().toArray(new KDFrame[this.windows.size()]);
    }

    public KDFrame getWindow(String strID) {
        KDFrame w = null;
        if (!strID.equals("") && !this.windows.isEmpty()) {
            w = (KDFrame)this.windows.get(strID);
        }
        return w;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removeWindow(KDWindow w) {
        String idWin = w.getIdentifier();
        if (!this.windows.containsKey(idWin)) {
            return;
        }
        this.windows.remove(idWin);
        this.arrNewWins.remove(idWin);
        Stack tmpStack = new Stack();
        Object curW = this.orderStack.pop();
        while (curW != null && !((KDWindow)curW).getIdentifier().equals(idWin)) {
            tmpStack.push(curW);
            curW = this.orderStack.pop();
        }
        while (!tmpStack.isEmpty()) {
            this.orderStack.push(tmpStack.pop());
        }
        w.setAppInstance(null);
        this.windowChanged = true;
        w.fireWindowClosed();
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    private void doValidation(KDContainer c) {
        c.validate();
        int size = c.getComponentCount();
        int index = 0;
        while (index < size) {
            this.doValidation(c.getComponent(index));
            ++index;
        }
    }

    private void locateCurrentWindow() {
        String strCurWin = this.requestOptions.getEventCurrentWindow();
        if (strCurWin != null) {
            Object o = this.windows.get(strCurWin);
            this.mainWin = o != null ? (KDFrame)o : this.mainWin;
        }
    }

    private void dealWindowChanged(HttpServletResponse response) throws IOException {
        boolean flgClose = false;
        if (!this.windows.containsKey(this.mainWin.getIdentifier())) {
            if (!this.arrNewWins.isEmpty()) {
                this.mainWin = (KDFrame)this.arrNewWins.remove(0);
            } else {
                flgClose = true;
                if (!this.orderStack.isEmpty()) {
                    this.mainWin = (KDFrame)this.orderStack.peek();
                } else {
                    this.mainWin = this.getDefaultWindow();
                    this.mainWin.setAppInstance(this);
                }
            }
        } else if (this.windows.containsKey(this.mainWin.getIdentifier()) && this.browserCaps.isMobileDevice() && !this.arrNewWins.isEmpty()) {
            this.mainWin = (KDFrame)this.arrNewWins.remove(this.arrNewWins.size() - 1);
        }
        this.mainWin.fireWindowOpened();
        this.preRender(response, flgClose);
    }

    private void preRender(HttpServletResponse response, boolean flgClose) throws IOException {
        OutputElement eScript;
        if (!this.browserCaps.isMobileDevice() && flgClose) {
            eScript = new OutputElement("script");
            eScript.addAttribute("language", "javascript");
            eScript.setText("window.close();\n");
            eScript.render(response.getWriter());
        }
        if (!this.browserCaps.isMobileDevice() && !this.arrNewWins.isEmpty()) {
            eScript = new OutputElement("script");
            eScript.addAttribute("language", "javascript");
            int iCount = this.arrNewWins.size();
            StringBuffer sb = new StringBuffer();
            int i = iCount - 1;
            while (i >= 0) {
                KDFrame frame = (KDFrame)this.arrNewWins.get(i);
                String strUrl = String.valueOf(this.name) + "?" + "__EVENTCURWIN" + "=" + frame.getIdentifier();
                sb.append("window.open('" + strUrl + "','" + frame.getIdentifier() + "','resizable=yes,scrollbars=yes");
                if (frame.getWidth() == -1 || frame.getHeight() == -1) {
                    sb.append(");\n");
                } else {
                    sb.append(",width=" + frame.getWidth() + ",height=" + frame.getHeight() + "');\n");
                }
                --i;
            }
            eScript.setText(sb.toString());
            eScript.render(response.getWriter());
        }
    }
}

