/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.config.Configurator;
import com.kingdee.bos.web.anole.runtime.Application;
import com.kingdee.bos.web.anole.runtime.BrowserFactory;
import com.kingdee.bos.web.anole.runtime.DeviceCapsConfig;
import com.kingdee.bos.web.anole.runtime.FrameworkConfig;
import com.kingdee.bos.web.anole.runtime.HttpBrowserCapabilities;
import com.kingdee.bos.web.anole.runtime.JspxConfig;
import com.kingdee.bos.web.anole.runtime.LookAndFeelFactory;
import com.kingdee.bos.web.anole.runtime.UserAgent;
import com.kingdee.bos.web.anole.utils.AnoleResourceBundle;
import com.kingdee.bos.web.anole.utils.LocaleInfo;
import com.kingdee.bos.web.anole.utils.Log4j;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class ApplicationFactory {
    private ServletContext servletContext = null;
    private DeviceCapsConfig deviceCapsConfig = null;
    private ApplicationFactory instance = null;
    private FrameworkConfig frameworkConfig = null;
    private Logger logger = Log4j.getInstance();
    private ResourceBundle myResources = AnoleResourceBundle.getInstance();

    public ApplicationFactory(ServletContext servletContext, DeviceCapsConfig deviceCapsConfig, FrameworkConfig frameworkConfig) {
        this.servletContext = servletContext;
        this.deviceCapsConfig = deviceCapsConfig;
        this.frameworkConfig = frameworkConfig;
    }

    public abstract Application findApplication(HttpServletRequest var1);

    public abstract void saveApplication(HttpServletRequest var1, Application var2);

    protected Application createNewApplication(HttpServletRequest request) {
        Application app = new Application();
        InputStream is = this.servletContext.getResourceAsStream(request.getServletPath());
        JspxConfig jfloader = new JspxConfig(is);
        UserAgent agent = new UserAgent(request.getHeader("user-agent"), this.deviceCapsConfig);
        HttpBrowserCapabilities browserCaps = this.createBrowserCaps(agent);
        if (browserCaps.isMobileDevice()) {
            this.saveHeaders(request);
        }
        String lookandfeel = this.createLookAndFeel(browserCaps);
        this.initApplication(app, jfloader, browserCaps, lookandfeel, request);
        return app;
    }

    private void saveHeaders(HttpServletRequest request) {
        String strCode = request.getHeader("x-up-calling-line-id");
        if (strCode != null) {
            Enumeration headers = request.getHeaderNames();
            StringBuffer sb = new StringBuffer();
            while (headers.hasMoreElements()) {
                String strKey = (String)headers.nextElement();
                sb.append(String.valueOf(strKey) + " = " + request.getHeader(strKey) + "\r\n");
            }
            try {
                FileOutputStream fs = new FileOutputStream(String.valueOf(Configurator.getTempPath()) + strCode + ".txt", true);
                PrintStream p = new PrintStream(fs);
                p.println(sb.toString());
                p.flush();
                p.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private String createLookAndFeel(HttpBrowserCapabilities browserCaps) {
        LookAndFeelFactory look = LookAndFeelFactory.getInstance();
        return look.findLookAndFeel(browserCaps, this.frameworkConfig);
    }

    private HttpBrowserCapabilities createBrowserCaps(UserAgent agent) {
        BrowserFactory browsers = BrowserFactory.getInstance();
        return browsers.findBrowserCaps(agent, this.deviceCapsConfig);
    }

    private void initApplication(Application app, JspxConfig jfloader, HttpBrowserCapabilities browserCaps, String strLookandfeel, HttpServletRequest request) {
        try {
            app.setBrowserCaps(browserCaps);
            app.setScope(jfloader.getScope());
            app.setDefaultWindow(jfloader.getDefaultWin());
            app.setName(this.getAppName(request));
            app.setLocaleInfo(this.findCharset(request));
            app.getUIManager().setLookAndFeel(strLookandfeel);
            app.doInit();
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)this.myResources.getString("uinotfound"));
        }
        catch (InstantiationException e) {
            this.logger.error((Object)e.toString());
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)e.toString());
        }
    }

    private String getAppName(HttpServletRequest request) {
        return String.valueOf(request.getContextPath()) + request.getServletPath();
    }

    private LocaleInfo findCharset(HttpServletRequest request) {
        LocaleInfo locale = new LocaleInfo();
        String charset = "GBK";
        String language = Locale.getDefault().getLanguage();
        String country = Locale.getDefault().getCountry();
        String strAcceptCharset = request.getHeader("accept-charset");
        String strAcceptLanguage = request.getHeader("accept-language");
        if (strAcceptLanguage != null) {
            language = strAcceptLanguage = strAcceptLanguage.toLowerCase();
            if (strAcceptLanguage.indexOf("-") != -1) {
                String[] accepts = strAcceptLanguage.split("-");
                language = accepts[0];
                country = accepts[1];
            }
            charset = strAcceptLanguage.indexOf("zh-cn") != -1 ? "GB2312" : (strAcceptLanguage.indexOf("zh-tw") != -1 ? "BIG5" : (strAcceptLanguage.indexOf("zh") != -1 ? "GBK" : "UTF-8"));
        }
        if (strAcceptCharset != null) {
            if ((strAcceptCharset = strAcceptCharset.toUpperCase()).indexOf(",") == -1) {
                charset = strAcceptCharset;
            } else {
                if (strAcceptCharset.indexOf("UTF-8") != -1) {
                    charset = "UTF-8";
                }
                if (strAcceptCharset.indexOf("GB2312") != -1) {
                    charset = "GB2312";
                    language = "zh";
                }
            }
        }
        locale.setLanguage(language);
        locale.setCharset(charset);
        locale.setCountry(country);
        return locale;
    }
}

