/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client.async;

import javax.xml.namespace.QName;
import org.apache.axis.client.async.AsyncCall;
import org.apache.axis.client.async.IAsyncCallback;
import org.apache.axis.client.async.IAsyncResult;
import org.apache.axis.client.async.Status;

public class AsyncResult
implements IAsyncResult,
Runnable {
    private Thread thread = null;
    private Object response = null;
    private Throwable exception = null;
    private AsyncCall ac = null;
    private QName opName = null;
    private Object[] params = null;
    private Status status = Status.NONE;

    public AsyncResult(AsyncCall ac, QName opName, Object[] params) {
        this.ac = ac;
        this.opName = opName;
        this.params = params;
        if (opName == null) {
            this.opName = ac.getCall().getOperationName();
        }
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void abort() {
        this.thread.interrupt();
        this.status = Status.INTERRUPTED;
    }

    public Status getStatus() {
        return this.status;
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.thread.wait(timeout);
    }

    public Object getResponse() {
        return this.response;
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.response = this.ac.getCall().invoke(this.opName, this.params);
                this.status = Status.COMPLETED;
            }
            catch (Throwable e) {
                this.exception = e;
                this.status = Status.EXCEPTION;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IAsyncCallback callback = this.ac.getCallback();
            if (callback == null) throw throwable;
            callback.onCompletion(this);
            throw throwable;
        }
        {
            Object var2_4 = null;
            IAsyncCallback callback = this.ac.getCallback();
            if (callback == null) return;
            callback.onCompletion(this);
            return;
        }
    }
}

