/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class DefaultSocketFactory
implements SocketFactory {
    protected static Log log;
    public static String CONNECT_TIMEOUT;
    protected Hashtable attributes = null;
    private static boolean plain;
    private static Class inetClass;
    private static Constructor inetConstructor;
    private static Constructor socketConstructor;
    private static Method connect;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.components.net.DefaultSocketFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz.getName());
        CONNECT_TIMEOUT = "axis.client.connect.timeout";
        try {
            inetClass = Class.forName("java.net.InetSocketAddress");
            plain = false;
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            inetConstructor = inetClass.getConstructor(classArray);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            socketConstructor = clazz3.getConstructor(new Class[0]);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            connect = clazz4.getMethod("connect", inetClass.getSuperclass(), Integer.TYPE);
        }
        catch (Exception e) {
            plain = true;
        }
    }

    public DefaultSocketFactory(Hashtable attributes) {
        this.attributes = attributes;
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        int timeout = 0;
        if (this.attributes != null) {
            String value = (String)this.attributes.get(CONNECT_TIMEOUT);
            timeout = value != null ? Integer.parseInt(value) : 0;
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create("http");
        Socket sock = null;
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        if (tcp.getProxyUser().length() != 0) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(tcp.getProxyUser()).append(":").append(tcp.getProxyPassword());
            otherHeaders.append("Proxy-Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (port == -1) {
            port = 80;
        }
        if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0 || hostInNonProxyList) {
            sock = DefaultSocketFactory.create(host, port, timeout);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("createdHTTP00"));
            }
        } else {
            sock = DefaultSocketFactory.create(tcp.getProxyHost(), new Integer(tcp.getProxyPort()), timeout);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("createdHTTP01", tcp.getProxyHost(), tcp.getProxyPort()));
            }
            useFullURL.value = true;
        }
        return sock;
    }

    private static Socket create(String host, int port, int timeout) throws Exception {
        Socket sock = null;
        if (plain || timeout == 0) {
            sock = new Socket(host, port);
        } else {
            Object address = inetConstructor.newInstance(host, new Integer(port));
            sock = (Socket)socketConstructor.newInstance(new Object[0]);
            connect.invoke((Object)sock, address, new Integer(timeout));
        }
        return sock;
    }

    protected boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!DefaultSocketFactory.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (isCaseSensitive && ch != strArr[i]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl36
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl36:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl37:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl51
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl51:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl52:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl92
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block27: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (!(isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl92:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl93:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

