Create Table T_BD_AccountCurrency ( FID VARCHAR(44) NOT NULL ,FAccountViewID VARCHAR(44) NOT NULL ,FCurrencyID VARCHAR(44) NOT NULL ,CONSTRAINT PK_AccountCurrency PRIMARY KEY (FID));

Create Table T_BD_AccountLev ( FID VARCHAR(44) NOT NULL ,FLevel INT,FLength INT,FAccountTableID VARCHAR(44) NOT NULL ,CONSTRAINT PK_AccountLev PRIMARY KEY (FID));

Create Table T_BD_AccountRef ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime NOT NULL ,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime NOT NULL ,FSrcTableID VARCHAR(44) NOT NULL ,FSrcAccountID VARCHAR(44) NOT NULL ,FDesTableID VARCHAR(44) NOT NULL ,FDesAccountID VARCHAR(44) NOT NULL ,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,CONSTRAINT PK_AccountRef PRIMARY KEY (FID));

Create Table T_BD_AccountTable ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FIsControlNumber INT DEFAULT 0,FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FIsUseSeparator INT,FSeparator CHAR(1),FIsUserLevel INT,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,CONSTRAINT PK_AccountTable PRIMARY KEY (FID));

Create Table T_BD_AccountType ( FID VARCHAR(44) NOT NULL ,FAccountTableID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80) NOT NULL ,FLongNumber NVARCHAR(200) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FParentID VARCHAR(44),FLevel INT NOT NULL ,FIsLeaf INT NOT NULL ,FProperty INT NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FDisplayName_L1 NVARCHAR(80),FDisplayName_L2 NVARCHAR(80),FDisplayName_L3 NVARCHAR(80),CONSTRAINT PK_AccountType PRIMARY KEY (FID));

Create Table T_BD_AccountView ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(256),FName_L2 NVARCHAR(256),FName_L3 NVARCHAR(256),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(40),FIsLeaf INT,FLevel INT,FLongNumber NVARCHAR(200),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FAccountTableID VARCHAR(44) NOT NULL ,FAccountTypeID VARCHAR(44) NOT NULL ,FLongName_L1 NVARCHAR(512),FLongName_L2 NVARCHAR(512),FLongName_L3 NVARCHAR(512),FParentID VARCHAR(44),FIsGFreeze INT,FGAA VARCHAR(44),FIsCFreeze INT,FHelpCode NVARCHAR(80),FCompanyID VARCHAR(44),FCurrencyID VARCHAR(44),FDC INT,FIsChangeCurrency INT,FIsCashEquivalent INT,FIsCountAccrual INT,FAccrualPer NUMERIC(28,10),FIsQty INT,FMeasureUnitGroupID VARCHAR(44),FMeasureUnitID VARCHAR(44),FAC INT,FPLType INT,FControl INT,FCAA VARCHAR(44),FAcctCurrency INT,FIsBank INT,FIsCash INT,FhasUserProperty INT DEFAULT 0,FAccountID VARCHAR(44),FGLevel INT NOT NULL ,FIsAllowCA INT DEFAULT 1 NOT NULL ,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FUpperID VARCHAR(44),FParentAAID VARCHAR(44),FIsUpperAllowCA INT DEFAULT 1 NOT NULL ,FIsSelfFreeze INT DEFAULT 0 NOT NULL ,FIsParentFreeze INT DEFAULT 0 NOT NULL ,FRefID VARCHAR(44),FControlLevel INT NOT NULL ,FIsOutDailyAccount INT,FDisplayName_L1 NVARCHAR(512),FDisplayName_L2 NVARCHAR(512),FDisplayName_L3 NVARCHAR(512),FACNotice INT DEFAULT 0 NOT NULL , FBw int DEFAULT 0,CONSTRAINT PK_BD_AccountView PRIMARY KEY (FID));

Create Table T_BD_AcctRefContrast ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FEnabledAcctTableID VARCHAR(44),FDisabledAcctTableID VARCHAR(44),FIsEnabled INT,FEnabledTime DateTime,FContrastTime DateTime,FEnabledPeriodID VARCHAR(44),FIsIncludeFreezeAcct INT,FRefType int DEFAULT 1,CONSTRAINT PK_AcctRC PRIMARY KEY (FID));

Create Table T_BD_AcctRefContrastEntry ( FID VARCHAR(44) NOT NULL ,FAcctRefContrastID VARCHAR(44),FOldAcctID VARCHAR(44),FNewAcctID VARCHAR(44),FOldAcctNumber NVARCHAR(80),FOldAcctName_L1 NVARCHAR(255),FOldAcctName_L2 NVARCHAR(255),FOldAcctName_L3 NVARCHAR(255),FSeq INT,CONSTRAINT PK_AcctRCEntry PRIMARY KEY (FID));

Create Table T_BD_Acct_Contorl ( FID VARCHAR(44) NOT NULL ,FAccountTableID VARCHAR(44) NOT NULL ,FHelpCode INT DEFAULT 0 NOT NULL ,FDC INT DEFAULT 0 NOT NULL ,FCurrencyID INT DEFAULT 0 NOT NULL ,FIsChangeCurrency INT DEFAULT 0 NOT NULL ,FIsCash INT DEFAULT 0 NOT NULL ,FIsCashEquivalent INT DEFAULT 0 NOT NULL ,FIsCountAccrual INT DEFAULT 0 NOT NULL ,FAccrualPer INT DEFAULT 0 NOT NULL ,FIsQty INT DEFAULT 0 NOT NULL ,FMeasureUnitGroupID INT DEFAULT 0 NOT NULL ,FMeasureUnitID INT DEFAULT 0 NOT NULL ,FAC INT DEFAULT 0 NOT NULL ,FControl INT DEFAULT 0 NOT NULL ,FPLType INT DEFAULT 0 NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FSrcCu VARCHAR(44),FDestCu VARCHAR(44) NOT NULL ,FIsDefaultForRefer INT DEFAULT 0 NOT NULL ,FACNotice INT DEFAULT 0 NOT NULL ,FBw int DEFAULT 0,CONSTRAINT PK_Account_Control PRIMARY KEY (FID));

--科目表增加创建财务组织字段
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCompanyID' and KSQL_COL_TABNAME='T_BD_AccountTable')
ALTER TABLE T_BD_AccountTable ADD FCompanyID VARCHAR(44) null;

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSrcCu' and KSQL_COL_TABNAME='T_BD_Acct_Contorl' and KSQL_COL_NULLABLE = 'N')
ALTER TABLE T_BD_Acct_Contorl ALTER COLUMN FSrcCu VARCHAR(44) null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSrcCompanyID' and KSQL_COL_TABNAME='T_BD_Acct_Contorl')
ALTER TABLE T_BD_Acct_Contorl ADD FSrcCompanyID VARCHAR(44) null;

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDestCu' and KSQL_COL_TABNAME='T_BD_Acct_Contorl' and KSQL_COL_NULLABLE = 'N')
ALTER TABLE T_BD_Acct_Contorl ALTER COLUMN FDestCu VARCHAR(44) null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDestCompanyID' and KSQL_COL_TABNAME='T_BD_Acct_Contorl')
ALTER TABLE T_BD_Acct_Contorl ADD FDestCompanyID VARCHAR(44) null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCompanyID' and KSQL_COL_TABNAME='T_BD_AcctRefContrast')
ALTER TABLE T_BD_AcctRefContrast ADD FCompanyID VARCHAR(44) null;

--“科目”表增加字段"主表现金流量项目"
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMainCashFlowItemID' AND KSQL_COL_TABNAME='T_BD_AccountView')
ALTER TABLE T_BD_AccountView ADD FMainCashFlowItemID VARCHAR(44); 

--“科目”表增加字段"附表现金流量项目"
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAttCashFlowItemID' AND KSQL_COL_TABNAME='T_BD_AccountView')
ALTER TABLE T_BD_AccountView ADD FAttCashFlowItemID VARCHAR(44); 
